
package org.mule.devkit.it.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.it.BasicModule;
import org.mule.devkit.it.adapters.BasicModuleProcessAdapter;


/**
 * PassthruComplexLongMessageProcessor invokes the {@link org.mule.devkit.it.BasicModule#passthruComplexLong(java.lang.Long)} method in {@link BasicModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4-SNAPSHOT", date = "2012-07-27T01:17:46-05:00", comments = "Build UNKNOWN_BUILDNUMBER")
public class PassthruComplexLongMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Startable, Stoppable, MessageProcessor
{

    protected Object value;
    protected Long _valueType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets value
     * 
     * @param value Value to set
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(BasicModuleProcessAdapter.class, false);
            final Long _transformedValue = ((Long) evaluateAndTransform(getMuleContext(), event, PassthruComplexLongMessageProcessor.class.getDeclaredField("_valueType").getGenericType(), null, value));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((BasicModule) object).passthruComplexLong(_transformedValue);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("passthruComplexLong"), event, e);
        }
    }

}
