/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.language.server.modules.editorManager;

import amf.core.remote.Aml$;
import amf.core.remote.Oas20$;
import amf.core.remote.Raml08$;
import amf.core.remote.Raml10$;
import java.io.Serializable;
import org.mulesoft.language.common.dtoTypes.IChangedDocument;
import org.mulesoft.language.common.dtoTypes.IDocumentChangeExecutor;
import org.mulesoft.language.common.dtoTypes.IOpenedDocument;
import org.mulesoft.language.common.dtoTypes.ITextEdit;
import org.mulesoft.language.server.common.utils.PathRefine$;
import org.mulesoft.language.server.core.AbstractServerModule;
import org.mulesoft.language.server.core.IServerModule;
import org.mulesoft.language.server.core.connections.IServerConnection;
import org.mulesoft.language.server.modules.commonInterfaces.IAbstractTextEditorWithCursor;
import org.mulesoft.language.server.modules.editorManager.IEditorManagerModule;
import org.mulesoft.language.server.modules.editorManager.TextEditorInfo;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001=\u0011Q\"\u00123ji>\u0014X*\u00198bO\u0016\u0014(BA\u0002\u0005\u00035)G-\u001b;pe6\u000bg.Y4fe*\u0011QAB\u0001\b[>$W\u000f\\3t\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0013)\t\u0001\u0002\\1oOV\fw-\u001a\u0006\u0003\u00171\t\u0001\"\\;mKN|g\r\u001e\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011\u0001B2pe\u0016L!!\u0006\n\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<fe6{G-\u001e7f!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\u000bJ\u000b\u0012LGo\u001c:NC:\fw-\u001a:N_\u0012,H.\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"a\u0006\u0001\t\u000f}\u0001!\u0019!C\u0001A\u0005\u0011Rn\u001c3vY\u0016$U\r]3oI\u0016t7-[3t+\u0005\t\u0003c\u0001\u0012&O5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0003BeJ\f\u0017\u0010\u0005\u0002)_9\u0011\u0011&\f\t\u0003U\rj\u0011a\u000b\u0006\u0003Y9\ta\u0001\u0010:p_Rt\u0014B\u0001\u0018$\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u001a\u0003BB\u001a\u0001A\u0003%\u0011%A\nn_\u0012,H.\u001a#fa\u0016tG-\u001a8dS\u0016\u001c\b\u0005C\u00046\u0001\u0001\u0007I\u0011\u0001\u001c\u0002\u0017U\u0014\u0018\u000eV8FI&$xN]\u000b\u0002oA!\u0001(P\u0014@\u001b\u0005I$B\u0001\u001e<\u0003\u001diW\u000f^1cY\u0016T!\u0001P\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002?s\t\u0019Q*\u00199\u0011\u0005]\u0001\u0015BA!\u0003\u00059!V\r\u001f;FI&$xN]%oM>Dqa\u0011\u0001A\u0002\u0013\u0005A)A\bve&$v.\u00123ji>\u0014x\fJ3r)\t)\u0005\n\u0005\u0002#\r&\u0011qi\t\u0002\u0005+:LG\u000fC\u0004J\u0005\u0006\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004L\u0001\u0001\u0006KaN\u0001\rkJLGk\\#eSR|'\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0001O\u0003]!wnY;nK:$8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u00148/F\u0001P!\rA\u0004KU\u0005\u0003#f\u0012aAQ;gM\u0016\u0014\b\u0003\u0002\u0012T+\u0016K!\u0001V\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001,\\\u001b\u00059&B\u0001-Z\u0003!!Go\u001c+za\u0016\u001c(B\u0001.\t\u0003\u0019\u0019w.\\7p]&\u0011Al\u0016\u0002\u0011\u0013\u000eC\u0017M\\4fI\u0012{7-^7f]RDqA\u0018\u0001A\u0002\u0013\u0005q,A\u000ee_\u000e,X.\u001a8u\u0007\"\fgnZ3MSN$XM\\3sg~#S-\u001d\u000b\u0003\u000b\u0002Dq!S/\u0002\u0002\u0003\u0007q\n\u0003\u0004c\u0001\u0001\u0006KaT\u0001\u0019I>\u001cW/\\3oi\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feN\u0004\u0003b\u00023\u0001\u0001\u0004%\t!Z\u0001\u0017I>\u001cW/\\3oi\u000eC\u0017M\\4f\u000bb,7-\u001e;peV\ta\rE\u0002#O&L!\u0001[\u0012\u0003\r=\u0003H/[8o!\t1&.\u0003\u0002l/\n9\u0012\nR8dk6,g\u000e^\"iC:<W-\u0012=fGV$xN\u001d\u0005\b[\u0002\u0001\r\u0011\"\u0001o\u0003i!wnY;nK:$8\t[1oO\u0016,\u00050Z2vi>\u0014x\fJ3r)\t)u\u000eC\u0004JY\u0006\u0005\t\u0019\u00014\t\rE\u0004\u0001\u0015)\u0003g\u0003]!wnY;nK:$8\t[1oO\u0016,\u00050Z2vi>\u0014\b\u0005C\u0003t\u0001\u0011\u0005C/\u0001\u0004mCVt7\r\u001b\u000b\u0002kB\u0019a/_>\u000e\u0003]T!\u0001_\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003u^\u00141\u0001\u0016:z!\t\tB0\u0003\u0002~%\ti\u0011jU3sm\u0016\u0014Xj\u001c3vY\u0016Daa \u0001\u0005\u0002\u0005\u0005\u0011\u0001E8o\u0007\"\fgnZ3E_\u000e,X.\u001a8u)\u0015)\u00151AA\u0004\u0011\u0019\t)A a\u0001%\u0006AA.[:uK:,'\u000fC\u0005\u0002\ny\u0004\n\u00111\u0001\u0002\f\u0005YQO\\:vEN\u001c'/\u001b2f!\r\u0011\u0013QB\u0005\u0004\u0003\u001f\u0019#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003%9W\r^#eSR|'\u000f\u0006\u0003\u0002\u0018\u0005\u0015\u0002\u0003\u0002\u0012h\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?!\u0011\u0001E2p[6|g.\u00138uKJ4\u0017mY3t\u0013\u0011\t\u0019#!\b\u0003;%\u000b%m\u001d;sC\u000e$H+\u001a=u\u000b\u0012LGo\u001c:XSRD7)\u001e:t_JDq!a\n\u0002\u0012\u0001\u0007q%\u0001\u0003`kJL\u0007bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u000f_:|\u0005/\u001a8E_\u000e,X.\u001a8u)\r)\u0015q\u0006\u0005\t\u0003c\tI\u00031\u0001\u00024\u0005AAm\\2v[\u0016tG\u000fE\u0002W\u0003kI1!a\u000eX\u0005=Iu\n]3oK\u0012$unY;nK:$\bbBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u001ag\u0016$Hi\\2v[\u0016tGo\u00115b]\u001e,W\t_3dkR|'\u000fF\u0002F\u0003\u007fAq!!\u0011\u0002:\u0001\u0007\u0011.\u0001\u0005fq\u0016\u001cW\u000f^8s\u0011\u0019\t)\u0005\u0001C\u0001K\u0006Ir-\u001a;E_\u000e,X.\u001a8u\u0007\"\fgnZ3Fq\u0016\u001cW\u000f^8s\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\n!\u0003Z8dk6,g\u000e^,bg\u000eC\u0017M\\4fIR\u0019Q)!\u0014\t\u000f\u0005E\u0012q\ta\u0001+\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013aD8o\u00072|7/\u001a#pGVlWM\u001c;\u0015\u0007\u0015\u000b)\u0006C\u0004\u0002X\u0005=\u0003\u0019A\u0014\u0002\u0007U\u0014\u0018\u000eC\u0004\u0002\\\u0001!\t!!\u0018\u0002!=t7\t[1oO\u0016\u0004vn]5uS>tG#B#\u0002`\u0005\u0005\u0004bBA,\u00033\u0002\ra\n\u0005\t\u0003G\nI\u00061\u0001\u0002f\u0005A\u0001o\\:ji&|g\u000eE\u0002#\u0003OJ1!!\u001b$\u0005\rIe\u000e\u001e\u0005\b\u0003[\u0002A\u0011AA8\u0003E!W\r^3s[&tW\rT1oOV\fw-\u001a\u000b\u0006O\u0005E\u0014Q\u000f\u0005\b\u0003g\nY\u00071\u0001(\u0003\r)(\u000f\u001c\u0005\b\u0003o\nY\u00071\u0001(\u0003\u0011!X\r\u001f;\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u0005yA-\u001a;fe6Lg.Z*z]R\f\u0007\u0010F\u0003(\u0003\u007f\n\t\tC\u0004\u0002t\u0005e\u0004\u0019A\u0014\t\u000f\u0005]\u0014\u0011\u0010a\u0001O!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0013qQ\u0001\u001b_:\u001c\u0005.\u00198hK\u0012{7-^7f]R$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013SC!a\u0003\u0002\f.\u0012\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018\u000e\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY*!%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class EditorManager
extends AbstractServerModule
implements IEditorManagerModule {
    private final String[] moduleDependencies;
    private Map<String, TextEditorInfo> uriToEditor;
    private Buffer<Function1<IChangedDocument, BoxedUnit>> documentChangeListeners;
    private Option<IDocumentChangeExecutor> documentChangeExecutor;
    private final String moduleId;

    @Override
    public String moduleId() {
        return this.moduleId;
    }

    @Override
    public void org$mulesoft$language$server$modules$editorManager$IEditorManagerModule$_setter_$moduleId_$eq(String x$1) {
        this.moduleId = x$1;
    }

    @Override
    public String[] moduleDependencies() {
        return this.moduleDependencies;
    }

    public Map<String, TextEditorInfo> uriToEditor() {
        return this.uriToEditor;
    }

    public void uriToEditor_$eq(Map<String, TextEditorInfo> x$1) {
        this.uriToEditor = x$1;
    }

    public Buffer<Function1<IChangedDocument, BoxedUnit>> documentChangeListeners() {
        return this.documentChangeListeners;
    }

    public void documentChangeListeners_$eq(Buffer<Function1<IChangedDocument, BoxedUnit>> x$1) {
        this.documentChangeListeners = x$1;
    }

    public Option<IDocumentChangeExecutor> documentChangeExecutor() {
        return this.documentChangeExecutor;
    }

    public void documentChangeExecutor_$eq(Option<IDocumentChangeExecutor> x$1) {
        this.documentChangeExecutor = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Try<IServerModule> launch() {
        Success success;
        Try<IServerModule> superLaunch = super.launch();
        if (superLaunch.isSuccess()) {
            IServerConnection qual$1 = this.connection();
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)document -> {
                this.onOpenDocument(document);
                return BoxedUnit.UNIT;
            };
            boolean x$2 = qual$1.onOpenDocument$default$2();
            qual$1.onOpenDocument((Function1<IOpenedDocument, BoxedUnit>)x$1, x$2);
            IServerConnection qual$2 = this.connection();
            Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)document -> {
                this.documentWasChanged(document);
                return BoxedUnit.UNIT;
            };
            boolean x$4 = qual$2.onChangeDocument$default$2();
            qual$2.onChangeDocument((Function1<IChangedDocument, BoxedUnit>)x$3, x$4);
            IServerConnection qual$3 = this.connection();
            Function2 & Serializable & scala.Serializable x$5 = (Function2 & Serializable & scala.Serializable)(uri, position) -> {
                this.onChangePosition(uri, BoxesRunTime.unboxToInt((Object)position));
                return BoxedUnit.UNIT;
            };
            boolean x$6 = qual$3.onChangePosition$default$2();
            qual$3.onChangePosition((Function2<String, Object, BoxedUnit>)x$5, x$6);
            IServerConnection qual$4 = this.connection();
            Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)uri -> {
                this.onCloseDocument(uri);
                return BoxedUnit.UNIT;
            };
            boolean x$8 = qual$4.onCloseDocument$default$2();
            qual$4.onCloseDocument((Function1<String, BoxedUnit>)x$7, x$8);
            success = new Success((Object)this);
        } else {
            void var1_1;
            success = var1_1;
        }
        return success;
    }

    @Override
    public void onChangeDocument(Function1<IChangedDocument, BoxedUnit> listener, boolean unsubscribe) {
        if (unsubscribe) {
            int index = this.documentChangeListeners().indexOf(listener);
            if (index != -1) {
                this.documentChangeListeners().remove(index);
            }
        } else {
            this.documentChangeListeners().$plus$eq(listener);
        }
    }

    @Override
    public boolean onChangeDocument$default$2() {
        return false;
    }

    @Override
    public Option<IAbstractTextEditorWithCursor> getEditor(String _uri) {
        Option option;
        String uri = _uri;
        uri = PathRefine$.MODULE$.refinePath(uri, this.platform());
        this.connection().debugDetail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked for uri ", ", while having following editors registered: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})) + this.uriToEditor().keys().mkString(","), "EditorManager", "onOpenDocument");
        Option directResult = this.uriToEditor().get((Object)uri);
        if (directResult.isDefined()) {
            option = directResult;
        } else if (uri.startsWith("file://") || uri.startsWith("FILE://")) {
            None$ found = None$.MODULE$;
            if (uri.startsWith("file:///") || uri.startsWith("FILE:///")) {
                String path = uri.substring("file:///".length()).replace("%5C", "\\");
                Option result = this.uriToEditor().get((Object)path);
                if (result.isDefined()) {
                    found = result;
                }
            }
            if (found.isEmpty()) {
                String path = uri.substring("file://".length()).replace("%5C", "\\");
                Option result = this.uriToEditor().get((Object)path);
                if (result.isDefined()) {
                    found = result;
                }
            }
            option = found;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void onOpenDocument(IOpenedDocument document) {
        this.connection().debug("Document is opened", "EditorManager", "onOpenDocument");
        String language = this.determineLanguage(document.uri(), document.text());
        String syntax = this.determineSyntax(document.uri(), document.text());
        this.uriToEditor().update((Object)PathRefine$.MODULE$.refinePath(document.uri(), this.platform()), (Object)new TextEditorInfo(document.uri(), document.version(), document.text(), language, syntax, this.connection()));
        this.documentChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.apply((Object)new IChangedDocument(document.uri(), document.version(), (Option<String>)new Some((Object)document.text()), (Option<Seq<ITextEdit>>)None$.MODULE$));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setDocumentChangeExecutor(IDocumentChangeExecutor executor) {
        this.documentChangeExecutor_$eq((Option<IDocumentChangeExecutor>)new Some((Object)executor));
    }

    public Option<IDocumentChangeExecutor> getDocumentChangeExecutor() {
        return this.documentChangeExecutor();
    }

    public void documentWasChanged(IChangedDocument document) {
        this.connection().debug("Document is changed", "EditorManager", "onChangeDocument");
        this.connection().debugDetail("Text is:\n " + document.text(), "EditorManager", "onChangeDocument");
        String refinedUri = PathRefine$.MODULE$.refinePath(document.uri(), this.platform());
        Option current = this.uriToEditor().get((Object)refinedUri);
        if (current.isDefined()) {
            int currentVersion = ((TextEditorInfo)current.get()).version();
            String currentText = ((TextEditorInfo)current.get()).text();
            if (currentVersion == document.version()) {
                this.connection().debugDetail("Version of the reported change is equal to the previous one", "EditorManager", "onChangeDocument");
                return;
            }
            if (document.version() < currentVersion) {
                Option<String> option = document.text();
                String string = currentText;
                if (!(option != null ? !option.equals((Object)string) : string != null)) {
                    this.connection().debugDetail("No changes detected", "EditorManager", "onChangeDocument");
                    return;
                }
            }
        }
        String language = this.determineLanguage(refinedUri, (String)document.text().get());
        String syntax = this.determineSyntax(refinedUri, (String)document.text().get());
        this.uriToEditor().update((Object)refinedUri, (Object)new TextEditorInfo(refinedUri, document.version(), (String)document.text().get(), language, syntax, this.connection()));
        this.documentChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.apply((Object)document);
            return BoxedUnit.UNIT;
        });
    }

    public void onCloseDocument(String uri) {
        this.uriToEditor().remove((Object)PathRefine$.MODULE$.refinePath(uri, this.platform()));
    }

    public void onChangePosition(String uri, int position) {
        block0: {
            Option<IAbstractTextEditorWithCursor> editorOption = this.getEditor(uri);
            if (!editorOption.isDefined()) break block0;
            ((TextEditorInfo)editorOption.get()).setCursorPosition(position);
        }
    }

    public String determineLanguage(String url, String text) {
        return url.endsWith(".raml") ? (text.startsWith("#%RAML 1.0") ? Raml10$.MODULE$.toString() : Raml08$.MODULE$.toString()) : ((url.endsWith(".yaml") || url.endsWith(".yml")) && text.startsWith("#%") ? Aml$.MODULE$.toString() : Oas20$.MODULE$.toString());
    }

    public String determineSyntax(String url, String text) {
        return text.trim().startsWith("{") ? "JSON" : "YAML";
    }

    public EditorManager() {
        IEditorManagerModule.$init$(this);
        this.moduleDependencies = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.uriToEditor = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentChangeListeners = (Buffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentChangeExecutor = None$.MODULE$;
    }
}

