/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvErrorCallback;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvProcessTransport;
import com.tibco.tibrv.TibrvQueue;

public class Tibrv {
    private static int VERSION_MAJOR = 7;
    private static int VERSION_MINOR = 5;
    private static int VERSION_UPDATE = 1;
    private static String VERSION_STRING = "7.5.1";
    public static final int IMPL_SELECT = 0;
    public static final int IMPL_JAVA = 1;
    public static final int IMPL_NATIVE = 2;
    private static boolean _valid = false;
    private static boolean _haveLib = false;
    private static boolean _closed = false;
    protected static boolean _closing = false;
    private static Object _tibrvLock = new Object();
    private static int _tibrvOpenCount = 0;
    private static TibrvQueue _defQueue = null;
    private static TibrvProcessTransport _procTport = null;
    protected static TibrvImpl _impl = null;
    private static TibrvErrorCallback _errorCB = null;
    private static boolean _loaded = false;

    private Tibrv() {
    }

    public static int getMajorVersion() {
        return VERSION_MAJOR;
    }

    public static int getMinorVersion() {
        return VERSION_MINOR;
    }

    public static int getUpdateVersion() {
        return VERSION_UPDATE;
    }

    public static String getVersionString() {
        return Tibrv.getVersion();
    }

    public static String getVersion() {
        return VERSION_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCmVersion() throws TibrvException {
        Object object = _tibrvLock;
        synchronized (object) {
            block4: {
                if (!_valid || _impl == null) break block4;
                String string = _impl.getCmVersion();
                return string;
            }
        }
        throw new TibrvException(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFtVersion() throws TibrvException {
        Object object = _tibrvLock;
        synchronized (object) {
            block4: {
                if (!_valid || _impl == null) break block4;
                String string = _impl.getFtVersion();
                return string;
            }
        }
        throw new TibrvException(4);
    }

    public static boolean isNativeImpl() {
        return _haveLib;
    }

    public static boolean isValid() {
        return _valid && _impl != null;
    }

    public static void setErrorCallback(TibrvErrorCallback tibrvErrorCallback) {
        _errorCB = tibrvErrorCallback;
    }

    public static TibrvErrorCallback getErrorCallback() {
        return _errorCB;
    }

    public static TibrvQueue defaultQueue() {
        return _defQueue;
    }

    public static TibrvProcessTransport processTransport() {
        return _procTport;
    }

    public static void open() throws TibrvException {
        Tibrv.open(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(int n) throws TibrvException {
        Object object = _tibrvLock;
        synchronized (object) {
            if (_valid) {
                if (n == 0 || n == 2 && Tibrv.isNativeImpl() || n == 1 && !Tibrv.isNativeImpl()) {
                    ++_tibrvOpenCount;
                    return;
                }
                throw new TibrvException("Tibrv already open using different implementation", 27);
            }
            switch (n) {
                case 0: {
                    try {
                        Tibrv.loadLib();
                    }
                    catch (TibrvException tibrvException) {
                        _haveLib = false;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Tibrv.loadLib();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid implementation parameter");
                }
            }
            _valid = true;
            try {
                Tibrv.initTibrv();
            }
            catch (Throwable throwable) {
                _closed = false;
                _valid = false;
                _impl = null;
                _defQueue = null;
                _procTport = null;
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof TibrvException) {
                    throw (TibrvException)throwable;
                }
                throw new TibrvException("Exception during initialization: " + throwable.getClass().getName(), 1, throwable);
            }
            _closed = false;
            ++_tibrvOpenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() throws TibrvException {
        Object object = _tibrvLock;
        synchronized (object) {
            if (!_valid) {
                throw new TibrvException(4);
            }
            if (--_tibrvOpenCount > 0) {
                return;
            }
            _tibrvOpenCount = 0;
            _closing = true;
            _impl.close();
            _impl = null;
            _closed = true;
            _closing = false;
            _valid = false;
            _haveLib = false;
            _defQueue = null;
            _procTport = null;
        }
    }

    protected static void checkValid() throws TibrvException {
        if (!_valid || _impl == null) {
            if (_closed || _closing) {
                throw new TibrvException("Tibrv has been closed", 4);
            }
            throw new TibrvException("Tibrv not initialized", 4);
        }
    }

    protected static void checkValidOrClosing() throws TibrvException {
        if (!_valid || _impl == null || _closing) {
            if (_closed || _closing) {
                throw new TibrvException("Tibrv has been closed", 4);
            }
            throw new TibrvException("Tibrv not initialized", 4);
        }
    }

    private static void initTibrv() throws TibrvException {
        String string = Tibrv.isNativeImpl() ? "C" : "J";
        try {
            _impl = (TibrvImpl)Class.forName("com.tibco.tibrv.TibrvImpl" + string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TibrvException(904, (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            throw new TibrvException(1, (Throwable)exception);
        }
        _impl.open(VERSION_MAJOR, VERSION_MINOR, VERSION_UPDATE);
        _defQueue = new TibrvQueue(true);
        _procTport = new TibrvProcessTransport();
    }

    protected static Object createObjectImpl(String string) throws TibrvException {
        Tibrv.checkValid();
        String string2 = "";
        String string3 = Tibrv.isNativeImpl() ? "C" : "J";
        string3 = "com.tibco.tibrv." + string + string3;
        Object var3_3 = null;
        try {
            var3_3 = Class.forName(string3).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            var3_3 = null;
            string2 = "Class not found: " + string3;
        }
        catch (InstantiationException instantiationException) {
            var3_3 = null;
            string2 = "InstantiationException while creating " + string3;
        }
        catch (IllegalAccessException illegalAccessException) {
            var3_3 = null;
            string2 = "IllegalAccessException while creating " + string3;
        }
        if (var3_3 == null) {
            throw new TibrvException(string2, 1);
        }
        return var3_3;
    }

    private static void loadLib() throws TibrvException {
        if (_haveLib) {
            return;
        }
        if (_loaded) {
            _haveLib = true;
            return;
        }
        String string = "tibrvj";
        try {
            Class.forName("com.tibco.tibrv.TibrvSdContext");
            string = "tibrvjsd";
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String string2 = System.getProperty("sun.arch.data.model");
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.name");
        if (!("OSF1".equals(string4) || "ia64".equals(string3) && "Linux".equals(string4) || string2 == null || !"64".equals(string2) || System.getProperty("os.name") == null || System.getProperty("os.name").indexOf("Windows") != -1)) {
            string = string + "64";
        }
        try {
            System.loadLibrary(string);
            Tibrv.initLib();
            _haveLib = true;
            _loaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new TibrvException("Library not found: " + string, 901, unsatisfiedLinkError);
        }
        catch (SecurityException securityException) {
            throw new TibrvException("SecurityException occurred while loading library " + string, 902, securityException);
        }
    }

    private static native void initLib() throws TibrvException;
}

