/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvCmTransport;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplCmTPortC;
import com.tibco.tibrv.TibrvRvdTransport;

public class TibrvCmQueueTransport
extends TibrvCmTransport {
    public static final double DEFAULT_COMPLETE_TIME = 0.0;
    public static final int DEFAULT_WORKER_WEIGHT = 1;
    public static final int DEFAULT_WORKER_TASKS = 1;
    public static final int DEFAULT_SCHEDULER_WEIGHT = 1;
    public static final double DEFAULT_SCHEDULER_HEARTBEAT = 1.0;
    public static final double DEFAULT_SCHEDULER_ACTIVATION = 3.5;
    private double _completeTime = 0.0;
    private int _workerWeight = 1;
    private int _workerTasks = 1;

    public TibrvCmQueueTransport(TibrvRvdTransport tibrvRvdTransport, String string) throws TibrvException {
        this._create(tibrvRvdTransport, string, 1, 1, 1, 1.0, 3.5);
    }

    public TibrvCmQueueTransport(TibrvRvdTransport tibrvRvdTransport, String string, int n, int n2, int n3, double d, double d2) throws TibrvException {
        this._create(tibrvRvdTransport, string, n, n2, n3, d, d2);
    }

    private void _create(TibrvRvdTransport tibrvRvdTransport, String string, int n, int n2, int n3, double d, double d2) throws TibrvException {
        if (string == null) {
            throw new IllegalArgumentException("cmName is null");
        }
        if (tibrvRvdTransport == null) {
            throw new IllegalArgumentException("transport is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative workerWeight");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative workerTasks");
        }
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("schedulerWeight out of range");
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        tibrvRvdTransport.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!Tibrv.isNativeImpl()) {
            throw new TibrvException("Must use native implementation", 27);
        }
        this._impl = new TibrvImplCmTPortC();
        Object[] objectArray = new Object[]{tibrvRvdTransport, string, new Integer(n), new Integer(n2), new Integer(n3), new Double(d), new Double(d2)};
        ((TibrvImplCmTPortC)this._impl).createCMDist(this, objectArray);
        this._tport = tibrvRvdTransport;
        this._cmName = string;
        this._workerWeight = n;
        this._workerTasks = n2;
        this._valid = true;
        tibrvImpl.register(this);
    }

    public boolean isValid() {
        return super.isValid();
    }

    public void destroy() {
        super.destroy();
    }

    public TibrvRvdTransport getTransport() {
        return super.getTransport();
    }

    public String getName() {
        return super.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleteTime(double d) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).cmdSetCompleteTime(d);
            this._completeTime = d;
        }
    }

    public double getCompleteTime() {
        return this._completeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskBacklogLimitInBytes(int n) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).cmdSetTaskBacklogLimitInBytes(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskBacklogLimitInMessages(int n) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).cmdSetTaskBacklogLimitInMessages(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkerWeight(int n) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).cmdSetWorkerWeight(n);
            this._workerWeight = n;
        }
    }

    public int getWorkerWeight() {
        return this._workerWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkerTasks(int n) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).cmdSetWorkerTasks(n);
            this._workerTasks = n;
        }
    }

    public int getWorkerTasks() {
        return this._workerTasks;
    }

    private TibrvCmQueueTransport() throws TibrvException {
        Tibrv.checkValid();
    }
}

