/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvCryptFilter;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TibrvEncrypted {
    byte[] contents;

    TibrvEncrypted(byte[] byArray) {
        this.contents = byArray;
    }

    void wrapArray(byte[] byArray, TibrvCryptFilter tibrvCryptFilter, short s) {
        byte[] byArray2 = tibrvCryptFilter != null ? tibrvCryptFilter.encrypt(byArray) : byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TibrvEncrypted.writeStructured(byteArrayOutputStream, byArray2, s);
        this.contents = byteArrayOutputStream.toByteArray();
    }

    public TibrvEncrypted(byte[] byArray, TibrvCryptFilter tibrvCryptFilter) {
        this.wrapArray(byArray, tibrvCryptFilter, (short)7);
    }

    public TibrvEncrypted(TibrvMsg tibrvMsg, TibrvCryptFilter tibrvCryptFilter) throws TibrvException {
        byte[] byArray = tibrvMsg.getAsBytes();
        this.wrapArray(byArray, tibrvCryptFilter, (short)1);
    }

    public String toString() {
        return "TibrvEncrypted[" + this.contents.length + " encrypted bytes]";
    }

    public Object decrypt(TibrvCryptFilter tibrvCryptFilter) throws TibrvException {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.contents));
            int n = dataInputStream.readInt();
            n -= 9;
            if (dataInputStream.readInt() != -1722421573) {
                throw new TibrvException("Invalid Message Header", 42);
            }
            byte by = dataInputStream.readByte();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray, 0, n);
            dataInputStream.close();
            if (tibrvCryptFilter != null) {
                byArray = tibrvCryptFilter.decrypt(byArray);
            }
            if (by == 7) {
                return byArray;
            }
            if (by == 1) {
                return new TibrvMsg(byArray);
            }
            throw new TibrvException("Invalid Message Header", 42);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static void writeStructured(OutputStream outputStream, byte[] byArray, short s) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(byArray.length + 9);
            dataOutputStream.writeInt(-1722421573);
            dataOutputStream.writeByte((byte)s);
            dataOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

