/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvFtMemberCallback;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvImplTPortC;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;

public class TibrvFtMember
extends TibrvEvent {
    public static final String ADV_SOURCE = "RVFT";
    public static final int PREPARE_TO_ACTIVATE = 1;
    public static final int ACTIVATE = 2;
    public static final int DEACTIVATE = 3;
    private String _groupName = null;
    private int _weight = 0;
    private int _activeGoal = 0;
    private double _heartbeatInterval = 0.0;
    private double _preparationInterval = 0.0;
    private double _activationInterval = 0.0;
    private TibrvTransport _tport = null;

    public TibrvFtMember(TibrvQueue tibrvQueue, TibrvFtMemberCallback tibrvFtMemberCallback, TibrvTransport tibrvTransport, String string, int n, int n2, double d, double d2, double d3, Object object) throws TibrvException {
        if (!Tibrv.isNativeImpl()) {
            throw new TibrvException("Native implementation required", 27);
        }
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (tibrvFtMemberCallback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (tibrvTransport == null) {
            throw new IllegalArgumentException("transport is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("groupName is null");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("weight is out of range");
        }
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("activeGoal is out of range");
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!(tibrvTransport instanceof TibrvRvdTransport)) {
            throw new TibrvException("TibrvRvdTransport is required", 2);
        }
        TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvTransport._impl;
        if (!tibrvTransport.isValid() || tibrvImplTPortC == null) {
            throw new TibrvException(2);
        }
        TibrvImplQueue tibrvImplQueue = tibrvQueue._impl;
        if (!tibrvQueue.isValid() || tibrvImplQueue == null) {
            throw new TibrvException(62);
        }
        this._queue = tibrvQueue;
        this._callback = tibrvFtMemberCallback;
        this._tport = tibrvTransport;
        this._groupName = string;
        this._closure = object;
        this._weight = n;
        this._activeGoal = n2;
        this._heartbeatInterval = d;
        this._preparationInterval = d2;
        this._activationInterval = d3;
        this.natCreate(tibrvImplTPortC._handle, ((TibrvImplQueueC)tibrvImplQueue)._handle, TibrvMsg.defStringToBytes(this._groupName), this._weight, this._activeGoal, this._heartbeatInterval, this._preparationInterval, this._activationInterval);
        tibrvImpl.register(this);
        this._valid = true;
    }

    public void destroy() {
        this.destroyImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyImpl() {
        block10: {
            try {
                boolean bl = false;
                TibrvImpl tibrvImpl = null;
                Object object = this._lock;
                synchronized (object) {
                    tibrvImpl = Tibrv._impl;
                    Tibrv.checkValid();
                    if (tibrvImpl == null) {
                        return;
                    }
                    if (!this._valid) {
                        return;
                    }
                    this._valid = false;
                    this._queue = null;
                    this._tport = null;
                    this._callback = null;
                    bl = true;
                }
                if (!bl) break block10;
                try {
                    if (tibrvImpl != null) {
                        tibrvImpl.unregister(this);
                    }
                    this.natDestroy();
                }
                catch (TibrvException tibrvException) {
                    // empty catch block
                }
                super.destroy();
            }
            catch (TibrvException tibrvException) {
                // empty catch block
            }
        }
    }

    public TibrvQueue getQueue() {
        return super.getQueue();
    }

    public TibrvTransport getTransport() {
        return this._tport;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public int getActiveGoal() {
        return this._activeGoal;
    }

    public double getHeartbeatInterval() {
        return this._heartbeatInterval;
    }

    public double getPreparationInterval() {
        return this._preparationInterval;
    }

    public double getActivationInterval() {
        return this._activationInterval;
    }

    public int getWeight() {
        return this._weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWeight(int n) throws TibrvException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("weight is out of range");
        }
        Object object = this._lock;
        synchronized (object) {
            this.natSetWeight(n);
            this._weight = n;
        }
    }

    private TibrvFtMember() throws TibrvException {
    }

    private void invoke(int n) {
        Object object = this._callback;
        if (object != null && object instanceof TibrvFtMemberCallback) {
            ((TibrvFtMemberCallback)object).onFtAction(this, this._groupName, n);
        }
    }

    private native void natCreate(int var1, int var2, byte[] var3, int var4, int var5, double var6, double var8, double var10) throws TibrvException;

    private native void natDestroy() throws TibrvException;

    private native void natSetWeight(int var1) throws TibrvException;
}

