/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvFtMonitorCallback;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvImplTPortC;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;

public class TibrvFtMonitor
extends TibrvEvent {
    private String _groupName = null;
    private double _lostInterval = 0.0;
    private TibrvTransport _tport = null;

    public TibrvFtMonitor(TibrvQueue tibrvQueue, TibrvFtMonitorCallback tibrvFtMonitorCallback, TibrvTransport tibrvTransport, String string, double d, Object object) throws TibrvException {
        if (!Tibrv.isNativeImpl()) {
            throw new TibrvException("Native implementation required", 27);
        }
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (tibrvFtMonitorCallback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (tibrvTransport == null) {
            throw new IllegalArgumentException("transport is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("groupName is null");
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!(tibrvTransport instanceof TibrvRvdTransport)) {
            throw new TibrvException("TibrvRvdTransport is required", 2);
        }
        TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvTransport._impl;
        if (!tibrvTransport.isValid() || tibrvImplTPortC == null) {
            throw new TibrvException(2);
        }
        TibrvImplQueue tibrvImplQueue = tibrvQueue._impl;
        if (!tibrvQueue.isValid() || tibrvImplQueue == null) {
            throw new TibrvException(62);
        }
        this._queue = tibrvQueue;
        this._callback = tibrvFtMonitorCallback;
        this._tport = tibrvTransport;
        this._groupName = string;
        this._closure = object;
        this._lostInterval = d;
        this.natCreate(tibrvImplTPortC._handle, ((TibrvImplQueueC)tibrvImplQueue)._handle, TibrvMsg.defStringToBytes(this._groupName), this._lostInterval);
        tibrvImpl.register(this);
        this._valid = true;
    }

    public void destroy() {
        this.destroyImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() {
        boolean bl = false;
        TibrvImpl tibrvImpl = null;
        Object object = this._lock;
        synchronized (object) {
            tibrvImpl = Tibrv._impl;
            if (!Tibrv.isValid()) {
                return;
            }
            if (tibrvImpl == null) {
                return;
            }
            if (!this._valid) {
                return;
            }
            this._valid = false;
            this._queue = null;
            this._tport = null;
            this._callback = null;
            bl = true;
        }
        if (bl) {
            try {
                if (tibrvImpl != null) {
                    tibrvImpl.unregister(this);
                }
                this.natDestroy();
            }
            catch (TibrvException tibrvException) {
                // empty catch block
            }
            super.destroy();
        }
    }

    public TibrvTransport getTransport() {
        return this._tport;
    }

    public String getGroupName() {
        return this._groupName;
    }

    private TibrvFtMonitor() throws TibrvException {
    }

    private void invoke(int n) {
        Object object = this._callback;
        if (object != null && object instanceof TibrvFtMonitorCallback) {
            ((TibrvFtMonitorCallback)object).onFtMonitor(this, this._groupName, n);
        }
    }

    private native void natCreate(int var1, int var2, byte[] var3, double var4) throws TibrvException;

    private native void natDestroy() throws TibrvException;
}

