/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvDispatcher;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplRepl;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvQueueGroup;
import com.tibco.tibrv.TibrvTimer;
import com.tibco.tibrv.TibrvTransport;
import java.util.Vector;

abstract class TibrvImpl {
    Vector _transports = null;
    Vector _events = null;
    Vector _queues = null;
    Vector _queueGroups = null;
    Vector _dispatchers = null;

    TibrvImpl() {
    }

    public abstract String getCmVersion() throws TibrvException;

    public abstract String getFtVersion() throws TibrvException;

    public abstract void open(int var1, int var2, int var3) throws TibrvException;

    public abstract void close() throws TibrvException;

    public abstract void createTimer(TibrvTimer var1) throws TibrvException;

    public abstract void readdTimer(TibrvTimer var1);

    public abstract void destroyTimer(TibrvTimer var1);

    public abstract void resetInterval(TibrvTimer var1, double var2) throws TibrvException;

    public void createDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    public void signalDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    public void destroyDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    private boolean notInitError(int n) {
        return n == 2 || n == 63 || n == 62 || n == 60 || n == 907 || n == 4;
    }

    public synchronized void destroyAll() throws TibrvException {
        this.destroyDispatchers();
        this.destroyTransports();
        this.destroyQueues();
        this.destroyQueueGroups();
        this.destroyEvents();
        this.destroyRegistry();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void destroyTransports() throws TibrvException {
        if (this._transports != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (TibrvTransport)this._transports.firstElement();
            this._transports.removeElementAt(0);
            if (!var1_1.isValid()) continue;
            var1_1.destroyImpl();
lbl7:
            // 3 sources

            ** while (this._transports.size() > 0)
        }
lbl8:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public synchronized void destroyQueues() throws TibrvException {
        if (this._queues != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (TibrvQueue)this._queues.firstElement();
            this._queues.removeElementAt(0);
            if (!var1_1.isValid()) continue;
            var1_1.destroyImpl();
lbl7:
            // 3 sources

            ** while (this._queues.size() > 0)
        }
lbl8:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public synchronized void destroyQueueGroups() throws TibrvException {
        if (this._queueGroups != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (TibrvQueueGroup)this._queueGroups.firstElement();
            this._queueGroups.removeElementAt(0);
            if (!var1_1.isValid()) continue;
            var1_1.destroy();
lbl7:
            // 3 sources

            ** while (this._queueGroups.size() > 0)
        }
lbl8:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public synchronized void destroyDispatchers() throws TibrvException {
        if (this._dispatchers != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (TibrvDispatcher)this._dispatchers.firstElement();
            this._dispatchers.removeElementAt(0);
            var1_1.destroy();
lbl6:
            // 2 sources

            ** while (this._dispatchers.size() > 0)
        }
lbl7:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public synchronized void destroyEvents() throws TibrvException {
        if (this._events != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = (TibrvEvent)this._events.firstElement();
            this._events.removeElementAt(0);
            this.destroyEvent(var1_1);
lbl6:
            // 2 sources

            ** while (this._events.size() > 0)
        }
lbl7:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueueEvents(TibrvQueue tibrvQueue) throws TibrvException {
        TibrvEvent tibrvEvent;
        int n;
        Vector<TibrvEvent> vector = null;
        TibrvImpl tibrvImpl = this;
        synchronized (tibrvImpl) {
            if (this._events == null) {
                return;
            }
            vector = new Vector<TibrvEvent>();
            n = 0;
            while (n < this._events.size()) {
                tibrvEvent = (TibrvEvent)this._events.elementAt(n);
                if (tibrvEvent.getQueue() == tibrvQueue) {
                    vector.addElement(tibrvEvent);
                }
                ++n;
            }
        }
        n = 0;
        while (n < vector.size()) {
            tibrvEvent = (TibrvEvent)vector.elementAt(n);
            this.destroyEvent(tibrvEvent);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTransportDependents(TibrvTransport tibrvTransport) {
        TibrvTransport tibrvTransport2;
        TibrvEvent tibrvEvent;
        int n;
        Vector<TibrvEvent> vector = null;
        Vector<TibrvTransport> vector2 = null;
        TibrvImpl tibrvImpl = this;
        synchronized (tibrvImpl) {
            if (this._events != null) {
                vector = new Vector<TibrvEvent>();
                n = 0;
                while (n < this._events.size()) {
                    tibrvEvent = (TibrvEvent)this._events.elementAt(n);
                    tibrvTransport2 = tibrvEvent.getDependTport();
                    if (tibrvTransport2 != null && tibrvTransport2 == tibrvTransport) {
                        vector.addElement(tibrvEvent);
                    }
                    ++n;
                }
            }
            if (this._transports != null) {
                vector2 = new Vector<TibrvTransport>();
                n = 0;
                while (n < this._transports.size()) {
                    tibrvTransport2 = (TibrvTransport)this._transports.elementAt(n);
                    TibrvTransport tibrvTransport3 = tibrvTransport2.getDependTport();
                    if (tibrvTransport3 != null && tibrvTransport3 == tibrvTransport) {
                        vector2.addElement(tibrvTransport2);
                    }
                    ++n;
                }
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                tibrvTransport2 = (TibrvTransport)vector2.elementAt(n);
                this.destroyTport(tibrvTransport2);
                ++n;
            }
        }
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                tibrvEvent = (TibrvEvent)vector.elementAt(n);
                this.destroyEvent(tibrvEvent);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyEvent(TibrvEvent tibrvEvent) {
        if (tibrvEvent.isValid()) {
            if (tibrvEvent instanceof TibrvImplRepl) {
                TibrvEvent tibrvEvent2 = tibrvEvent;
                synchronized (tibrvEvent2) {
                    tibrvEvent.notifyAll();
                }
            }
            tibrvEvent.destroy();
        }
    }

    private void destroyTport(TibrvTransport tibrvTransport) {
        if (tibrvTransport.isValid()) {
            tibrvTransport.destroy();
        }
    }

    public synchronized void register(Object object) throws TibrvException {
        if (this._transports == null) {
            throw new TibrvException("Tibrv is not open", 4);
        }
        if (object instanceof TibrvTransport) {
            this._transports.insertElementAt(object, 0);
        } else if (object instanceof TibrvEvent) {
            this._events.addElement(object);
        } else if (object instanceof TibrvQueue) {
            this._queues.addElement(object);
        } else if (object instanceof TibrvQueueGroup) {
            this._queueGroups.addElement(object);
        } else if (object instanceof TibrvDispatcher) {
            this._dispatchers.addElement(object);
        }
    }

    public synchronized void unregister(Object object) {
        if (this._transports == null) {
            return;
        }
        if (object instanceof TibrvTransport) {
            this._transports.removeElement(object);
        } else if (object instanceof TibrvEvent) {
            this._events.removeElement(object);
        } else if (object instanceof TibrvQueue) {
            this._queues.removeElement(object);
        } else if (object instanceof TibrvQueueGroup) {
            this._queueGroups.removeElement(object);
        } else if (object instanceof TibrvDispatcher) {
            this._dispatchers.removeElement(object);
        }
    }

    public synchronized void createRegistry() {
        this._transports = new Vector();
        this._events = new Vector();
        this._queues = new Vector();
        this._queueGroups = new Vector();
        this._dispatchers = new Vector();
    }

    public synchronized void destroyRegistry() {
        this._transports = null;
        this._events = null;
        this._queues = null;
        this._queueGroups = null;
        this._dispatchers = null;
    }
}

