/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvDispatcher;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplQGroup;
import com.tibco.tibrv.TibrvImplQGroupC;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvQueueGroup;
import com.tibco.tibrv.TibrvTimer;

class TibrvImplC
extends TibrvImpl {
    protected TibrvImplC() {
    }

    public String getCmVersion() throws TibrvException {
        return this.natGetCmVersion();
    }

    public String getFtVersion() throws TibrvException {
        return this.natGetFtVersion();
    }

    public void open(int n, int n2, int n3) throws TibrvException {
        this.createRegistry();
        int n4 = this.natOpenLib(n, n2, n3);
        int n5 = n4 >>> 16 & 0xFF;
        int n6 = n4 >>> 8 & 0xFF;
        int n7 = n4 >>> 0 & 0xFF;
        if (n5 != n || n6 != n2) {
            throw new TibrvException("Version mismatch: version of the .jar file " + n + "." + n2 + "." + n3 + " does not match the library version " + n5 + "." + n6 + "." + n7, 22);
        }
    }

    public void close() throws TibrvException {
        this.destroyAll();
        this.natCloseLib();
    }

    public void getDispHandles(TibrvDispatcher tibrvDispatcher, int[] nArray) throws TibrvException {
        nArray[0] = 0;
        nArray[1] = 0;
        TibrvDispatchable tibrvDispatchable = tibrvDispatcher.getDispatchable();
        if (tibrvDispatchable instanceof TibrvQueue) {
            try {
                TibrvImplQueue tibrvImplQueue = ((TibrvQueue)tibrvDispatchable)._impl;
                nArray[0] = ((TibrvImplQueueC)tibrvImplQueue)._handle;
            }
            catch (Exception exception) {
                throw new TibrvException(62);
            }
        } else {
            try {
                TibrvImplQGroup tibrvImplQGroup = ((TibrvQueueGroup)tibrvDispatchable)._impl;
                nArray[1] = ((TibrvImplQGroupC)tibrvImplQGroup)._handle;
                return;
            }
            catch (Exception exception) {
                throw new TibrvException(63);
            }
        }
    }

    public void createDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
        int[] nArray = new int[2];
        this.getDispHandles(tibrvDispatcher, nArray);
        this.natCreateDisp(tibrvDispatcher, nArray[0], nArray[1]);
    }

    public void signalDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
        this.natSignalDisp(tibrvDispatcher);
    }

    public void destroyDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
        this.natDestroyDisp(tibrvDispatcher);
    }

    public void createTimer(TibrvTimer tibrvTimer) throws TibrvException {
        try {
            TibrvImplQueue tibrvImplQueue = tibrvTimer.getQueue()._impl;
            if (tibrvTimer.getQueue().isValid()) {
                this.natCreateTimer(tibrvTimer, ((TibrvImplQueueC)tibrvImplQueue)._handle, tibrvTimer._interval);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new TibrvException(62);
    }

    public synchronized void readdTimer(TibrvTimer tibrvTimer) {
    }

    public void destroyTimer(TibrvTimer tibrvTimer) {
        try {
            this.natDestroyTimer(tibrvTimer);
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    public void resetInterval(TibrvTimer tibrvTimer, double d) throws TibrvException {
        this.natResetInterval(tibrvTimer, d);
    }

    private native int natOpenLib(int var1, int var2, int var3) throws TibrvException;

    private native void natCloseLib() throws TibrvException;

    private native void natCreateDisp(TibrvDispatcher var1, int var2, int var3) throws TibrvException;

    private native void natSignalDisp(TibrvDispatcher var1) throws TibrvException;

    private native void natDestroyDisp(TibrvDispatcher var1) throws TibrvException;

    private native void natCreateTimer(TibrvTimer var1, int var2, double var3) throws TibrvException;

    private native void natDestroyTimer(TibrvTimer var1) throws TibrvException;

    private native void natResetInterval(TibrvTimer var1, double var2) throws TibrvException;

    private native String natGetCmVersion() throws TibrvException;

    private native String natGetFtVersion() throws TibrvException;
}

