/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplHttpRequest;
import com.tibco.tibrv.TibrvImplRvaHttp;
import com.tibco.tibrv.TibrvMsg;
import java.util.Vector;

class TibrvImplHttpReqThread
extends Thread {
    Vector requestQueue = new Vector();
    TibrvImplRvaHttp parent = null;
    boolean valid = true;

    TibrvImplHttpReqThread(TibrvImplRvaHttp tibrvImplRvaHttp) {
        super("Tibrv Http Request Thread");
        this.parent = tibrvImplRvaHttp;
        try {
            this.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start();
        Thread.yield();
    }

    public void run() {
        while (this.valid) {
            try {
                if (this.isInterrupted()) break;
                this.handleRequest();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate() {
        Vector vector;
        Vector vector2 = this.requestQueue;
        synchronized (vector2) {
            this.valid = false;
            vector = (Vector)this.requestQueue.clone();
            this.requestQueue.removeAllElements();
        }
        int n = 0;
        while (n < vector.size()) {
            TibrvImplHttpRequest tibrvImplHttpRequest;
            TibrvImplHttpRequest tibrvImplHttpRequest2 = tibrvImplHttpRequest = (TibrvImplHttpRequest)vector.elementAt(n);
            synchronized (tibrvImplHttpRequest2) {
                tibrvImplHttpRequest.ready = true;
                tibrvImplHttpRequest.notifyAll();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(TibrvImplHttpRequest tibrvImplHttpRequest) throws TibrvException {
        Vector vector = this.requestQueue;
        synchronized (vector) {
            if (!this.valid) {
                throw new TibrvException(2);
            }
            this.requestQueue.addElement(tibrvImplHttpRequest);
            this.requestQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRequest() throws InterruptedException {
        Vector vector;
        Vector vector2 = this.requestQueue;
        synchronized (vector2) {
            if (this.requestQueue.size() == 0) {
                this.requestQueue.wait();
            }
            vector = (Vector)this.requestQueue.clone();
            this.requestQueue.removeAllElements();
        }
        int n = 0;
        while (n < vector.size()) {
            TibrvImplHttpRequest tibrvImplHttpRequest;
            TibrvException tibrvException = null;
            TibrvMsg tibrvMsg = null;
            TibrvImplHttpRequest tibrvImplHttpRequest2 = (TibrvImplHttpRequest)vector.elementAt(n);
            if (!this.parent.valid) {
                tibrvImplHttpRequest = tibrvImplHttpRequest2;
                synchronized (tibrvImplHttpRequest) {
                    tibrvImplHttpRequest2.ready = true;
                    tibrvImplHttpRequest2.exception = new TibrvException(2);
                    tibrvImplHttpRequest2.error = 1;
                    tibrvImplHttpRequest2.notifyAll();
                }
            }
            try {
                tibrvMsg = this.parent.executeHttpRequest(tibrvImplHttpRequest2.requestMsg);
                tibrvException = null;
            }
            catch (TibrvException tibrvException2) {
                tibrvMsg = null;
                tibrvException = tibrvException2;
            }
            tibrvImplHttpRequest2.exception = tibrvException;
            if (tibrvException == null) {
                tibrvImplHttpRequest2.replyMsg = tibrvMsg;
                tibrvImplHttpRequest2.error = 0;
            } else {
                tibrvImplHttpRequest2.replyMsg = null;
                tibrvImplHttpRequest2.error = 1;
            }
            tibrvImplHttpRequest = tibrvImplHttpRequest2;
            synchronized (tibrvImplHttpRequest) {
                tibrvImplHttpRequest2.ready = true;
                tibrvImplHttpRequest2.notifyAll();
            }
            ++n;
        }
    }
}

