/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;

final class TibrvImplMsgBuffer {
    byte[] bytes = null;
    int offset = 0;
    int buflen = 0;
    int mark = 0;
    private char[] chars = null;
    private static final byte _QUEST = 63;
    private static final int _MIN_CHARS_LEN = 256;

    private static final byte chartobyte_8859_1(char c) {
        if (c <= '\u00ff') {
            return (byte)c;
        }
        return 63;
    }

    private static final byte chartobyte_cp1252(char c) {
        if (c <= '\u007f') {
            return (byte)c;
        }
        if (c >= '\u00a0' && c <= '\u00ff') {
            return (byte)c;
        }
        if (c >= '\u0080' && c <= '\u009f') {
            return 63;
        }
        switch (c) {
            case '\u20ac': {
                return -128;
            }
            case '\u201a': {
                return -126;
            }
            case '\u0192': {
                return -125;
            }
            case '\u201e': {
                return -124;
            }
            case '\u2026': {
                return -123;
            }
            case '\u2020': {
                return -122;
            }
            case '\u2021': {
                return -121;
            }
            case '\u02c6': {
                return -120;
            }
            case '\u2030': {
                return -119;
            }
            case '\u0160': {
                return -118;
            }
            case '\u2039': {
                return -117;
            }
            case '\u0152': {
                return -116;
            }
            case '\u017d': {
                return -114;
            }
            case '\u2018': {
                return -111;
            }
            case '\u2019': {
                return -110;
            }
            case '\u201c': {
                return -109;
            }
            case '\u201d': {
                return -108;
            }
            case '\u2022': {
                return -107;
            }
            case '\u2013': {
                return -106;
            }
            case '\u2014': {
                return -105;
            }
            case '\u02dc': {
                return -104;
            }
            case '\u2122': {
                return -103;
            }
            case '\u0161': {
                return -102;
            }
            case '\u203a': {
                return -101;
            }
            case '\u0153': {
                return -100;
            }
            case '\u017e': {
                return -98;
            }
            case '\u0178': {
                return -97;
            }
        }
        return 63;
    }

    private static final char bytetochar_cp1252(byte by) {
        int n = by & 0xFF;
        if (n <= 127 || n >= 160) {
            return (char)n;
        }
        switch (n) {
            case 128: {
                return '\u20ac';
            }
            case 129: {
                return '\ufffd';
            }
            case 130: {
                return '\u201a';
            }
            case 131: {
                return '\u0192';
            }
            case 132: {
                return '\u201e';
            }
            case 133: {
                return '\u2026';
            }
            case 134: {
                return '\u2020';
            }
            case 135: {
                return '\u2021';
            }
            case 136: {
                return '\u02c6';
            }
            case 137: {
                return '\u2030';
            }
            case 138: {
                return '\u0160';
            }
            case 139: {
                return '\u2039';
            }
            case 140: {
                return '\u0152';
            }
            case 141: {
                return '\ufffd';
            }
            case 142: {
                return '\u017d';
            }
            case 143: {
                return '\ufffd';
            }
            case 144: {
                return '\ufffd';
            }
            case 145: {
                return '\u2018';
            }
            case 146: {
                return '\u2019';
            }
            case 147: {
                return '\u201c';
            }
            case 148: {
                return '\u201d';
            }
            case 149: {
                return '\u2022';
            }
            case 150: {
                return '\u2013';
            }
            case 151: {
                return '\u2014';
            }
            case 152: {
                return '\u02dc';
            }
            case 153: {
                return '\u2122';
            }
            case 154: {
                return '\u0161';
            }
            case 155: {
                return '\u203a';
            }
            case 156: {
                return '\u0153';
            }
            case 157: {
                return '\ufffd';
            }
            case 158: {
                return '\u017e';
            }
            case 159: {
                return '\u0178';
            }
        }
        return '\u0000';
    }

    static final boolean is8859_1(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith("8859-1") || string.endsWith("8859_1");
    }

    public TibrvImplMsgBuffer() {
        this.buflen = 2048;
        this.bytes = new byte[this.buflen];
    }

    public TibrvImplMsgBuffer(int n) {
        this.bytes = new byte[n];
        this.buflen = this.bytes.length;
    }

    public TibrvImplMsgBuffer(byte[] byArray) {
        this.bytes = byArray;
        this.buflen = byArray.length;
    }

    public TibrvImplMsgBuffer(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.offset = n;
        this.buflen = n + n2;
    }

    final void ensure(int n) {
        if (this.offset + n > this.buflen) {
            int n2 = (this.offset + n) * 2;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.bytes, 0, byArray, 0, this.offset);
            this.bytes = byArray;
            this.buflen = n2;
        }
    }

    final void mark() {
        this.mark = this.offset;
    }

    final void resetmark() {
        this.offset = this.mark;
    }

    final int getOffset() {
        return this.offset;
    }

    final void setOffset(int n) {
        this.offset = n;
    }

    final void skip(int n) throws EOFException {
        if (this.offset + n > this.buflen) {
            throw new EOFException();
        }
        this.offset += n;
    }

    final void write(byte[] byArray) {
        this.ensure(byArray.length);
        if (byArray.length > 0) {
            System.arraycopy(byArray, 0, this.bytes, this.offset, byArray.length);
        }
        this.offset += byArray.length;
    }

    final void write(byte[] byArray, int n, int n2) {
        this.ensure(n2);
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.bytes, this.offset, n2);
        }
        this.offset += n2;
    }

    final void writeByte(int n) {
        this.ensure(1);
        this.bytes[this.offset++] = (byte)n;
    }

    final void writeShort(int n) {
        this.ensure(2);
        this.bytes[this.offset++] = (byte)(n >>> 8);
        this.bytes[this.offset++] = (byte)n;
    }

    final void writeChar(int n) {
        this.ensure(2);
        this.bytes[this.offset++] = (byte)(n >>> 8);
        this.bytes[this.offset++] = (byte)n;
    }

    final void writeInt(int n) {
        this.ensure(4);
        this.offset += 4;
        int n2 = 1;
        while (n2 <= 4) {
            this.bytes[this.offset - n2] = (byte)n;
            ++n2;
            n >>>= 8;
        }
    }

    final void writeLong(long l) {
        this.ensure(8);
        this.offset += 8;
        int n = 1;
        while (n <= 8) {
            this.bytes[this.offset - n] = (byte)l;
            ++n;
            l >>>= 8;
        }
    }

    final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    final void readFully(byte[] byArray) throws EOFException {
        int n = byArray.length;
        if (n > 0) {
            if (this.offset + n > this.buflen) {
                throw new EOFException();
            }
            System.arraycopy(this.bytes, this.offset, byArray, 0, n);
            this.offset += n;
        }
    }

    final void readFully(byte[] byArray, int n, int n2) throws EOFException {
        if (n2 > 0) {
            if (this.offset + n2 > this.buflen) {
                throw new EOFException();
            }
            System.arraycopy(this.bytes, this.offset, byArray, n, n2);
            this.offset += n2;
        }
    }

    final byte readByte() throws EOFException {
        if (this.offset >= this.buflen) {
            throw new EOFException();
        }
        return this.bytes[this.offset++];
    }

    final short readShort() throws EOFException {
        if (this.offset + 2 > this.buflen) {
            throw new EOFException();
        }
        return (short)((this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF));
    }

    final int readInt() throws EOFException {
        if (this.offset + 4 > this.buflen) {
            throw new EOFException();
        }
        return (this.bytes[this.offset++] << 24) + (this.bytes[this.offset++] << 16 & 0xFF0000) + (this.bytes[this.offset++] << 8 & 0xFF00) + (this.bytes[this.offset++] & 0xFF);
    }

    final long readLong() throws EOFException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    final float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    final double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    final int readUnsignedByte() throws EOFException {
        if (this.offset >= this.buflen) {
            throw new EOFException();
        }
        return this.bytes[this.offset++] & 0xFF;
    }

    byte[] writeString(String string, String string2, boolean bl) throws TibrvException {
        if (string2 == null) {
            int n = string.length();
            this.ensure(n);
            char c = '\u0001';
            int n2 = 0;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!bl && c == '\u0000') {
                    throw new TibrvException("Non-zero byte at offset " + n2 + " in string " + string, 910);
                }
                if ((c & 0xFF00) != 0) {
                    throw new TibrvException("Non Latin-1 character at offset " + n2 + " in string " + string, 910);
                }
                this.bytes[this.offset++] = (byte)c;
                ++n2;
            }
        } else if (string2.equalsIgnoreCase("Cp1252")) {
            int n = string.length();
            this.ensure(n);
            int n3 = 0;
            while (n3 < n) {
                this.bytes[this.offset++] = TibrvImplMsgBuffer.chartobyte_cp1252(string.charAt(n3));
                ++n3;
            }
        } else if (TibrvImplMsgBuffer.is8859_1(string2)) {
            int n = string.length();
            this.ensure(n);
            int n4 = 0;
            while (n4 < n) {
                this.bytes[this.offset++] = TibrvImplMsgBuffer.chartobyte_8859_1(string.charAt(n4));
                ++n4;
            }
        } else {
            byte[] byArray;
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TibrvException("Encoding " + string2 + " not supported", 910);
            }
            return byArray;
        }
        this.ensure(1);
        this.bytes[this.offset++] = 0;
        return null;
    }

    static byte[] stringToBytes(String string, String string2, boolean bl) throws TibrvException {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        if (string2 == null) {
            int n = string.length();
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!bl && c == '\u0000') {
                    throw new TibrvException("Non-zero byte at offset " + n2 + " in string " + string, 910);
                }
                if ((c & 0xFF00) != 0) {
                    throw new TibrvException("Non Latin-1 character at offset " + n2 + " in string " + string, 910);
                }
                byArray[n2] = (byte)c;
                ++n2;
            }
        } else if (string2.equalsIgnoreCase("Cp1252")) {
            int n = string.length();
            byArray = new byte[n];
            int n3 = 0;
            while (n3 < n) {
                byArray[n3] = TibrvImplMsgBuffer.chartobyte_cp1252(string.charAt(n3));
                ++n3;
            }
        } else if (TibrvImplMsgBuffer.is8859_1(string2)) {
            int n = string.length();
            byArray = new byte[n];
            int n4 = 0;
            while (n4 < n) {
                byArray[n4] = TibrvImplMsgBuffer.chartobyte_8859_1(string.charAt(n4));
                ++n4;
            }
        } else {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TibrvException("Encoding " + string2 + " not supported", 910);
            }
        }
        return byArray;
    }

    static String stringFromBytes(byte[] byArray, int n, int n2, String string) throws TibrvException {
        String string2;
        if (byArray == null) {
            return null;
        }
        if (n2 == 0) {
            return new String();
        }
        if (byArray[n2 - 1] == 0) {
            if (n2 <= 1) {
                return new String();
            }
            --n2;
        }
        if (string == null || TibrvImplMsgBuffer.is8859_1(string)) {
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3] = (char)((char)byArray[n++] & 0xFF);
                ++n3;
            }
            string2 = new String(cArray, 0, n2);
        } else if (string.equalsIgnoreCase("Cp1252")) {
            char[] cArray = new char[n2];
            int n4 = 0;
            while (n4 < n2) {
                cArray[n4] = TibrvImplMsgBuffer.bytetochar_cp1252(byArray[n++]);
                ++n4;
            }
            string2 = new String(cArray, 0, n2);
        } else {
            try {
                string2 = new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TibrvException("Encoding " + string + " not supported", 910);
            }
        }
        return string2;
    }

    String readString(int n, String string) throws TibrvException, EOFException {
        if (this.offset + n > this.buflen) {
            throw new EOFException();
        }
        if (n == 0) {
            return new String();
        }
        String string2 = null;
        int n2 = this.offset;
        this.offset += n;
        if (this.bytes[n2 + n - 1] == 0) {
            if (n <= 1) {
                return new String();
            }
            --n;
        }
        if (string == null || TibrvImplMsgBuffer.is8859_1(string)) {
            if (this.chars == null || this.chars.length < n) {
                this.chars = new char[n < 256 ? 256 : n];
            }
            int n3 = 0;
            while (n3 < n) {
                this.chars[n3] = (char)((char)this.bytes[n2 + n3] & 0xFF);
                ++n3;
            }
            string2 = new String(this.chars, 0, n);
        } else if (string.equalsIgnoreCase("Cp1252")) {
            if (this.chars == null || this.chars.length < n) {
                this.chars = new char[n < 256 ? 256 : n];
            }
            int n4 = 0;
            while (n4 < n) {
                this.chars[n4] = TibrvImplMsgBuffer.bytetochar_cp1252(this.bytes[n2 + n4]);
                ++n4;
            }
            string2 = new String(this.chars, 0, n);
        } else {
            try {
                string2 = new String(this.bytes, n2, n, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TibrvException("Encoding " + string + " not supported", 910);
            }
        }
        return string2;
    }
}

