/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplQGroup;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvQueueGroup;

class TibrvImplQGroupC
implements TibrvImplQGroup {
    protected int _handle = 0;
    private TibrvQueueGroup _parent = null;

    TibrvImplQGroupC() {
    }

    public void create(TibrvQueueGroup tibrvQueueGroup) throws TibrvException {
        if (this._parent != null) {
            throw new InternalError("Group already created");
        }
        this._parent = tibrvQueueGroup;
        this._handle = this.natCreate();
    }

    public void destroy() throws TibrvException {
        this.natDestroy(this._handle);
        this._handle = 0;
    }

    public void addQueue(TibrvQueue tibrvQueue) throws TibrvException {
        TibrvImplQueueC tibrvImplQueueC = (TibrvImplQueueC)tibrvQueue._impl;
        if (tibrvImplQueueC == null) {
            throw new TibrvException(62);
        }
        this.natAdd(this._handle, tibrvImplQueueC._handle);
        this._parent._queues.addElement(tibrvQueue);
    }

    public void removeQueue(TibrvQueue tibrvQueue) throws TibrvException {
        this._parent._queues.removeElement(tibrvQueue);
        TibrvImplQueueC tibrvImplQueueC = (TibrvImplQueueC)tibrvQueue._impl;
        if (tibrvImplQueueC == null) {
            throw new TibrvException(62);
        }
        this.natRemove(this._handle, tibrvImplQueueC._handle);
    }

    public void dispatch() throws TibrvException {
        this.natDispatch(this._handle);
    }

    public boolean timedDispatch(double d) throws TibrvException {
        return this.natTimedDispatch(this._handle, d);
    }

    protected void finalize() throws Throwable {
        if (this._handle != 0) {
            try {
                this.natDestroy(this._handle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private native int natCreate() throws TibrvException;

    private native void natDestroy(int var1) throws TibrvException;

    private native void natDispatch(int var1) throws TibrvException;

    private native boolean natTimedDispatch(int var1, double var2) throws TibrvException;

    private native void natAdd(int var1, int var2) throws TibrvException;

    private native void natRemove(int var1, int var2) throws TibrvException;
}

