/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplEvtData;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvQueue;

class TibrvImplQueueC
implements TibrvImplQueue {
    protected int _handle = 0;
    private TibrvQueue _parent = null;

    TibrvImplQueueC() {
    }

    public void create(TibrvQueue tibrvQueue) throws TibrvException {
        this._parent = tibrvQueue;
        int n = tibrvQueue._default ? 1 : 0;
        this._handle = this.natCreateQueue(n);
    }

    public void destroy() throws TibrvException {
        this.natDestroyQueue(this._handle);
        this._handle = 0;
    }

    public void setName(String string) throws TibrvException {
        this.natSetName(this._handle, TibrvMsg.defStringToBytes(string));
    }

    public int getCount() throws TibrvException {
        return this.natGetCount(this._handle);
    }

    public void dispatch() throws TibrvException {
        this.natDispatch(this._handle);
    }

    public boolean timedDispatch(double d) throws TibrvException {
        return this.natTimedDispatch(this._handle, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws TibrvException {
        Object object = this._parent._lock;
        synchronized (object) {
            this.natSetPriority(this._handle, n);
        }
    }

    public int getPriority() throws TibrvException {
        return this.natGetPriority(this._handle);
    }

    public void setLimitPolicy(int n, int n2, int n3) throws TibrvException {
        this.natSetLimitPolicy(this._handle, n, n2, n3);
    }

    public int getLimitPolicy() throws TibrvException {
        return this.natGetLimitPolicy(this._handle);
    }

    public int getMaxEvents() throws TibrvException {
        return this.natGetMaxEvents(this._handle);
    }

    public int getDiscardAmount() throws TibrvException {
        return this.natGetDiscardAmount(this._handle);
    }

    public final boolean postEvent(TibrvImplEvtData tibrvImplEvtData, boolean bl) {
        throw new InternalError("Can not post even");
    }

    protected void finalize() throws Throwable {
        if (this._handle != 0 && !this._parent._default) {
            try {
                this.natDestroyQueue(this._handle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private native int natCreateQueue(int var1) throws TibrvException;

    private native void natDestroyQueue(int var1) throws TibrvException;

    private native void natSetName(int var1, byte[] var2) throws TibrvException;

    private native int natGetCount(int var1) throws TibrvException;

    private native void natDispatch(int var1) throws TibrvException;

    private native boolean natTimedDispatch(int var1, double var2) throws TibrvException;

    private native void natSetPriority(int var1, int var2) throws TibrvException;

    private native int natGetPriority(int var1) throws TibrvException;

    private native void natSetLimitPolicy(int var1, int var2, int var3, int var4) throws TibrvException;

    private native int natGetLimitPolicy(int var1) throws TibrvException;

    private native int natGetMaxEvents(int var1) throws TibrvException;

    private native int natGetDiscardAmount(int var1) throws TibrvException;
}

