/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplRepl;
import com.tibco.tibrv.TibrvImplSubjEnum;
import com.tibco.tibrv.TibrvImplSubject;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvImplTimerRun;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvTransport;
import java.util.Vector;

class TibrvImplTPortProcJ
implements TibrvImplTPort,
TibrvImplSubjEnum {
    private static long _inboxIndex = 0L;
    private static Object _inboxLock = new Object();
    private TibrvImplSubject _subjects = new TibrvImplSubject();
    private TibrvTransport _parent = null;

    TibrvImplTPortProcJ() {
    }

    public void create(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        this._parent = tibrvTransport;
    }

    public final boolean isRva() {
        return false;
    }

    public void setDescription(String string) throws TibrvException {
    }

    public void destroy() {
        TibrvImpl tibrvImpl = Tibrv._impl;
        if (tibrvImpl != null) {
            tibrvImpl.destroyTransportDependents(this._parent);
        }
    }

    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        String string;
        TibrvMsg tibrvMsg2 = new TibrvMsg(tibrvMsg);
        tibrvMsg2.setSendSubject(tibrvMsg.getSendSubject());
        tibrvMsg2.setReplySubject(tibrvMsg.getReplySubject());
        String string2 = tibrvMsg.getSendSubject();
        if (string2 == null) {
            throw new TibrvException("Send subject not set", 20);
        }
        if (this._subjects == null) {
            throw new TibrvException(2);
        }
        if (!this._subjects.enumMatching(string2, this, tibrvMsg2) && (string = tibrvMsg.getSendSubject()) != null && string.startsWith("_RV.") && (string.startsWith("_RV.WARN") || string.startsWith("_RV.ERROR"))) {
            System.err.println("TIB/Rendezvous Error Not Handled by Process:");
            System.err.println("Subject=" + string + ", Msg=" + tibrvMsg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        TibrvImplRepl tibrvImplRepl;
        String string = this.createInbox();
        tibrvMsg.setReplySubject(string);
        TibrvImplRepl tibrvImplRepl2 = tibrvImplRepl = new TibrvImplRepl(this._parent, string);
        synchronized (tibrvImplRepl2) {
            try {
                this.send(tibrvMsg);
            }
            catch (TibrvException tibrvException) {
                tibrvImplRepl.destroy();
                throw tibrvException;
            }
            long l = TibrvImplTimerRun.toMillis(d);
            TibrvMsg tibrvMsg2 = null;
            try {
                if (d == -1.0) {
                    tibrvImplRepl.wait();
                } else if (l > 0L) {
                    tibrvImplRepl.wait(l);
                }
                tibrvMsg2 = tibrvImplRepl.reply;
            }
            catch (InterruptedException interruptedException) {
                tibrvMsg2 = null;
            }
            tibrvImplRepl.destroy();
            Tibrv.checkValidOrClosing();
            this._parent.checkValidOrDestroying();
            TibrvMsg tibrvMsg3 = tibrvMsg2;
            return tibrvMsg3;
        }
    }

    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        tibrvMsg.setSendSubject(tibrvMsg2.getReplySubject());
        this.send(tibrvMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createInbox() throws TibrvException {
        long l;
        Object object = _inboxLock;
        synchronized (object) {
            l = ++_inboxIndex;
            if (_inboxIndex <= 0L) {
                throw new TibrvException("Too many create inbox requests", 27);
            }
        }
        return "_INBOX._PROCESS." + String.valueOf(l);
    }

    public void onSubjectMatch(Vector vector, Object object) {
        int n = 0;
        while (n < vector.size()) {
            TibrvListener tibrvListener = (TibrvListener)vector.elementAt(n);
            if (n == vector.size() - 1) {
                tibrvListener.fire((TibrvMsg)object, false);
            } else {
                try {
                    TibrvMsg tibrvMsg = new TibrvMsg((TibrvMsg)object);
                    tibrvMsg.setSendSubject(((TibrvMsg)object).getSendSubject());
                    tibrvListener.fire(tibrvMsg, false);
                }
                catch (TibrvException tibrvException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createListener(TibrvListener tibrvListener) throws TibrvException {
        TibrvTransport tibrvTransport = this._parent;
        synchronized (tibrvTransport) {
            String string = tibrvListener.getSubject();
            if (string == null) {
                throw new TibrvException(20);
            }
            if (string.startsWith("_INBOX") && !string.startsWith("_INBOX._PROCESS")) {
                throw new TibrvException("Inbox was obtained from another transport", 20);
            }
            Vector vector = this._subjects.addSubject(string);
            vector.addElement(tibrvListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyListener(TibrvListener tibrvListener, int n) {
        TibrvTransport tibrvTransport = this._parent;
        synchronized (tibrvTransport) {
            Vector vector;
            String string = tibrvListener.getSubject();
            if (string != null && (vector = this._subjects.getListeners(string)) != null) {
                vector.removeElement(tibrvListener);
                if (vector.size() == 0) {
                    this._subjects.removeSubject(string);
                }
            }
        }
    }
}

