/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvErrorCallback;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplConst;
import com.tibco.tibrv.TibrvImplRepl;
import com.tibco.tibrv.TibrvImplRvaConnect;
import com.tibco.tibrv.TibrvImplRvaDirect;
import com.tibco.tibrv.TibrvImplRvaHttp;
import com.tibco.tibrv.TibrvImplSubjData;
import com.tibco.tibrv.TibrvImplSubject;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvImplTimerRun;
import com.tibco.tibrv.TibrvImplWaiter;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvRvaTransport;
import com.tibco.tibrv.TibrvStatus;
import com.tibco.tibrv.TibrvTransport;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

class TibrvImplTPortRva
implements TibrvImplTPort,
TibrvImplConst {
    TibrvRvaTransport _parent = null;
    boolean _valid = false;
    String _hostName = null;
    int _port = 0;
    boolean _localHost = false;
    Socket _socket = null;
    boolean _http = false;
    int _httpMode = 2;
    TibrvImplRvaConnect _connector = null;
    Hashtable _subToId = new Hashtable();
    Hashtable _idToListeners = new Hashtable();
    long _nextListenId = 0L;
    String _inbox = null;
    long _nextInboxId = 0L;
    Vector _requests = new Vector();
    int _rvaMajor = 0;
    int _rvaMinor = 0;
    int _rvaUpdate = 0;

    protected static Object getIdObject(Long l) {
        if (l < Integer.MAX_VALUE) {
            return new Integer((int)l.longValue());
        }
        return l;
    }

    protected static Long getIdField(TibrvMsg tibrvMsg, String string) {
        try {
            Number number = (Number)tibrvMsg.get(string);
            if (number == null) {
                return null;
            }
            if (!(number instanceof Long)) {
                number = new Long(number.intValue());
            }
            return (Long)number;
        }
        catch (TibrvException tibrvException) {
            return null;
        }
    }

    protected TibrvImplTPortRva() {
    }

    public void create(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        this._parent = (TibrvRvaTransport)tibrvTransport;
        this._hostName = (String)objectArray[0];
        this._port = (Integer)objectArray[1];
        if (objectArray[2] != null) {
            this._httpMode = (Integer)objectArray[2];
        }
        this.determineHost();
        TibrvException tibrvException = null;
        if ((this._httpMode & 1) == 0) {
            this._connector = new TibrvImplRvaDirect(this);
            tibrvException = this._connector.connect();
            if (tibrvException == null) {
                this._valid = true;
                return;
            }
        }
        if (tibrvException != null && (this._localHost || (this._httpMode & 2) != 0)) {
            throw tibrvException;
        }
        TibrvException tibrvException2 = null;
        this._connector = new TibrvImplRvaHttp(this);
        tibrvException2 = this._connector.connect();
        if (tibrvException2 != null) {
            if (tibrvException != null) {
                throw tibrvException;
            }
            throw tibrvException2;
        }
        this._http = true;
        this._valid = true;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isRva() {
        return true;
    }

    void setPipeDelay(long l) {
        TibrvImplRvaConnect tibrvImplRvaConnect = this._connector;
        if (tibrvImplRvaConnect != null && tibrvImplRvaConnect instanceof TibrvImplRvaHttp) {
            ((TibrvImplRvaHttp)tibrvImplRvaConnect).setPipeDelay(l);
        }
    }

    void setPipeDelay(double d) {
        TibrvImplRvaConnect tibrvImplRvaConnect = this._connector;
        if (tibrvImplRvaConnect != null && tibrvImplRvaConnect instanceof TibrvImplRvaHttp) {
            ((TibrvImplRvaHttp)tibrvImplRvaConnect).setPipeDelay(d);
        }
    }

    double getPipeDelay() {
        TibrvImplRvaConnect tibrvImplRvaConnect = this._connector;
        if (tibrvImplRvaConnect != null && tibrvImplRvaConnect instanceof TibrvImplRvaHttp) {
            return ((TibrvImplRvaHttp)tibrvImplRvaConnect).getPipeDelay();
        }
        return 0.2;
    }

    public void setDescription(String string) throws TibrvException {
    }

    protected boolean isHttpTunneling() {
        return this._http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            if (this._valid) {
                this._valid = false;
                this._cleanup(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorDestroy() throws TibrvException {
        boolean bl = false;
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            if (this._valid) {
                this._valid = false;
                this._cleanup(true);
                bl = true;
            }
        }
        if (bl) {
            this._parent.destroy();
            TibrvErrorCallback tibrvErrorCallback = Tibrv.getErrorCallback();
            if (tibrvErrorCallback != null) {
                tibrvErrorCallback.onError(this._parent, 907, TibrvStatus.getText(907), null);
            }
        }
    }

    private void _cleanup(boolean bl) {
        this._notifyRequests();
        if (!bl && this._connector != null) {
            TibrvMsg tibrvMsg = new TibrvMsg();
            try {
                tibrvMsg.add("mtype", "T");
                this._connector.sendToRva(tibrvMsg);
            }
            catch (TibrvException tibrvException) {
                // empty catch block
            }
        }
        this._connector.destroy(bl);
        this._connector = null;
        this._subToId = null;
        this._idToListeners = null;
        this._requests = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyRequests() {
        if (this._requests != null) {
            int n = 0;
            while (n < this._requests.size()) {
                TibrvImplRepl tibrvImplRepl;
                TibrvImplRepl tibrvImplRepl2 = tibrvImplRepl = (TibrvImplRepl)this._requests.elementAt(n);
                synchronized (tibrvImplRepl2) {
                    tibrvImplRepl.notifyAll();
                }
                ++n;
            }
            this._requests.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        String string = tibrvMsg.getSendSubject();
        if (string == null) {
            throw new TibrvException("Send subject not set in message", 20);
        }
        String string2 = tibrvMsg.getReplySubject();
        TibrvMsg tibrvMsg2 = new TibrvMsg();
        tibrvMsg2.add("mtype", "S");
        tibrvMsg2.add("sub", string);
        if (string2 != null) {
            tibrvMsg2.add("reply", string2);
        }
        tibrvMsg2.add("data", tibrvMsg);
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            this.checkValid();
            this._connector.sendToRva(tibrvMsg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        TibrvImplTPortRva tibrvImplTPortRva;
        TibrvMsg tibrvMsg2 = null;
        TibrvMsg tibrvMsg3 = null;
        TibrvImplRepl tibrvImplRepl = null;
        TibrvImplWaiter tibrvImplWaiter = null;
        String string = tibrvMsg.getSendSubject();
        if (string == null) {
            throw new TibrvException("Send subject not set in message", 20);
        }
        tibrvMsg2 = null;
        String string2 = this.createInbox();
        tibrvMsg.setReplySubject(string2);
        tibrvImplRepl = new TibrvImplRepl(this._parent, string2);
        tibrvImplWaiter = new TibrvImplWaiter(tibrvImplRepl);
        TibrvMsg tibrvMsg4 = new TibrvMsg();
        tibrvMsg4.add("mtype", "N");
        tibrvMsg4.add("sub", string);
        tibrvMsg4.add("reply", string2);
        tibrvMsg4.add("data", tibrvMsg);
        tibrvMsg4.add("lid", TibrvImplTPortRva.getIdObject(tibrvImplRepl._listenId));
        tibrvMsg4.add("tout", d);
        try {
            tibrvImplTPortRva = this;
            synchronized (tibrvImplTPortRva) {
                this.checkValid();
                this._connector.sendToRva(tibrvMsg4);
            }
        }
        catch (TibrvException tibrvException) {
            this._destroyObjs(tibrvImplRepl, tibrvImplWaiter);
            throw tibrvException;
        }
        tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            if (this._requests != null) {
                this._requests.addElement(tibrvImplRepl);
            }
        }
        TibrvImplRepl tibrvImplRepl2 = tibrvImplRepl;
        synchronized (tibrvImplRepl2) {
            long l = TibrvImplTimerRun.toMillis(d);
            try {
                if (tibrvImplRepl.reply != null) {
                    tibrvMsg2 = tibrvImplRepl.reply;
                } else if (l == 0L) {
                    tibrvImplRepl.wait();
                } else {
                    tibrvImplRepl.wait(l);
                }
                Tibrv.checkValid();
                if (tibrvImplRepl.reply != null) {
                    tibrvMsg2 = tibrvImplRepl.reply;
                } else {
                    tibrvMsg3 = tibrvImplWaiter._reply;
                }
            }
            catch (InterruptedException interruptedException) {
                tibrvMsg2 = null;
                tibrvMsg3 = null;
            }
        }
        this._destroyObjs(tibrvImplRepl, tibrvImplWaiter);
        TibrvImplTPortRva tibrvImplTPortRva2 = this;
        synchronized (tibrvImplTPortRva2) {
            if (this._requests != null) {
                this._requests.removeElement(tibrvImplRepl);
            }
        }
        this.checkValid();
        Tibrv.checkValidOrClosing();
        this._parent.checkValidOrDestroying();
        this.checkValid();
        if (tibrvMsg3 != null) {
            Number number = (Number)tibrvMsg3.get("sts");
            if (number == null) {
                throw new TibrvException("Invalid response from the agent", 906);
            }
            if (number.intValue() != 0) {
                throw new TibrvException((String)tibrvMsg2.get("txt"), number.intValue());
            }
        }
        return tibrvMsg2;
    }

    private void _destroyObjs(TibrvImplRepl tibrvImplRepl, TibrvImplWaiter tibrvImplWaiter) {
        tibrvImplWaiter.destroy();
        tibrvImplRepl.destroy();
    }

    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        String string = tibrvMsg2.getReplySubject();
        if (string == null) {
            throw new TibrvException("Reply subject not set", 20);
        }
        tibrvMsg.setSendSubject(string);
        this.send(tibrvMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createInbox() throws TibrvException {
        long l;
        String string = this._inbox;
        synchronized (string) {
            l = ++this._nextInboxId;
        }
        return this._inbox + "-" + String.valueOf(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createListener(TibrvListener tibrvListener) throws TibrvException {
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            this.checkValid();
        }
        if (this.addListener(tibrvListener) && !(tibrvListener instanceof TibrvImplRepl)) {
            this.rvaOpenSubject(tibrvListener.getSubject(), tibrvListener._listenId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyListener(TibrvListener tibrvListener, int n) {
        try {
            TibrvImplTPortRva tibrvImplTPortRva = this;
            synchronized (tibrvImplTPortRva) {
                this.checkValid();
            }
            if (this.closeListener(tibrvListener) && !(tibrvListener instanceof TibrvImplRepl)) {
                this.rvaCloseSubject(tibrvListener._listenId, tibrvListener.getSubject());
            }
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    private final synchronized long nextListenId() {
        return ++this._nextListenId;
    }

    private final synchronized boolean addListener(TibrvListener tibrvListener) throws TibrvException {
        this.checkValid();
        String string = tibrvListener.getSubject();
        Long l = (Long)this._subToId.get(string);
        Vector<TibrvListener> vector = null;
        boolean bl = false;
        if (l == null) {
            l = new Long(this.nextListenId());
            this._subToId.put(string, l);
            bl = true;
        } else {
            vector = (Vector<TibrvListener>)this._idToListeners.get(l);
        }
        if (vector == null) {
            vector = new Vector<TibrvListener>();
            this._idToListeners.put(l, vector);
        }
        vector.addElement(tibrvListener);
        tibrvListener._listenId = l;
        return bl;
    }

    private final synchronized boolean closeListener(TibrvListener tibrvListener) throws TibrvException {
        this.checkValid();
        Vector vector = null;
        String string = tibrvListener.getSubject();
        Long l = tibrvListener._listenId;
        vector = (Vector)this._idToListeners.get(l);
        if (vector == null) {
            System.out.println("Could not find listener in the table in closeListener!");
            return true;
        }
        vector.removeElement(tibrvListener);
        if (vector.size() == 0) {
            this._idToListeners.remove(l);
            this._subToId.remove(string);
            return true;
        }
        return false;
    }

    private void dispatchAdvMsg(String string, TibrvMsg tibrvMsg) throws TibrvException {
        Serializable serializable;
        String string2;
        this.checkValid();
        tibrvMsg.setSendSubject(string);
        Vector vector = new Vector();
        boolean bl = false;
        Hashtable hashtable = this._subToId;
        Hashtable hashtable2 = this._idToListeners;
        TibrvImplSubjData tibrvImplSubjData = new TibrvImplSubjData();
        TibrvImplSubjData tibrvImplSubjData2 = new TibrvImplSubjData();
        if (!TibrvImplSubject.createSubjData(string, tibrvImplSubjData)) {
            hashtable = null;
        }
        if (hashtable != null && hashtable2 != null) {
            try {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (string2 == null || (serializable = (Long)hashtable.get(string2)) == null || !TibrvImplSubject.createSubjData(string2, tibrvImplSubjData2) || !TibrvImplSubject.subjectMatch(tibrvImplSubjData, tibrvImplSubjData2)) continue;
                    Object v = hashtable2.get(serializable);
                    vector.addElement(v);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                string2 = vector.elementAt(n);
                if (string2 instanceof TibrvListener) {
                    bl |= ((TibrvListener)((Object)string2)).fire(tibrvMsg, true);
                } else if (string2 instanceof Vector) {
                    serializable = (Vector)((Object)string2);
                    int n2 = 0;
                    while (n2 < ((Vector)serializable).size()) {
                        bl |= ((TibrvListener)((Vector)serializable).elementAt(n2)).fire(tibrvMsg, true);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            System.err.println("TIB/Rendezvous Error Not Handled by Process:");
            System.err.println("Subject=" + string + ", Msg=" + tibrvMsg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rvaCloseSubject(Long l, String string) throws TibrvException {
        TibrvImplRvaConnect tibrvImplRvaConnect = null;
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            this.checkValid();
            tibrvImplRvaConnect = this._connector;
        }
        TibrvMsg tibrvMsg = new TibrvMsg();
        tibrvMsg.add("mtype", "C");
        tibrvMsg.add("lid", TibrvImplTPortRva.getIdObject(l));
        tibrvImplRvaConnect.sendToRva(tibrvMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rvaOpenSubject(String string, Long l) throws TibrvException {
        TibrvImplRvaConnect tibrvImplRvaConnect = null;
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            this.checkValid();
            tibrvImplRvaConnect = this._connector;
        }
        TibrvMsg tibrvMsg = new TibrvMsg();
        tibrvMsg.add("mtype", "J");
        tibrvMsg.add("sub", string);
        tibrvMsg.add("lid", TibrvImplTPortRva.getIdObject(l));
        tibrvImplRvaConnect.sendToRva(tibrvMsg);
    }

    private void determineHost() throws TibrvException {
        this._localHost = false;
        if (this._hostName == null) {
            try {
                this._hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new TibrvException("Could not find local host", 1, unknownHostException);
            }
            catch (SecurityException securityException) {
                throw new TibrvException("Security settings prevent obtaining local host name", 1, securityException);
            }
            this._localHost = true;
        }
    }

    void dispatch(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) {
        try {
            if (tibrvMsg == null) {
                String string = (String)tibrvMsg2.get("mtype");
                if (string != null) {
                    if (string.equals("D") || string.equals("A")) {
                        this.dispatchMsg(null, tibrvMsg2, string.equals("A"));
                    } else if (string.equals("V")) {
                        this.dispatchStatus(tibrvMsg2);
                    }
                }
            } else {
                String string = (String)tibrvMsg.get("mtype");
                if (string != null) {
                    if (string.equals("H")) {
                        this.dispatchMsg(tibrvMsg, tibrvMsg2, false);
                    } else if (string.equals("D") || string.equals("A")) {
                        this.dispatchMsg(null, tibrvMsg, string.equals("A"));
                    } else if (string.equals("V")) {
                        this.dispatchStatus(tibrvMsg);
                    }
                }
            }
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    final void dispatchMsg(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2, boolean bl) {
        try {
            Object object;
            Long l;
            String string;
            String string2;
            TibrvMsg tibrvMsg3 = null;
            if (tibrvMsg != null) {
                string2 = (String)tibrvMsg2.get("sub");
                string = (String)tibrvMsg2.get("return");
                l = TibrvImplTPortRva.getIdField(tibrvMsg, "lid");
                object = tibrvMsg2.get("data");
            } else {
                string2 = (String)tibrvMsg2.get("sub");
                string = (String)tibrvMsg2.get("reply");
                l = TibrvImplTPortRva.getIdField(tibrvMsg2, "lid");
                object = tibrvMsg2.get("data");
            }
            if (object == null) {
                System.out.println("RVA Error: wrong response, no data in the envelope");
                return;
            }
            if (l == null) {
                this.dispatchAdvMsg(string2, (TibrvMsg)object);
                return;
            }
            if (!(object instanceof TibrvMsg)) {
                System.out.println("Plain data in the message from agent ignored");
                return;
            }
            tibrvMsg3 = (TibrvMsg)object;
            try {
                tibrvMsg3.setSendSubject(string2);
                tibrvMsg3.setReplySubject(string);
            }
            catch (TibrvException tibrvException) {
                System.out.println("Bad subjects received from agent, ignored");
                return;
            }
            this.dispatchData(tibrvMsg3, l, bl);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchData(TibrvMsg tibrvMsg, Long l, boolean bl) {
        Hashtable hashtable = null;
        TibrvImplTPortRva tibrvImplTPortRva = this;
        synchronized (tibrvImplTPortRva) {
            hashtable = this._idToListeners;
        }
        if (hashtable == null) {
            return;
        }
        Vector vector = (Vector)hashtable.get(l);
        if (vector == null) {
            return;
        }
        Vector vector2 = (Vector)vector.clone();
        int n = 0;
        while (n < vector2.size()) {
            ((TibrvListener)vector2.elementAt(n)).fire(tibrvMsg, bl);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchStatus(TibrvMsg tibrvMsg) throws TibrvException {
        Long l = TibrvImplTPortRva.getIdField(tibrvMsg, "reqid");
        if (l == null) {
            return;
        }
        TibrvImplWaiter tibrvImplWaiter = TibrvImplWaiter.get(l);
        if (tibrvImplWaiter != null) {
            tibrvImplWaiter.setReply(tibrvMsg);
            return;
        }
        TibrvErrorCallback tibrvErrorCallback = Tibrv.getErrorCallback();
        Long l2 = TibrvImplTPortRva.getIdField(tibrvMsg, "lid");
        if (tibrvErrorCallback != null && l2 != null) {
            Number number = (Number)tibrvMsg.get("sts");
            if (number == null) {
                return;
            }
            if (number.intValue() == 0) {
                return;
            }
            String string = (String)tibrvMsg.get("txt");
            Hashtable hashtable = null;
            TibrvImplTPortRva tibrvImplTPortRva = this;
            synchronized (tibrvImplTPortRva) {
                hashtable = this._idToListeners;
                if (hashtable == null) {
                    return;
                }
            }
            Vector vector = (Vector)hashtable.get(l2);
            if (vector == null) {
                return;
            }
            Vector vector2 = (Vector)vector.clone();
            int n = 0;
            while (n < vector2.size()) {
                tibrvErrorCallback.onError((TibrvListener)vector2.elementAt(n), number.intValue(), string, null);
                ++n;
            }
        }
    }

    void onDisconnected(Exception exception) {
        try {
            this.errorDestroy();
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    private void checkValid() throws TibrvException {
        if (!this._valid || this._connector == null) {
            throw new TibrvException(907);
        }
    }

    static final TibrvMsg buildInitMsg() throws TibrvException {
        TibrvMsg tibrvMsg = new TibrvMsg();
        tibrvMsg.add("mtype", "I");
        tibrvMsg.add("uid", "Java Client");
        tibrvMsg.add("vmaj", Tibrv.getMajorVersion());
        tibrvMsg.add("vmin", Tibrv.getMinorVersion());
        tibrvMsg.add("vupd", Tibrv.getUpdateVersion());
        return tibrvMsg;
    }
}

