/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvDate;
import com.tibco.tibrv.TibrvEncrypted;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvIPAddr;
import com.tibco.tibrv.TibrvIPPort;
import com.tibco.tibrv.TibrvImplMsgBuffer;
import com.tibco.tibrv.TibrvImplMsgEnc;
import com.tibco.tibrv.TibrvImplMsgUtil;
import com.tibco.tibrv.TibrvImplSubject;
import com.tibco.tibrv.TibrvMsgDecoder;
import com.tibco.tibrv.TibrvMsgEncoder;
import com.tibco.tibrv.TibrvMsgField;
import com.tibco.tibrv.TibrvXml;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class TibrvMsg {
    public static final short DEFAULT = 0;
    public static final short MSG = 1;
    public static final short DATETIME = 3;
    public static final short OPAQUE = 7;
    public static final short STRING = 8;
    public static final short BOOL = 9;
    public static final short I8 = 14;
    public static final short U8 = 15;
    public static final short I16 = 16;
    public static final short U16 = 17;
    public static final short I32 = 18;
    public static final short U32 = 19;
    public static final short I64 = 20;
    public static final short U64 = 21;
    public static final short F32 = 24;
    public static final short F64 = 25;
    public static final short IPPORT16 = 26;
    public static final short IPADDR32 = 27;
    public static final short ENCRYPTED = 32;
    protected static final short NONE = 22;
    public static final short I8ARRAY = 34;
    public static final short U8ARRAY = 35;
    public static final short I16ARRAY = 36;
    public static final short U16ARRAY = 37;
    public static final short I32ARRAY = 38;
    public static final short U32ARRAY = 39;
    public static final short I64ARRAY = 40;
    public static final short U64ARRAY = 41;
    public static final short F32ARRAY = 44;
    public static final short F64ARRAY = 45;
    public static final short XML = 47;
    public static final short USER_FIRST = 128;
    public static final short USER_LAST = 255;
    protected static final short RESERVED = 127;
    protected static final short SUBJECT = 2;
    protected static final short IPDATA = 10;
    protected static final short INT = 11;
    protected static final short UINT = 12;
    protected static final short REAL = 13;
    private static Hashtable _encoders = null;
    private static Object _encoderLock = new Object();
    private String _sendSubject = null;
    private String _replySubject = null;
    private byte[] _wireBuffer = null;
    private Vector _fields = null;
    private Hashtable _hashNames = null;
    private Hashtable _hashIDs = null;
    private static final String _noconv = "[NO CONVERSION]";
    private static final Integer _nullNameKey = new Integer(1);
    private TibrvMsg _envelope = null;
    static final String _ENC_NAME_CP1252 = "Cp1252";
    static final String _ENC_NAME_8859_1 = "8859_1";
    private String _encoding = _defaultEncoding;
    public static String DEFAULT_ENCODING;
    protected static String _defaultEncoding;

    public static final String getStringEncoding() {
        return _defaultEncoding;
    }

    public static final synchronized void setStringEncoding(String string) throws UnsupportedEncodingException {
        if (string != null) {
            String string2 = "abc";
            string2.getBytes(string);
        }
        _defaultEncoding = string;
    }

    protected static final String stringFromBytes(byte[] byArray, int n, int n2, String string) throws TibrvException {
        return TibrvImplMsgBuffer.stringFromBytes(byArray, n, n2, string);
    }

    protected static final byte[] stringToBytes(String string, String string2, boolean bl) throws TibrvException {
        return TibrvImplMsgBuffer.stringToBytes(string, string2, bl);
    }

    protected static final byte[] defStringToBytes(String string, boolean bl) throws TibrvException {
        return TibrvImplMsgBuffer.stringToBytes(string, _defaultEncoding, bl);
    }

    protected static final byte[] defStringToBytes(String string) throws TibrvException {
        return TibrvImplMsgBuffer.stringToBytes(string, _defaultEncoding, false);
    }

    public final String getMsgStringEncoding() {
        return this._encoding;
    }

    protected final synchronized TibrvMsg getEnvelope() {
        return this._envelope;
    }

    protected final synchronized TibrvMsg getCreateEnvelope() {
        if (this._envelope == null) {
            this._envelope = new TibrvMsg();
        }
        return this._envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHandlers(short s, TibrvMsgEncoder tibrvMsgEncoder, TibrvMsgDecoder tibrvMsgDecoder) {
        if (!TibrvMsg.isUserType(s)) {
            throw new IllegalArgumentException("Specified type not in range of user types: " + s);
        }
        Object object = _encoderLock;
        synchronized (object) {
            if (tibrvMsgEncoder == null && tibrvMsgDecoder == null) {
                if (_encoders != null) {
                    _encoders.remove(new Short(s));
                }
                if (_encoders.isEmpty()) {
                    _encoders = null;
                }
                return;
            }
            TibrvImplMsgEnc tibrvImplMsgEnc = new TibrvImplMsgEnc();
            tibrvImplMsgEnc.encoder = tibrvMsgEncoder;
            tibrvImplMsgEnc.decoder = tibrvMsgDecoder;
            if (_encoders == null) {
                _encoders = new Hashtable();
            }
            _encoders.put(new Short(s), tibrvImplMsgEnc);
        }
    }

    public static TibrvMsgEncoder getEncoder(short s) {
        TibrvImplMsgEnc tibrvImplMsgEnc;
        if (_encoders != null && (tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s))) != null) {
            return tibrvImplMsgEnc.encoder;
        }
        return null;
    }

    public static TibrvMsgDecoder getDecoder(short s) {
        TibrvImplMsgEnc tibrvImplMsgEnc;
        if (_encoders != null && (tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s))) != null) {
            return tibrvImplMsgEnc.decoder;
        }
        return null;
    }

    public TibrvMsg() {
    }

    public TibrvMsg(TibrvMsg tibrvMsg) throws TibrvException {
        this.checkNull(tibrvMsg);
        byte[] byArray = tibrvMsg.getAsBytes();
        this.cacheBytes(byArray, 0, byArray.length);
    }

    public TibrvMsg(byte[] byArray) throws TibrvException {
        this.checkNull(byArray);
        this.cacheBytes(byArray, 0, byArray.length);
    }

    protected TibrvMsg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws TibrvException {
        this.cacheBytes(byArray, 0, byArray.length);
        if (byArray2 != null) {
            this.setSendSubject(TibrvImplMsgBuffer.stringFromBytes(byArray2, 0, byArray2.length, this._encoding));
        }
        if (byArray3 != null) {
            this.setReplySubject(TibrvImplMsgBuffer.stringFromBytes(byArray3, 0, byArray3.length, this._encoding));
        }
        if (byArray4 != null) {
            this._envelope = new TibrvMsg(byArray4);
        }
    }

    protected TibrvMsg(byte[] byArray, int n, int n2) throws TibrvException {
        this.checkNull(byArray);
        this.cacheBytes(byArray, n, n2);
    }

    public static String getTypeName(short s) {
        return TibrvImplMsgUtil.getTypeName(s);
    }

    void dumpToBuffer(StringBuffer stringBuffer) {
        try {
            this.check();
        }
        catch (TibrvException tibrvException) {
            stringBuffer.append("[Corrupted message buffer, conversion failed]");
            return;
        }
        if (this._fields == null || this._fields.size() == 0) {
            stringBuffer.append("{ }");
            return;
        }
        stringBuffer.append("{");
        int n = 0;
        while (n < this._fields.size()) {
            Object[] objectArray;
            TibrvMsgField tibrvMsgField = (TibrvMsgField)this._fields.elementAt(n);
            Object object = tibrvMsgField.data;
            short s = tibrvMsgField.type;
            if (tibrvMsgField.name != null) {
                stringBuffer.append(" ").append(tibrvMsgField.name);
            } else if (tibrvMsgField.id == 0) {
                stringBuffer.append(" <null>");
            }
            if (tibrvMsgField.id != 0) {
                stringBuffer.append("(").append(String.valueOf(tibrvMsgField.id)).append(")");
            }
            stringBuffer.append("=");
            if (object == null) {
                stringBuffer.append("[NO DECODER OR DECODER FAILED FOR TYPE ").append(s & 0xFF).append("]");
            } else if (object instanceof TibrvMsg) {
                ((TibrvMsg)object).dumpToBuffer(stringBuffer);
            } else if (object instanceof String) {
                stringBuffer.append("\"").append(object.toString()).append("\"");
            } else if (object instanceof byte[]) {
                objectArray = (byte[])object;
                if (s == 0 || s == 7) {
                    stringBuffer.append("[").append(objectArray.length).append(" opaque bytes]");
                } else if (s == 34) {
                    stringBuffer.append("[I8: ").append(objectArray.length).append(" elements]");
                } else if (s == 35) {
                    stringBuffer.append("[I8: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else if (object instanceof short[]) {
                objectArray = (short[])object;
                if (s == 0 || s == 36) {
                    stringBuffer.append("[I16: ").append(objectArray.length).append(" elements]");
                } else if (s == 37) {
                    stringBuffer.append("[U16: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else if (object instanceof int[]) {
                objectArray = (int[])object;
                if (s == 0 || s == 38) {
                    stringBuffer.append("[I32: ").append(objectArray.length).append(" elements]");
                } else if (s == 39) {
                    stringBuffer.append("[U32: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else if (object instanceof long[]) {
                objectArray = (long[])object;
                if (s == 0 || s == 40) {
                    stringBuffer.append("[I64: ").append(objectArray.length).append(" elements]");
                } else if (s == 41) {
                    stringBuffer.append("[U64: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else if (object instanceof float[]) {
                objectArray = (float[])object;
                if (s == 0 || s == 44) {
                    stringBuffer.append("[F32: ").append(objectArray.length).append(" elements]");
                } else if (s == 45) {
                    stringBuffer.append("[F64: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else if (object instanceof double[]) {
                objectArray = (double[])object;
                if (s == 0 || s == 45) {
                    stringBuffer.append("[F64: ").append(objectArray.length).append(" elements]");
                } else if (s == 44) {
                    stringBuffer.append("[F32: ").append(objectArray.length).append(" elements]");
                } else {
                    stringBuffer.append(_noconv);
                }
            } else {
                stringBuffer.append(object.toString());
            }
            ++n;
        }
        stringBuffer.append(" }");
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        this.dumpToBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public synchronized void setSendSubject(String string) throws TibrvException {
        if (string != null) {
            TibrvImplSubject.verify(string);
        }
        this._sendSubject = string;
    }

    protected synchronized byte[] getSendSubjectAsBytes() throws TibrvException {
        if (this._sendSubject != null) {
            return TibrvImplMsgBuffer.stringToBytes(this._sendSubject, this._encoding, false);
        }
        return null;
    }

    protected synchronized byte[] getReplySubjectAsBytes() throws TibrvException {
        if (this._replySubject != null) {
            return TibrvImplMsgBuffer.stringToBytes(this._replySubject, this._encoding, false);
        }
        return null;
    }

    public String getSendSubject() {
        return this._sendSubject;
    }

    public synchronized void setReplySubject(String string) throws TibrvException {
        if (string != null) {
            TibrvImplSubject.verify(string);
        }
        this._replySubject = string;
    }

    public synchronized String getReplySubject() {
        return this._replySubject;
    }

    public final synchronized int getNumFields() {
        try {
            this.check();
        }
        catch (TibrvException tibrvException) {
            return 0;
        }
        return this._fields != null ? this._fields.size() : 0;
    }

    public final synchronized byte[] getAsBytes() throws TibrvException {
        if (this._wireBuffer != null) {
            return this._wireBuffer;
        }
        TibrvImplMsgBuffer tibrvImplMsgBuffer = new TibrvImplMsgBuffer();
        tibrvImplMsgBuffer.writeInt(0);
        tibrvImplMsgBuffer.writeInt(-1722421590);
        this.writeFields(tibrvImplMsgBuffer);
        byte[] byArray = new byte[tibrvImplMsgBuffer.offset];
        System.arraycopy(tibrvImplMsgBuffer.bytes, 0, byArray, 0, tibrvImplMsgBuffer.offset);
        TibrvMsg.intToBytes(tibrvImplMsgBuffer.offset, byArray, 0);
        return byArray;
    }

    public final synchronized int getByteSize() throws TibrvException {
        return this.getAsBytes().length;
    }

    final synchronized Object getAsBytesRaw() throws TibrvException {
        if (this._wireBuffer != null) {
            return this._wireBuffer;
        }
        TibrvImplMsgBuffer tibrvImplMsgBuffer = new TibrvImplMsgBuffer();
        tibrvImplMsgBuffer.writeInt(0);
        tibrvImplMsgBuffer.writeInt(-1722421590);
        this.writeFields(tibrvImplMsgBuffer);
        TibrvMsg.intToBytes(tibrvImplMsgBuffer.offset, tibrvImplMsgBuffer.bytes, 0);
        return tibrvImplMsgBuffer;
    }

    public synchronized Object get(String string) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string);
        if (tibrvMsgField != null) {
            return tibrvMsgField.data;
        }
        return null;
    }

    public synchronized Object get(int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(null, n);
        if (tibrvMsgField != null) {
            return tibrvMsgField.data;
        }
        return null;
    }

    public synchronized Object get(String string, int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField != null) {
            return tibrvMsgField.data;
        }
        return null;
    }

    public synchronized TibrvMsgField getField(String string) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string);
        if (tibrvMsgField != null) {
            return new TibrvMsgField(tibrvMsgField);
        }
        return null;
    }

    public synchronized TibrvMsgField getField(int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(null, n);
        if (tibrvMsgField != null) {
            return new TibrvMsgField(tibrvMsgField);
        }
        return null;
    }

    public synchronized TibrvMsgField getField(String string, int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField != null) {
            return new TibrvMsgField(tibrvMsgField);
        }
        return null;
    }

    public synchronized TibrvMsgField getFieldByIndex(int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getByIndex(n);
        if (tibrvMsgField == null) {
            throw new ArrayIndexOutOfBoundsException("Field index out of range");
        }
        if (tibrvMsgField.data == null) {
            throw new TibrvException("Decoder failed for " + tibrvMsgField.toString(), 41);
        }
        return new TibrvMsgField(tibrvMsgField);
    }

    public synchronized TibrvMsgField getFieldInstance(String string, int n) throws TibrvException {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid instance index");
        }
        TibrvMsgField tibrvMsgField = this._getInstance(string, n);
        if (tibrvMsgField == null) {
            return null;
        }
        if (tibrvMsgField.data == null) {
            throw new TibrvException("Decoder failed for " + tibrvMsgField.toString(), 41);
        }
        return new TibrvMsgField(tibrvMsgField);
    }

    public synchronized boolean getBoolean(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsBool(false, string, n);
    }

    public synchronized byte getByte(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsByte(false, string, n);
    }

    public synchronized short getShort(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsShort(false, string, n);
    }

    public synchronized int getInt(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsInt(false, string, n);
    }

    public synchronized long getLong(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsLong(false, string, n);
    }

    public synchronized float getFloat(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsFloat(false, string, n);
    }

    public synchronized double getDouble(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsDouble(false, string, n);
    }

    public synchronized boolean getAsBoolean(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsBool(true, string, n);
    }

    public synchronized byte getAsByte(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsByte(true, string, n);
    }

    public synchronized short getAsShort(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsShort(true, string, n);
    }

    public synchronized int getAsInt(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsInt(true, string, n);
    }

    public synchronized long getAsLong(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsLong(true, string, n);
    }

    public synchronized float getAsFloat(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsFloat(true, string, n);
    }

    public synchronized double getAsDouble(String string, int n) throws TibrvException {
        this.checkId(n);
        return this._getAsDouble(true, string, n);
    }

    public synchronized boolean removeField(String string) {
        try {
            return this._removeImpl(string, 0);
        }
        catch (TibrvException tibrvException) {
            return false;
        }
    }

    public synchronized boolean removeField(int n) {
        try {
            return this._removeImpl(null, n);
        }
        catch (TibrvException tibrvException) {
            return false;
        }
    }

    public synchronized boolean removeField(String string, int n) throws TibrvException {
        return this._removeImpl(string, n);
    }

    public synchronized boolean removeFieldInstance(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid instance index");
        }
        return this._removeInstance(string, n);
    }

    public synchronized void addField(TibrvMsgField tibrvMsgField) throws TibrvException {
        this.checkNull(tibrvMsgField);
        this._addImpl(tibrvMsgField.name, tibrvMsgField.id, tibrvMsgField.data, tibrvMsgField.type, (short)0);
    }

    public synchronized void add(String string, Object object) throws TibrvException {
        this._addImpl(string, 0, object, (short)0, (short)0);
    }

    public synchronized void add(String string, Object object, short s) throws TibrvException {
        this._addImpl(string, 0, object, s, (short)0);
    }

    public synchronized void add(String string, Object object, short s, int n) throws TibrvException {
        this._addImpl(string, n, object, s, (short)0);
    }

    public synchronized void add(String string, boolean bl) throws TibrvException {
        this._addImpl(string, 0, new Boolean(bl), (short)9, (short)9);
    }

    public synchronized void add(String string, byte by) throws TibrvException {
        this._addImpl(string, 0, new Byte(by), (short)14, (short)14);
    }

    public synchronized void add(String string, short s) throws TibrvException {
        this._addImpl(string, 0, new Short(s), (short)16, (short)16);
    }

    public synchronized void add(String string, int n) throws TibrvException {
        this._addImpl(string, 0, new Integer(n), (short)18, (short)18);
    }

    public synchronized void add(String string, long l) throws TibrvException {
        this._addImpl(string, 0, new Long(l), (short)20, (short)20);
    }

    public synchronized void add(String string, float f) throws TibrvException {
        this._addImpl(string, 0, new Float(f), (short)24, (short)24);
    }

    public synchronized void add(String string, double d) throws TibrvException {
        this._addImpl(string, 0, new Double(d), (short)25, (short)25);
    }

    public synchronized void addU8(String string, byte by) throws TibrvException {
        this._addImpl(string, 0, new Byte(by), (short)15, (short)14);
    }

    public synchronized void addU16(String string, short s) throws TibrvException {
        this._addImpl(string, 0, new Short(s), (short)17, (short)16);
    }

    public synchronized void addU32(String string, int n) throws TibrvException {
        this._addImpl(string, 0, new Integer(n), (short)19, (short)18);
    }

    public synchronized void addU64(String string, long l) throws TibrvException {
        this._addImpl(string, 0, new Long(l), (short)21, (short)20);
    }

    public synchronized void add(String string, boolean bl, int n) throws TibrvException {
        this._addImpl(string, n, new Boolean(bl), (short)9, (short)9);
    }

    public synchronized void add(String string, byte by, int n) throws TibrvException {
        this._addImpl(string, n, new Byte(by), (short)14, (short)14);
    }

    public synchronized void add(String string, short s, int n) throws TibrvException {
        this._addImpl(string, n, new Short(s), (short)16, (short)16);
    }

    public synchronized void add(String string, int n, int n2) throws TibrvException {
        this._addImpl(string, n2, new Integer(n), (short)18, (short)18);
    }

    public synchronized void add(String string, long l, int n) throws TibrvException {
        this._addImpl(string, n, new Long(l), (short)20, (short)20);
    }

    public synchronized void add(String string, float f, int n) throws TibrvException {
        this._addImpl(string, n, new Float(f), (short)24, (short)24);
    }

    public synchronized void add(String string, double d, int n) throws TibrvException {
        this._addImpl(string, n, new Double(d), (short)25, (short)25);
    }

    public synchronized void addU8(String string, byte by, int n) throws TibrvException {
        this._addImpl(string, n, new Byte(by), (short)15, (short)14);
    }

    public synchronized void addU16(String string, short s, int n) throws TibrvException {
        this._addImpl(string, n, new Short(s), (short)17, (short)16);
    }

    public synchronized void addU32(String string, int n, int n2) throws TibrvException {
        this._addImpl(string, n2, new Integer(n), (short)19, (short)18);
    }

    public synchronized void addU64(String string, long l, int n) throws TibrvException {
        this._addImpl(string, n, new Long(l), (short)21, (short)20);
    }

    public synchronized void updateField(TibrvMsgField tibrvMsgField) throws TibrvException {
        this.checkNull(tibrvMsgField);
        if (tibrvMsgField.data == null) {
            throw new TibrvException("field data is null", 34);
        }
        this._updateImpl(tibrvMsgField.name, tibrvMsgField.id, tibrvMsgField.data, tibrvMsgField.type, (short)0);
    }

    public synchronized void update(String string, Object object) throws TibrvException {
        this.checkNull(object);
        this._updateImpl(string, 0, object, (short)0, (short)0);
    }

    public synchronized void update(String string, Object object, short s) throws TibrvException {
        this.checkNull(object);
        this._updateImpl(string, 0, object, s, (short)0);
    }

    public synchronized void update(String string, Object object, short s, int n) throws TibrvException {
        this.checkNull(object);
        this._updateImpl(string, n, object, s, (short)0);
    }

    public synchronized void update(String string, boolean bl) throws TibrvException {
        this._updateImpl(string, 0, new Boolean(bl), (short)0, (short)9);
    }

    public synchronized void update(String string, byte by) throws TibrvException {
        this._updateImpl(string, 0, new Byte(by), (short)0, (short)14);
    }

    public synchronized void update(String string, short s) throws TibrvException {
        this._updateImpl(string, 0, new Short(s), (short)0, (short)16);
    }

    public synchronized void update(String string, int n) throws TibrvException {
        this._updateImpl(string, 0, new Integer(n), (short)0, (short)18);
    }

    public synchronized void update(String string, long l) throws TibrvException {
        this._updateImpl(string, 0, new Long(l), (short)0, (short)20);
    }

    public synchronized void update(String string, float f) throws TibrvException {
        this._updateImpl(string, 0, new Float(f), (short)0, (short)24);
    }

    public synchronized void update(String string, double d) throws TibrvException {
        this._updateImpl(string, 0, new Double(d), (short)0, (short)25);
    }

    public synchronized void updateU8(String string, byte by) throws TibrvException {
        this._updateImpl(string, 0, new Byte(by), (short)15, (short)14);
    }

    public synchronized void updateU16(String string, short s) throws TibrvException {
        this._updateImpl(string, 0, new Short(s), (short)17, (short)16);
    }

    public synchronized void updateU32(String string, int n) throws TibrvException {
        this._updateImpl(string, 0, new Integer(n), (short)19, (short)18);
    }

    public synchronized void updateU64(String string, long l) throws TibrvException {
        this._updateImpl(string, 0, new Long(l), (short)21, (short)20);
    }

    public synchronized void update(String string, boolean bl, int n) throws TibrvException {
        this._updateImpl(string, n, new Boolean(bl), (short)0, (short)9);
    }

    public synchronized void update(String string, byte by, int n) throws TibrvException {
        this._updateImpl(string, n, new Byte(by), (short)0, (short)14);
    }

    public synchronized void update(String string, short s, int n) throws TibrvException {
        this._updateImpl(string, n, new Short(s), (short)0, (short)16);
    }

    public synchronized void update(String string, int n, int n2) throws TibrvException {
        this._updateImpl(string, n2, new Integer(n), (short)0, (short)18);
    }

    public synchronized void update(String string, long l, int n) throws TibrvException {
        this._updateImpl(string, n, new Long(l), (short)0, (short)20);
    }

    public synchronized void update(String string, float f, int n) throws TibrvException {
        this._updateImpl(string, n, new Float(f), (short)0, (short)24);
    }

    public synchronized void update(String string, double d, int n) throws TibrvException {
        this._updateImpl(string, n, new Double(d), (short)0, (short)25);
    }

    public synchronized void updateU8(String string, byte by, int n) throws TibrvException {
        this._updateImpl(string, n, new Byte(by), (short)15, (short)14);
    }

    public synchronized void updateU16(String string, short s, int n) throws TibrvException {
        this._updateImpl(string, n, new Short(s), (short)17, (short)16);
    }

    public synchronized void updateU32(String string, int n, int n2) throws TibrvException {
        this._updateImpl(string, n2, new Integer(n), (short)19, (short)18);
    }

    public synchronized void updateU64(String string, long l, int n) throws TibrvException {
        this._updateImpl(string, n, new Long(l), (short)21, (short)20);
    }

    private final boolean _getAsBool(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21) {
            throw new TibrvException(38);
        }
        if (bl || s == 9) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Number) {
                return ((Number)object).intValue() != 0;
            }
        }
        throw new TibrvException(38);
    }

    private final byte _getAsByte(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 14) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? (byte)1 : 0;
            }
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
        }
        throw new TibrvException(38);
    }

    private final short _getAsShort(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 26 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 16) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? (short)1 : 0;
            }
            if (object instanceof TibrvIPPort) {
                return (short)((TibrvIPPort)object).getPort();
            }
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
        }
        throw new TibrvException(38);
    }

    private final int _getAsInt(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 26 && s != 27 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 18) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof TibrvIPPort) {
                return ((TibrvIPPort)object).getPort();
            }
            if (object instanceof TibrvIPAddr) {
                return ((TibrvIPAddr)object).getAddr();
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
        }
        throw new TibrvException(38);
    }

    private final long _getAsLong(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 26 && s != 27 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 20) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1L : 0L;
            }
            if (object instanceof TibrvIPPort) {
                return ((TibrvIPPort)object).getPort();
            }
            if (object instanceof TibrvIPAddr) {
                return ((TibrvIPAddr)object).getAddr();
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        throw new TibrvException(38);
    }

    private final float _getAsFloat(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 24) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0f : 0.0f;
            }
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
        }
        throw new TibrvException(38);
    }

    private final double _getAsDouble(boolean bl, String string, int n) throws TibrvException {
        short s;
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            throw new TibrvException(35);
        }
        Object object = tibrvMsgField.data;
        short s2 = s = tibrvMsgField.type != 0 ? tibrvMsgField.type : TibrvImplMsgUtil.getObjectType(object);
        if (s != 9 && s != 14 && s != 15 && s != 16 && s != 17 && s != 18 && s != 19 && s != 20 && s != 21 && s != 24 && s != 25) {
            throw new TibrvException(38);
        }
        if (bl || s == 25) {
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
        }
        throw new TibrvException(38);
    }

    private final void _addImpl(String string, int n, Object object, short s, short s2) throws TibrvException {
        if (object == null) {
            throw new IllegalArgumentException("Field data is null");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Field id is out of range");
        }
        if (string != null && string.length() > 252) {
            throw new TibrvException("Field name is too long", 30);
        }
        this.check();
        s2 = TibrvMsg.checkConvert(object, s, s2);
        this._addField(string, n, object, s, s2);
    }

    private final void _updateImpl(String string, int n, Object object, short s, short s2) throws TibrvException {
        if (object == null) {
            throw new IllegalArgumentException("Field data is null");
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Field id is out of range");
        }
        if (string != null && string.length() > 252) {
            throw new TibrvException("Field name is too long", 30);
        }
        this.check();
        this._updateField(string, n, object, s, s2);
    }

    final void _addField(String string, int n, Object object, short s, short s2) throws TibrvException {
        if (n != 0 && string == null) {
            throw new TibrvException("Field name must not be null if id is specified", 30);
        }
        this.check();
        if (this._fields == null) {
            this._fields = new Vector();
        }
        if (!TibrvMsg.isUserType(s) && s2 == 0 && object != null && (s2 = TibrvImplMsgUtil.getObjectType(object)) == 0) {
            throw new TibrvException("Invalid field data", 34);
        }
        if (s == 0) {
            s = s2;
        }
        TibrvMsgField tibrvMsgField = new TibrvMsgField(string, object, s, n);
        if (n != 0) {
            this._buildHashIDs();
            if (!this._addHashID(tibrvMsgField)) {
                throw new TibrvException(36);
            }
        }
        if (this._hashNames != null) {
            this._addHashName(tibrvMsgField);
        }
        this._fields.addElement(tibrvMsgField);
    }

    final void _updateField(String string, int n, Object object, short s, short s2) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            if (n != 0 && string == null) {
                throw new TibrvException(35);
            }
            this._addImpl(string, n, object, s, s2);
            return;
        }
        if (!TibrvMsg.isUserType(s) && s2 == 0 && (s2 = TibrvImplMsgUtil.getObjectType(object)) == 0) {
            throw new TibrvException("Invalid update data", 34);
        }
        short s3 = tibrvMsgField.type;
        if (s3 == 0) {
            s3 = TibrvImplMsgUtil.getObjectType(tibrvMsgField.data);
        }
        if (s3 == 0) {
            throw new TibrvException(31);
        }
        if (s != 0 ? s != s3 : !TibrvImplMsgUtil.canConvertType(s2, s3)) {
            throw new TibrvException(31);
        }
        if (TibrvMsg.isUserType(s)) {
            if (_encoders == null) {
                throw new TibrvException(31);
            }
            TibrvImplMsgEnc tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s));
            if (tibrvImplMsgEnc == null) {
                throw new TibrvException(31);
            }
            try {
                if (!tibrvImplMsgEnc.encoder.canEncode(s, object)) {
                    throw new TibrvException("Invalid update data", 34);
                }
            }
            catch (Exception exception) {
                throw new TibrvException(40, (Throwable)exception);
            }
        }
        tibrvMsgField.data = object;
    }

    private final TibrvMsgField _getField(String string) throws TibrvException {
        Object v;
        this.check();
        if (this._fields == null || this._fields.size() == 0) {
            return null;
        }
        Object object = this._nameKey(string);
        if (this._hashNames == null) {
            this._buildHashNames();
        }
        if ((v = this._hashNames.get(object)) == null) {
            return null;
        }
        TibrvMsgField tibrvMsgField = null;
        if (v instanceof TibrvMsgField) {
            tibrvMsgField = (TibrvMsgField)v;
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            if (vector.size() < 2) {
                throw new InternalError("<2 fields in _getField");
            }
            tibrvMsgField = (TibrvMsgField)vector.elementAt(0);
        } else {
            throw new InternalError("invalid object in _fields");
        }
        if (tibrvMsgField != null && tibrvMsgField.data == null) {
            throw new TibrvException("Decoder failed for " + tibrvMsgField.toString(), 41);
        }
        return tibrvMsgField;
    }

    private final TibrvMsgField _getField(String string, int n) throws TibrvException {
        Object v;
        this.check();
        if (this._fields == null || this._fields.size() == 0) {
            return null;
        }
        TibrvMsgField tibrvMsgField = null;
        if (n > 0) {
            if (this._hashIDs != null && (v = this._hashIDs.get(new Integer(n))) != null) {
                tibrvMsgField = (TibrvMsgField)v;
                if (tibrvMsgField.data == null) {
                    throw new TibrvException("Decoder failed for " + tibrvMsgField.toString(), 41);
                }
                return tibrvMsgField;
            }
            if (string == null) {
                return null;
            }
        }
        Object object = this._nameKey(string);
        if (this._hashNames == null) {
            this._buildHashNames();
        }
        if ((v = this._hashNames.get(object)) == null) {
            return null;
        }
        if (v instanceof TibrvMsgField) {
            tibrvMsgField = (TibrvMsgField)v;
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            if (vector.size() < 2) {
                throw new InternalError("<2 fields in _getField");
            }
            tibrvMsgField = (TibrvMsgField)vector.elementAt(0);
        } else {
            throw new InternalError("invalid object in _fields");
        }
        if (tibrvMsgField != null) {
            if (tibrvMsgField.data == null) {
                throw new TibrvException("Decoder failed for " + tibrvMsgField.toString(), 41);
            }
            if (tibrvMsgField.id > 0 && n > 0 && tibrvMsgField.id != n) {
                throw new TibrvException(37);
            }
        }
        return tibrvMsgField;
    }

    private final void _buildHashNames() {
        if (this._fields == null) {
            this._fields = new Vector();
        }
        if (this._hashNames == null) {
            this._hashNames = new Hashtable();
            int n = 0;
            while (n < this._fields.size()) {
                this._addHashName((TibrvMsgField)this._fields.elementAt(n));
                ++n;
            }
        }
    }

    private final void _addHashName(TibrvMsgField tibrvMsgField) {
        Object object = this._nameKey(tibrvMsgField.name);
        Object v = this._hashNames.get(object);
        if (v == null) {
            this._hashNames.put(object, tibrvMsgField);
        } else if (v instanceof TibrvMsgField) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(tibrvMsgField);
            this._hashNames.put(object, vector);
        } else if (v instanceof Vector) {
            ((Vector)v).addElement(tibrvMsgField);
        } else {
            throw new InternalError("Error 200");
        }
    }

    private final void _buildHashIDs() {
        if (this._fields == null) {
            this._fields = new Vector();
        }
        if (this._hashIDs == null) {
            this._hashIDs = new Hashtable();
            int n = 0;
            while (n < this._fields.size()) {
                if (!this._addHashID((TibrvMsgField)this._fields.elementAt(n))) {
                    throw new InternalError("Repeating field id in buildHashIDs");
                }
                ++n;
            }
        }
    }

    private final boolean _addHashID(TibrvMsgField tibrvMsgField) {
        if (tibrvMsgField.id == 0) {
            return true;
        }
        Integer n = new Integer(tibrvMsgField.id);
        if (this._hashIDs.containsKey(n)) {
            return false;
        }
        this._hashIDs.put(n, tibrvMsgField);
        return true;
    }

    private final TibrvMsgField _getByIndex(int n) throws TibrvException {
        this.check();
        if (this._fields != null && n >= 0 && n < this._fields.size()) {
            TibrvMsgField tibrvMsgField = (TibrvMsgField)this._fields.elementAt(n);
            return tibrvMsgField;
        }
        return null;
    }

    private final TibrvMsgField _getInstance(String string, int n) throws TibrvException {
        this.check();
        if (this._fields == null || this._fields.size() == 0) {
            return null;
        }
        this._buildHashNames();
        Object v = this._hashNames.get(this._nameKey(string));
        if (v == null) {
            return null;
        }
        TibrvMsgField tibrvMsgField = null;
        --n;
        if (v instanceof TibrvMsgField) {
            if (n == 0) {
                tibrvMsgField = (TibrvMsgField)v;
            }
        } else {
            Vector vector = (Vector)v;
            if (vector.size() < 2) {
                throw new InternalError("Error 203");
            }
            if (n >= 0 && n < vector.size()) {
                tibrvMsgField = (TibrvMsgField)vector.elementAt(n);
            }
        }
        return tibrvMsgField;
    }

    private boolean _removeImpl(String string, int n) throws TibrvException {
        TibrvMsgField tibrvMsgField = this._getField(string, n);
        if (tibrvMsgField == null) {
            return false;
        }
        this._remove(tibrvMsgField);
        return true;
    }

    private boolean _removeInstance(String string, int n) {
        try {
            TibrvMsgField tibrvMsgField = this._getInstance(string, n);
            if (tibrvMsgField == null) {
                return false;
            }
            this._remove(tibrvMsgField);
        }
        catch (TibrvException tibrvException) {
            return false;
        }
        return true;
    }

    private void _remove(TibrvMsgField tibrvMsgField) {
        Object object;
        Object v;
        if (this._fields == null) {
            return;
        }
        if (tibrvMsgField.id != 0 && this._hashIDs != null) {
            this._hashIDs.remove(new Integer(tibrvMsgField.id));
        }
        if (this._hashNames != null && (v = this._hashNames.get(object = this._nameKey(tibrvMsgField.name))) != null) {
            if (v instanceof TibrvMsgField) {
                this._hashNames.remove(object);
            } else if (v instanceof Vector) {
                Vector vector = (Vector)v;
                if (vector.size() < 2) {
                    throw new InternalError("fields vector");
                }
                vector.removeElement(tibrvMsgField);
                if (vector.size() == 1) {
                    this._hashNames.put(object, vector.firstElement());
                }
            } else {
                throw new InternalError("wrong object in hashNames");
            }
        }
        this._fields.removeElement(tibrvMsgField);
    }

    private final Object _nameKey(String string) {
        if (string != null) {
            return string;
        }
        return _nullNameKey;
    }

    private void cacheBytes(byte[] byArray, int n, int n2) throws TibrvException {
        TibrvImplMsgBuffer tibrvImplMsgBuffer = new TibrvImplMsgBuffer(byArray, n, n2);
        try {
            int n3 = tibrvImplMsgBuffer.readInt();
            int n4 = tibrvImplMsgBuffer.readInt();
            if (n3 > n2) {
                throw new TibrvException("Invalid buffer length", 42);
            }
            if (n4 != -1722421590) {
                throw new TibrvException("Invalid message header", 42);
            }
        }
        catch (Exception exception) {
            throw new TibrvException("Corrupted message buffer", 42);
        }
        if (byArray.length == n2 && n == 0) {
            this._wireBuffer = byArray;
        } else {
            this._wireBuffer = new byte[n2];
            System.arraycopy(byArray, n, this._wireBuffer, 0, n2);
        }
    }

    private final void check() throws TibrvException {
        byte[] byArray = null;
        try {
            if (this._wireBuffer != null) {
                byArray = this._wireBuffer;
                this._wireBuffer = null;
                this.readFromBytes(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            this.clear();
            this._wireBuffer = byArray;
            throw new TibrvException("Corrupted message buffer", 42, exception);
        }
    }

    private synchronized void clear() {
        this._fields = null;
        this._wireBuffer = null;
        this._hashNames = null;
        this._hashIDs = null;
    }

    private static final short checkConvert(Object object, short s, short s2) throws TibrvException {
        if (TibrvMsg.isUserType(s)) {
            TibrvImplMsgEnc tibrvImplMsgEnc;
            int n = -1;
            if (_encoders != null && (tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s))) != null && tibrvImplMsgEnc.encoder != null) {
                try {
                    n = tibrvImplMsgEnc.encoder.canEncode(s, object) ? 1 : 0;
                }
                catch (Exception exception) {
                    throw new TibrvException(40, (Throwable)exception);
                }
            }
            if (n == -1) {
                throw new TibrvException("Encoder does not exist for type=" + (s & 0xFF), 31);
            }
            if (n == 0) {
                throw new TibrvException("Can not encode data for field type=" + (s & 0xFF), 34);
            }
            return s;
        }
        if (!TibrvImplMsgUtil.isValidType(s)) {
            throw new TibrvException(31);
        }
        if (s2 == 0 && (s2 = TibrvImplMsgUtil.getObjectType(object)) == 0) {
            throw new TibrvException("Invalid type of data object", 34);
        }
        if (s != 0 && !TibrvImplMsgUtil.canConvertType(s2, s)) {
            throw new TibrvException(38);
        }
        return s2;
    }

    private final void checkNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null parameter");
        }
    }

    private final void checkId(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Field id is out of range");
        }
    }

    private void readFromBytes(byte[] byArray, int n, int n2) throws TibrvException {
        try {
            if (this._fields == null) {
                this._fields = new Vector();
            }
            this.readFromBytesImpl(byArray, n, n2);
            return;
        }
        catch (Exception exception) {
            throw new TibrvException("Can not recover message from bytes", 42, exception);
        }
    }

    private void readFromBytesImpl(byte[] byArray, int n, int n2) throws EOFException, TibrvException {
        this.clear();
        TibrvImplMsgBuffer tibrvImplMsgBuffer = new TibrvImplMsgBuffer(byArray, n, n2);
        int n3 = tibrvImplMsgBuffer.readInt();
        int n4 = tibrvImplMsgBuffer.readInt();
        if (n3 > byArray.length) {
            throw new TibrvException("Invalid buffer length", 42);
        }
        if (n4 != -1722421590) {
            throw new TibrvException("Invalid message header", 42);
        }
        this.readFields(tibrvImplMsgBuffer, n + n3);
    }

    private void readFields(TibrvImplMsgBuffer tibrvImplMsgBuffer, int n) throws TibrvException, EOFException {
        TibrvMsgField tibrvMsgField = new TibrvMsgField();
        while (tibrvImplMsgBuffer.offset < n) {
            if (!this.readField(tibrvImplMsgBuffer, tibrvMsgField)) {
                return;
            }
            this._addField(tibrvMsgField.name, tibrvMsgField.id, tibrvMsgField.data, tibrvMsgField.type, tibrvMsgField.type);
        }
    }

    private boolean readField(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvMsgField tibrvMsgField) throws TibrvException, EOFException {
        if (tibrvImplMsgBuffer.offset >= tibrvImplMsgBuffer.buflen) {
            return false;
        }
        tibrvMsgField.data = null;
        tibrvMsgField.id = 0;
        tibrvMsgField.name = null;
        tibrvMsgField.type = 0;
        int n = tibrvImplMsgBuffer.readUnsignedByte();
        if (n > 0) {
            if (n > 2 && tibrvImplMsgBuffer.bytes[tibrvImplMsgBuffer.offset + n - 3] == 0) {
                tibrvMsgField.name = tibrvImplMsgBuffer.readString(n - 2, this._encoding);
                tibrvMsgField.id = tibrvImplMsgBuffer.readShort() & 0xFFFF;
            } else {
                tibrvMsgField.name = tibrvImplMsgBuffer.readString(n, this._encoding);
            }
        }
        this.readData(tibrvImplMsgBuffer, tibrvMsgField);
        return true;
    }

    private void writeFields(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException {
        if (this._fields != null) {
            int n = this._fields.size();
            int n2 = 0;
            while (n2 < n) {
                this.writeFieldImpl(tibrvImplMsgBuffer, (TibrvMsgField)this._fields.elementAt(n2));
                ++n2;
            }
        }
    }

    private void writeFieldImpl(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvMsgField tibrvMsgField) throws TibrvException {
        if (tibrvMsgField.data == null) {
            throw new TibrvException("Field data is null in field " + tibrvMsgField.toString(), 34);
        }
        short s = tibrvMsgField.type;
        if (TibrvMsg.isUserType(s)) {
            s = tibrvMsgField.type;
        } else {
            s = TibrvImplMsgUtil.getObjectType(tibrvMsgField.data);
            if (s == 0) {
                throw new TibrvException(34);
            }
        }
        int n = 0;
        int n2 = tibrvMsgField.id > 0 ? 2 : 0;
        int n3 = tibrvImplMsgBuffer.getOffset();
        tibrvImplMsgBuffer.writeByte(0);
        if (tibrvMsgField.name != null) {
            byte[] byArray = tibrvImplMsgBuffer.writeString(tibrvMsgField.name, this._encoding, false);
            if (byArray == null) {
                n = tibrvMsgField.name.length() + 1;
            } else {
                n = byArray.length + 1;
                tibrvImplMsgBuffer.write(byArray);
                tibrvImplMsgBuffer.writeByte(0);
            }
        }
        if (n > 252) {
            throw new TibrvException(30);
        }
        tibrvImplMsgBuffer.mark();
        tibrvImplMsgBuffer.setOffset(n3);
        tibrvImplMsgBuffer.writeByte((byte)(n + n2));
        tibrvImplMsgBuffer.resetmark();
        if (tibrvMsgField.id > 0) {
            tibrvImplMsgBuffer.writeShort(tibrvMsgField.id);
        }
        if (tibrvMsgField.type == 2) {
            tibrvImplMsgBuffer.writeByte(tibrvMsgField.type);
            TibrvMsg.writeSubject(tibrvImplMsgBuffer, (String)tibrvMsgField.data, this._encoding);
        } else {
            short s2 = tibrvMsgField.type;
            if (s2 == 0) {
                s2 = s;
            }
            if (!this.writeData(tibrvImplMsgBuffer, tibrvMsgField, s, s2)) {
                throw new TibrvException(38);
            }
        }
    }

    private boolean writeData(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvMsgField tibrvMsgField, short s, short s2) throws TibrvException {
        Object object = tibrvMsgField.data;
        short s3 = TibrvImplMsgUtil.type6to5(s2);
        tibrvImplMsgBuffer.writeByte((byte)s3);
        if (TibrvMsg.isUserType(s2)) {
            if (_encoders == null) {
                return false;
            }
            TibrvImplMsgEnc tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s2));
            byte[] byArray = null;
            if (tibrvImplMsgEnc != null && tibrvImplMsgEnc.encoder != null) {
                try {
                    byArray = tibrvImplMsgEnc.encoder.encode(s2, object);
                }
                catch (Exception exception) {
                    throw new TibrvException(40, (Throwable)exception);
                }
            }
            if (byArray == null) {
                throw new TibrvException("Encoder not found or failed for field: name=" + tibrvMsgField.name + " id=" + tibrvMsgField.id + "type=" + (s2 & 0xFF), 40);
            }
            TibrvMsg.writeVarSize(tibrvImplMsgBuffer, byArray.length);
            if (byArray.length > 0) {
                tibrvImplMsgBuffer.write(byArray);
            }
            return true;
        }
        int n = TibrvImplMsgUtil.getTypeSize(s2);
        switch (s) {
            case 1: {
                switch (s2) {
                    case 1: {
                        TibrvMsg.writeMsg(tibrvImplMsgBuffer, (TibrvMsg)object);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 8: {
                if (s2 == 8) {
                    TibrvMsg.writeString(tibrvImplMsgBuffer, (String)object, this._encoding);
                    return true;
                }
                return false;
            }
            case 47: {
                switch (s2) {
                    case 47: {
                        TibrvMsg.writeXml(tibrvImplMsgBuffer, (TibrvXml)object);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 3: {
                switch (s2) {
                    case 3: {
                        TibrvMsg.writeDate(tibrvImplMsgBuffer, (Date)object);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 32: {
                switch (s2) {
                    case 32: {
                        TibrvMsg.writeEncrypted(tibrvImplMsgBuffer, (TibrvEncrypted)object);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 26: {
                int n2 = ((TibrvIPPort)object).getPort();
                short s4 = (short)(n2 & 0xFFFF);
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                switch (s2) {
                    case 16: 
                    case 17: 
                    case 26: {
                        tibrvImplMsgBuffer.writeShort(s4);
                        break;
                    }
                    case 18: 
                    case 19: {
                        tibrvImplMsgBuffer.writeInt(n2);
                        break;
                    }
                    case 20: 
                    case 21: {
                        tibrvImplMsgBuffer.writeLong(n2);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 27: {
                if (object instanceof InetAddress) {
                    object = new TibrvIPAddr(((InetAddress)object).getAddress());
                }
                int n3 = ((TibrvIPAddr)object).getAddr();
                long l = (long)n3 & 0xFFFFFFFFL;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                switch (s2) {
                    case 18: 
                    case 19: 
                    case 27: {
                        tibrvImplMsgBuffer.writeInt(n3);
                        break;
                    }
                    case 20: 
                    case 21: {
                        tibrvImplMsgBuffer.writeLong(l);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 9: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeBool(tibrvImplMsgBuffer, (Boolean)object, s2);
            }
            case 14: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeByte(tibrvImplMsgBuffer, (Byte)object, s2);
            }
            case 16: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeShort(tibrvImplMsgBuffer, (Short)object, s2);
            }
            case 18: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeInt(tibrvImplMsgBuffer, (Integer)object, s2);
            }
            case 20: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeLong(tibrvImplMsgBuffer, (Long)object, s2);
            }
            case 24: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeFloat(tibrvImplMsgBuffer, ((Float)object).floatValue(), s2);
            }
            case 25: {
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
                return TibrvMsg.writeDouble(tibrvImplMsgBuffer, (Double)object, s2);
            }
            case 7: {
                short s5 = TibrvImplMsgUtil.getElementType(s2);
                if (s5 == 0) {
                    return false;
                }
                byte[] byArray = (byte[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * byArray.length);
                if (n == 1) {
                    tibrvImplMsgBuffer.write(byArray);
                } else {
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        if (!TibrvMsg.writeByte(tibrvImplMsgBuffer, byArray[n4], s5)) {
                            return false;
                        }
                        ++n4;
                    }
                }
                return true;
            }
            case 36: {
                short s6 = TibrvImplMsgUtil.getElementType(s2);
                if (s6 == 0) {
                    return false;
                }
                short[] sArray = (short[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * sArray.length);
                int n5 = 0;
                while (n5 < sArray.length) {
                    if (!TibrvMsg.writeShort(tibrvImplMsgBuffer, sArray[n5], s6)) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
            case 38: {
                short s7 = TibrvImplMsgUtil.getElementType(s2);
                if (s7 == 0) {
                    return false;
                }
                int[] nArray = (int[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * nArray.length);
                int n6 = 0;
                while (n6 < nArray.length) {
                    if (!TibrvMsg.writeInt(tibrvImplMsgBuffer, nArray[n6], s7)) {
                        return false;
                    }
                    ++n6;
                }
                return true;
            }
            case 40: {
                short s8 = TibrvImplMsgUtil.getElementType(s2);
                if (s8 == 0) {
                    return false;
                }
                long[] lArray = (long[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * lArray.length);
                int n7 = 0;
                while (n7 < lArray.length) {
                    if (!TibrvMsg.writeLong(tibrvImplMsgBuffer, lArray[n7], s8)) {
                        return false;
                    }
                    ++n7;
                }
                return true;
            }
            case 44: {
                short s9 = TibrvImplMsgUtil.getElementType(s2);
                if (s9 == 0) {
                    return false;
                }
                float[] fArray = (float[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * fArray.length);
                int n8 = 0;
                while (n8 < fArray.length) {
                    if (!TibrvMsg.writeFloat(tibrvImplMsgBuffer, fArray[n8], s9)) {
                        return false;
                    }
                    ++n8;
                }
                return true;
            }
            case 45: {
                short s10 = TibrvImplMsgUtil.getElementType(s2);
                if (s10 == 0) {
                    return false;
                }
                double[] dArray = (double[])object;
                TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n * dArray.length);
                int n9 = 0;
                while (n9 < dArray.length) {
                    if (!TibrvMsg.writeDouble(tibrvImplMsgBuffer, dArray[n9], s10)) {
                        return false;
                    }
                    ++n9;
                }
                return true;
            }
        }
        return false;
    }

    private void readData(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvMsgField tibrvMsgField) throws TibrvException, EOFException {
        short s;
        tibrvMsgField.type = s = (short)tibrvImplMsgBuffer.readUnsignedByte();
        tibrvMsgField.data = null;
        if (TibrvMsg.isUserType(s)) {
            TibrvImplMsgEnc tibrvImplMsgEnc;
            int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
            if (_encoders != null && (tibrvImplMsgEnc = (TibrvImplMsgEnc)_encoders.get(new Short(s))) != null && tibrvImplMsgEnc.decoder != null) {
                byte[] byArray = new byte[n];
                tibrvImplMsgBuffer.readFully(byArray);
                try {
                    tibrvMsgField.data = tibrvImplMsgEnc.decoder.decode(s, byArray);
                }
                catch (Exception exception) {
                    throw new TibrvException(41, (Throwable)exception);
                }
                return;
            }
            tibrvImplMsgBuffer.skip(n);
            return;
        }
        switch (s) {
            case 8: {
                tibrvMsgField.data = tibrvImplMsgBuffer.readString(TibrvMsg.readVarSize(tibrvImplMsgBuffer), this._encoding);
                return;
            }
            case 1: {
                tibrvMsgField.data = TibrvMsg.readMsg(tibrvImplMsgBuffer);
                return;
            }
            case 3: {
                tibrvMsgField.data = TibrvMsg.readDate(tibrvImplMsgBuffer);
                return;
            }
            case 2: {
                tibrvMsgField.data = TibrvMsg.readSubject(tibrvImplMsgBuffer, this._encoding);
                return;
            }
            case 47: {
                tibrvMsgField.data = TibrvMsg.readXml(tibrvImplMsgBuffer);
                return;
            }
            case 10: {
                int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
                tibrvMsgField.type = TibrvImplMsgUtil.type5to6(s, n);
                tibrvMsgField.data = TibrvMsg.readIPData(tibrvImplMsgBuffer, tibrvMsgField.type, n);
                return;
            }
            case 26: 
            case 27: {
                int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
                tibrvMsgField.data = TibrvMsg.readIPData(tibrvImplMsgBuffer, tibrvMsgField.type, n);
                return;
            }
            case 32: {
                tibrvMsgField.data = TibrvMsg.readEncrypted(tibrvImplMsgBuffer);
                return;
            }
            case 9: {
                tibrvMsgField.data = TibrvMsg.readBool(tibrvImplMsgBuffer);
                return;
            }
            case 11: 
            case 12: 
            case 13: {
                int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
                tibrvMsgField.type = TibrvImplMsgUtil.type5to6(s, n);
                tibrvMsgField.data = TibrvMsg.readNumber(tibrvImplMsgBuffer, tibrvMsgField.type, n);
                return;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
                tibrvMsgField.data = TibrvMsg.readNumber(tibrvImplMsgBuffer, s, n);
                return;
            }
            case 7: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                tibrvMsgField.data = TibrvMsg.readArray(tibrvImplMsgBuffer, s);
                return;
            }
        }
        int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        tibrvImplMsgBuffer.skip(n);
    }

    private static final int getVarSizeLen(int n) {
        if (n < 120) {
            return 1;
        }
        if (n < 30000) {
            return 3;
        }
        return 5;
    }

    private static final void writeVarSize(TibrvImplMsgBuffer tibrvImplMsgBuffer, int n) {
        if (n < 120) {
            tibrvImplMsgBuffer.writeByte((byte)n);
        } else if (n < 30000) {
            tibrvImplMsgBuffer.writeByte(121);
            tibrvImplMsgBuffer.writeShort((short)n + 2);
        } else {
            tibrvImplMsgBuffer.writeByte(122);
            tibrvImplMsgBuffer.writeInt(n + 4);
        }
    }

    private static final int readVarSize(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws EOFException {
        int n = tibrvImplMsgBuffer.readUnsignedByte();
        if (n == 121) {
            return tibrvImplMsgBuffer.readShort() - 2;
        }
        if (n == 122) {
            return tibrvImplMsgBuffer.readInt() - 4;
        }
        return n;
    }

    private static final void writeXml(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvXml tibrvXml) throws TibrvException {
        byte[] byArray = tibrvXml.getBytes();
        int n = byArray.length;
        Deflater deflater = new Deflater(-1);
        int n2 = (int)((double)n * 1.001) + 12 + 256;
        byte[] byArray2 = new byte[n2];
        deflater.setInput(byArray);
        deflater.finish();
        int n3 = deflater.deflate(byArray2);
        if (n3 <= 0) {
            throw new TibrvException(34);
        }
        int n4 = TibrvMsg.getVarSizeLen(n) + n3;
        TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n4);
        TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
        tibrvImplMsgBuffer.write(byArray2, 0, n3);
    }

    private static TibrvXml readXml(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException, EOFException {
        int n;
        boolean bl = false;
        int n2 = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        int n3 = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        if (n3 == 0) {
            n = n3 = n2 - 1;
            bl = true;
        }
        byte[] byArray = new byte[n3];
        if (bl) {
            tibrvImplMsgBuffer.readFully(byArray);
        } else {
            try {
                n = n2 - TibrvMsg.getVarSizeLen(n3);
                Inflater inflater = new Inflater();
                inflater.setInput(tibrvImplMsgBuffer.bytes, tibrvImplMsgBuffer.offset, n);
                tibrvImplMsgBuffer.offset += n;
                int n4 = inflater.inflate(byArray);
                if (n4 != n3) {
                    throw new TibrvException(45);
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new TibrvException(45, (Throwable)dataFormatException);
            }
        }
        return new TibrvXml(byArray);
    }

    private static final void writeMsg(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvMsg tibrvMsg) throws TibrvException {
        Object object = tibrvMsg.getAsBytesRaw();
        tibrvImplMsgBuffer.writeByte(122);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            tibrvImplMsgBuffer.write(byArray, 0, byArray.length);
        } else {
            TibrvImplMsgBuffer tibrvImplMsgBuffer2 = (TibrvImplMsgBuffer)object;
            tibrvImplMsgBuffer.write(tibrvImplMsgBuffer2.bytes, 0, tibrvImplMsgBuffer2.offset);
        }
    }

    private static TibrvMsg readMsg(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException, EOFException {
        int n = tibrvImplMsgBuffer.readUnsignedByte();
        if (n != 122) {
            throw new TibrvException("Invalid message header", 42);
        }
        tibrvImplMsgBuffer.mark();
        int n2 = tibrvImplMsgBuffer.readInt();
        tibrvImplMsgBuffer.resetmark();
        TibrvMsg tibrvMsg = new TibrvMsg(tibrvImplMsgBuffer.bytes, tibrvImplMsgBuffer.offset, n2);
        tibrvImplMsgBuffer.offset += n2;
        return tibrvMsg;
    }

    private static final void writeDate(TibrvImplMsgBuffer tibrvImplMsgBuffer, Date date) throws TibrvException {
        TibrvDate tibrvDate;
        if (date instanceof TibrvDate) {
            tibrvDate = (TibrvDate)date;
        } else {
            try {
                tibrvDate = new TibrvDate(date);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TibrvException("Date out of range", 34);
            }
        }
        TibrvMsg.writeVarSize(tibrvImplMsgBuffer, 8);
        long l = tibrvDate.getTimeSeconds();
        int n = tibrvDate.getTimeNanoseconds() / 1000;
        int n2 = (int)l;
        int n3 = (int)((l & 0xFF00000000L) >> 8) | n & 0xFFFFFF;
        tibrvImplMsgBuffer.writeInt(n2);
        tibrvImplMsgBuffer.writeInt(n3);
    }

    private static final TibrvDate readDate(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException, EOFException {
        int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        if (n != 8) {
            throw new TibrvException("Wrong length of DATETIME data", 34);
        }
        int n2 = tibrvImplMsgBuffer.readInt();
        int n3 = tibrvImplMsgBuffer.readInt();
        long l = (long)n2 & 0xFFFFFFFFL | (long)(n3 & 0xFF000000) << 8;
        long l2 = n3 & 0xFFFFFF;
        return new TibrvDate(l, (int)(l2 * 1000L));
    }

    private static final void writeString(TibrvImplMsgBuffer tibrvImplMsgBuffer, String string, String string2) throws TibrvException {
        int n = string.length() + 1;
        int n2 = tibrvImplMsgBuffer.getOffset();
        TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
        byte[] byArray = tibrvImplMsgBuffer.writeString(string, string2, true);
        if (byArray == null) {
            return;
        }
        tibrvImplMsgBuffer.setOffset(n2);
        n = byArray.length + 1;
        TibrvMsg.writeVarSize(tibrvImplMsgBuffer, n);
        tibrvImplMsgBuffer.write(byArray);
        tibrvImplMsgBuffer.writeByte(0);
    }

    private static final String readSubject(TibrvImplMsgBuffer tibrvImplMsgBuffer, String string) throws EOFException, TibrvException {
        String string2;
        int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        int n2 = tibrvImplMsgBuffer.readUnsignedByte();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = 0;
        while (n3 < n2) {
            string2 = TibrvMsg.readSubjectPart(tibrvImplMsgBuffer, string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string2);
            ++n3;
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    private static final String readSubjectPart(TibrvImplMsgBuffer tibrvImplMsgBuffer, String string) throws EOFException, TibrvException {
        int n = tibrvImplMsgBuffer.readUnsignedByte();
        if (n > 1) {
            return tibrvImplMsgBuffer.readString(--n, string);
        }
        throw new TibrvException("Invalid subject in the message", 42);
    }

    private static final void writeSubject(TibrvImplMsgBuffer tibrvImplMsgBuffer, String string, String string2) throws TibrvException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        int n3 = string.length() - (n - 1);
        int n4 = 1 + n3 + 2 * n;
        tibrvImplMsgBuffer.writeByte(121);
        int n5 = tibrvImplMsgBuffer.getOffset();
        tibrvImplMsgBuffer.writeShort((short)(n4 + 2));
        tibrvImplMsgBuffer.writeByte((byte)n);
        int n6 = 0;
        while (n6 < n) {
            String string3 = stringTokenizer.nextToken();
            int n7 = string3.length();
            int n8 = tibrvImplMsgBuffer.getOffset();
            tibrvImplMsgBuffer.writeByte((byte)(n7 + 2));
            byte[] byArray = tibrvImplMsgBuffer.writeString(string3, string2, false);
            if (byArray != null) {
                n7 = byArray.length;
                tibrvImplMsgBuffer.setOffset(n8);
                tibrvImplMsgBuffer.writeByte((byte)(n7 + 2));
                tibrvImplMsgBuffer.write(byArray);
                tibrvImplMsgBuffer.writeByte(0);
                if (n7 > 127) {
                    throw new TibrvException(20);
                }
            }
            n2 += n7;
            ++n6;
        }
        if (n3 != n2) {
            tibrvImplMsgBuffer.mark();
            tibrvImplMsgBuffer.setOffset(n5);
            n4 = 1 + n2 + 2 * n;
            tibrvImplMsgBuffer.writeShort((short)(n4 + 2));
            tibrvImplMsgBuffer.resetmark();
        }
        if (n4 > 255) {
            throw new TibrvException(20);
        }
    }

    private static final Object readIPData(TibrvImplMsgBuffer tibrvImplMsgBuffer, short s, int n) throws TibrvException, EOFException {
        byte[] byArray = new byte[4];
        switch (s) {
            case 26: {
                byArray[0] = tibrvImplMsgBuffer.readByte();
                byArray[1] = tibrvImplMsgBuffer.readByte();
                return new TibrvIPPort(byArray[0], byArray[1]);
            }
            case 27: {
                byArray[0] = tibrvImplMsgBuffer.readByte();
                byArray[1] = tibrvImplMsgBuffer.readByte();
                byArray[2] = tibrvImplMsgBuffer.readByte();
                byArray[3] = tibrvImplMsgBuffer.readByte();
                return new TibrvIPAddr(byArray);
            }
        }
        throw new TibrvException("Corrupted message buffer", 42);
    }

    private static final Object readBool(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException, EOFException {
        int n = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        if (n != 1) {
            throw new TibrvException("Wrong length of BOOL data", 34);
        }
        return new Boolean(tibrvImplMsgBuffer.readByte() != 0);
    }

    private static final Object readNumber(TibrvImplMsgBuffer tibrvImplMsgBuffer, short s, int n) throws TibrvException, EOFException {
        switch (s) {
            case 14: {
                return new Byte(tibrvImplMsgBuffer.readByte());
            }
            case 15: {
                return new Short((short)tibrvImplMsgBuffer.readUnsignedByte());
            }
            case 16: {
                return new Short(tibrvImplMsgBuffer.readShort());
            }
            case 17: {
                return new Integer(tibrvImplMsgBuffer.readShort() & 0xFFFF);
            }
            case 18: {
                return new Integer(tibrvImplMsgBuffer.readInt());
            }
            case 19: {
                return new Long((long)tibrvImplMsgBuffer.readInt() & 0xFFFFFFFFL);
            }
            case 20: 
            case 21: {
                return new Long(tibrvImplMsgBuffer.readLong());
            }
            case 24: {
                return new Float(tibrvImplMsgBuffer.readFloat());
            }
            case 25: {
                return new Double(tibrvImplMsgBuffer.readDouble());
            }
        }
        throw new TibrvException("Corrupted message buffer", 42);
    }

    private static Object readArray(TibrvImplMsgBuffer tibrvImplMsgBuffer, short s) throws TibrvException, EOFException {
        int n;
        int n2 = TibrvMsg.readVarSize(tibrvImplMsgBuffer);
        if (n2 % (n = TibrvImplMsgUtil.getTypeSize(s)) != 0) {
            throw new TibrvException("Invalid array length", 42);
        }
        int n3 = n2 / n;
        switch (s) {
            case 7: 
            case 34: {
                byte[] byArray = new byte[n3];
                tibrvImplMsgBuffer.readFully(byArray);
                return byArray;
            }
            case 35: {
                short[] sArray = new short[n3];
                int n4 = 0;
                while (n4 < n3) {
                    sArray[n4] = (short)tibrvImplMsgBuffer.readUnsignedByte();
                    ++n4;
                }
                return sArray;
            }
            case 36: {
                short[] sArray = new short[n3];
                int n5 = 0;
                while (n5 < n3) {
                    sArray[n5] = tibrvImplMsgBuffer.readShort();
                    ++n5;
                }
                return sArray;
            }
            case 37: {
                int[] nArray = new int[n3];
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n6] = tibrvImplMsgBuffer.readShort() & 0xFFFF;
                    ++n6;
                }
                return nArray;
            }
            case 38: {
                int[] nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = tibrvImplMsgBuffer.readInt();
                    ++n7;
                }
                return nArray;
            }
            case 39: {
                long[] lArray = new long[n3];
                int n8 = 0;
                while (n8 < n3) {
                    lArray[n8] = (long)tibrvImplMsgBuffer.readInt() & 0xFFFFFFFFL;
                    ++n8;
                }
                return lArray;
            }
            case 40: 
            case 41: {
                long[] lArray = new long[n3];
                int n9 = 0;
                while (n9 < n3) {
                    lArray[n9] = tibrvImplMsgBuffer.readLong();
                    ++n9;
                }
                return lArray;
            }
            case 44: {
                float[] fArray = new float[n3];
                int n10 = 0;
                while (n10 < n3) {
                    fArray[n10] = tibrvImplMsgBuffer.readFloat();
                    ++n10;
                }
                return fArray;
            }
            case 45: {
                double[] dArray = new double[n3];
                int n11 = 0;
                while (n11 < n3) {
                    dArray[n11] = tibrvImplMsgBuffer.readDouble();
                    ++n11;
                }
                return dArray;
            }
        }
        throw new TibrvException("Invalid array type", 42);
    }

    private static final TibrvEncrypted readEncrypted(TibrvImplMsgBuffer tibrvImplMsgBuffer) throws TibrvException, EOFException {
        tibrvImplMsgBuffer.mark();
        int n = tibrvImplMsgBuffer.readInt();
        int n2 = tibrvImplMsgBuffer.readInt();
        if (n2 != -1722421573) {
            throw new TibrvException("Error unpacking message", 42);
        }
        tibrvImplMsgBuffer.resetmark();
        byte[] byArray = new byte[n];
        tibrvImplMsgBuffer.readFully(byArray, 0, n);
        return new TibrvEncrypted(byArray);
    }

    private static final void writeEncrypted(TibrvImplMsgBuffer tibrvImplMsgBuffer, TibrvEncrypted tibrvEncrypted) throws TibrvException {
        byte[] byArray = tibrvEncrypted.contents;
        tibrvImplMsgBuffer.writeByte(122);
        tibrvImplMsgBuffer.write(byArray);
    }

    private static final boolean writeBool(TibrvImplMsgBuffer tibrvImplMsgBuffer, boolean bl, short s) {
        int n = bl ? 1 : 0;
        switch (s) {
            case 9: {
                tibrvImplMsgBuffer.writeByte(bl ? 1 : 0);
                break;
            }
            case 14: 
            case 15: {
                tibrvImplMsgBuffer.writeByte(n);
                break;
            }
            case 16: 
            case 17: {
                tibrvImplMsgBuffer.writeShort((short)n);
                break;
            }
            case 18: 
            case 19: {
                tibrvImplMsgBuffer.writeInt(n);
                break;
            }
            case 20: 
            case 21: {
                tibrvImplMsgBuffer.writeLong(n);
                break;
            }
            case 24: {
                tibrvImplMsgBuffer.writeFloat(n);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(n);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeByte(TibrvImplMsgBuffer tibrvImplMsgBuffer, byte by, short s) {
        switch (s) {
            case 9: {
                tibrvImplMsgBuffer.writeByte(by == 0 ? 0 : 1);
                break;
            }
            case 14: 
            case 15: {
                tibrvImplMsgBuffer.writeByte(by);
                break;
            }
            case 16: 
            case 17: {
                tibrvImplMsgBuffer.writeShort(by);
                break;
            }
            case 18: 
            case 19: {
                tibrvImplMsgBuffer.writeInt(by);
                break;
            }
            case 20: 
            case 21: {
                tibrvImplMsgBuffer.writeLong(by);
                break;
            }
            case 24: {
                tibrvImplMsgBuffer.writeFloat(by);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(by);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeShort(TibrvImplMsgBuffer tibrvImplMsgBuffer, short s, short s2) {
        switch (s2) {
            case 9: {
                tibrvImplMsgBuffer.writeByte(s != 0 ? 1 : 0);
                break;
            }
            case 14: 
            case 15: {
                tibrvImplMsgBuffer.writeByte((byte)s);
                break;
            }
            case 16: 
            case 17: 
            case 26: {
                tibrvImplMsgBuffer.writeShort(s);
                break;
            }
            case 18: 
            case 19: {
                tibrvImplMsgBuffer.writeInt(s);
                break;
            }
            case 20: 
            case 21: {
                tibrvImplMsgBuffer.writeLong(s);
                break;
            }
            case 24: {
                tibrvImplMsgBuffer.writeFloat(s);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(s);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeInt(TibrvImplMsgBuffer tibrvImplMsgBuffer, int n, short s) {
        switch (s) {
            case 9: {
                tibrvImplMsgBuffer.writeByte(n != 0 ? 1 : 0);
                break;
            }
            case 14: 
            case 15: {
                tibrvImplMsgBuffer.writeByte((byte)n);
                break;
            }
            case 26: {
                tibrvImplMsgBuffer.writeShort((short)(n & 0xFFFF));
                break;
            }
            case 16: {
                tibrvImplMsgBuffer.writeShort((short)n);
                break;
            }
            case 17: {
                tibrvImplMsgBuffer.writeShort((short)(n & 0xFFFF));
                break;
            }
            case 18: 
            case 19: 
            case 27: {
                tibrvImplMsgBuffer.writeInt(n);
                break;
            }
            case 20: {
                tibrvImplMsgBuffer.writeLong(n);
                break;
            }
            case 21: {
                tibrvImplMsgBuffer.writeLong(n);
                break;
            }
            case 24: {
                tibrvImplMsgBuffer.writeFloat(n);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(n);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeLong(TibrvImplMsgBuffer tibrvImplMsgBuffer, long l, short s) {
        switch (s) {
            case 9: {
                tibrvImplMsgBuffer.writeByte(l != 0L ? 1 : 0);
                break;
            }
            case 14: 
            case 15: {
                tibrvImplMsgBuffer.writeByte((byte)l);
                break;
            }
            case 16: 
            case 17: 
            case 26: {
                tibrvImplMsgBuffer.writeShort((short)l);
                break;
            }
            case 18: 
            case 19: 
            case 27: {
                tibrvImplMsgBuffer.writeInt((int)l);
                break;
            }
            case 20: {
                tibrvImplMsgBuffer.writeLong(l);
                break;
            }
            case 21: {
                tibrvImplMsgBuffer.writeLong(l);
                break;
            }
            case 24: {
                tibrvImplMsgBuffer.writeFloat(l);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(l);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeFloat(TibrvImplMsgBuffer tibrvImplMsgBuffer, float f, short s) {
        switch (s) {
            case 24: {
                tibrvImplMsgBuffer.writeFloat(f);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(f);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final boolean writeDouble(TibrvImplMsgBuffer tibrvImplMsgBuffer, double d, short s) {
        switch (s) {
            case 24: {
                tibrvImplMsgBuffer.writeFloat((float)d);
                break;
            }
            case 25: {
                tibrvImplMsgBuffer.writeDouble(d);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    static final void intToBytes(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n2 + n3] = (byte)(n >>> 8 * (3 - n3) & 0xFF);
            ++n3;
        }
    }

    static final boolean isUserType(short s) {
        return s >= 128 && s <= 255;
    }

    static {
        _defaultEncoding = DEFAULT_ENCODING = _ENC_NAME_8859_1;
        try {
            _defaultEncoding = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            _defaultEncoding = DEFAULT_ENCODING;
            System.err.println("\nTIB/Rendezvous: Browser's security settings preclude accessing Java System Property \"file.encoding\".");
            System.err.println("TIB/Rendezvous: Using default encoding " + _defaultEncoding + " instead.\n");
        }
        catch (Exception exception) {
            _defaultEncoding = DEFAULT_ENCODING;
        }
    }
}

