/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplEvtData;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueJ;
import com.tibco.tibrv.TibrvQueueGroup;
import java.util.Vector;

public class TibrvQueue
implements TibrvDispatchable {
    public static final int DISCARD_NONE = 0;
    public static final int DISCARD_NEW = 1;
    public static final int DISCARD_FIRST = 2;
    public static final int DISCARD_LAST = 3;
    public static final int DEFAULT_POLICY = 0;
    public static final int DEFAULT_PRIORITY = 1;
    protected TibrvImplQueue _impl = null;
    protected Object _lock = new Object();
    protected boolean _default = false;
    protected boolean _valid = false;
    protected String _name = "tibrvQueue";
    protected Vector _groups = null;
    protected int _eventCount = 0;
    private static final String _implName = "TibrvImplQueue";
    public static final String DEFAULT_NAME = "Default Queue";

    public TibrvQueue() throws TibrvException {
        this.init(false);
    }

    TibrvQueue(boolean bl) throws TibrvException {
        if (bl && Tibrv.defaultQueue() != null) {
            throw new TibrvException("Can not create second default queue", 27);
        }
        this.init(true);
    }

    private final void init(boolean bl) throws TibrvException {
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        this._default = bl;
        if (this._default) {
            this._name = DEFAULT_NAME;
        }
        this._impl = (TibrvImplQueue)Tibrv.createObjectImpl(_implName);
        this._impl.create(this);
        tibrvImpl.register(this);
        this._valid = true;
    }

    public final boolean isValid() {
        return this._valid;
    }

    public final boolean isDefault() {
        return this._default;
    }

    public void destroy() {
        if (this._default) {
            throw new IllegalStateException("Can not destroy default queue");
        }
        this.destroyImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyImpl() {
        try {
            boolean bl = false;
            TibrvImplQueue tibrvImplQueue = null;
            TibrvImpl tibrvImpl = null;
            Object object = this._lock;
            synchronized (object) {
                if (!this._valid) {
                    return;
                }
                this._valid = false;
                tibrvImpl = Tibrv._impl;
                Tibrv.checkValid();
                bl = true;
                tibrvImplQueue = this._impl;
                this._impl = null;
            }
            if (bl) {
                this.ungroup();
            }
            if (tibrvImpl != null) {
                tibrvImpl.unregister(this);
            }
            if (tibrvImplQueue != null) {
                tibrvImplQueue.destroy();
            }
            if (tibrvImpl != null) {
                tibrvImpl.destroyQueueEvents(this);
            }
            Object object2 = this._lock;
            synchronized (object2) {
                this._lock.notifyAll();
            }
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    private void ungroup() {
        Vector vector = this._groups;
        if (vector != null) {
            Vector vector2 = (Vector)vector.clone();
            int n = 0;
            while (n < vector2.size()) {
                TibrvQueueGroup tibrvQueueGroup = (TibrvQueueGroup)vector2.elementAt(n);
                try {
                    tibrvQueueGroup.remove(this);
                }
                catch (TibrvException tibrvException) {
                    // empty catch block
                }
                ++n;
            }
            vector.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws TibrvException {
        if (string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this._name = string;
        Object object = this._lock;
        synchronized (object) {
            if (this._impl != null) {
                this._impl.setName(string);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            int n = this._impl.getCount();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws TibrvException {
        TibrvImplQueue tibrvImplQueue;
        if (n < 0) {
            throw new IllegalArgumentException("Negative priority");
        }
        Object object = this._lock;
        synchronized (object) {
            tibrvImplQueue = this._impl;
            this.checkValid();
        }
        tibrvImplQueue.setPriority(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            int n = this._impl.getPriority();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimitPolicy(int n, int n2, int n3) throws TibrvException {
        if (this.isDefault()) {
            throw new TibrvException(27);
        }
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid limit policy");
        }
        if (n == 0) {
            if (n3 != 0 || n2 != 0) {
                throw new IllegalArgumentException("Must specify 0 for discardAmount and maxEvents with DISCARD_NONE policy");
            }
        } else {
            if (n3 < 1) {
                throw new IllegalArgumentException("Invalid discard amount");
            }
            if (n2 < 1) {
                throw new IllegalArgumentException("Invalid maximum number of events");
            }
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            this._impl.setLimitPolicy(n, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLimitPolicy() throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            int n = this._impl.getLimitPolicy();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEvents() throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            int n = this._impl.getMaxEvents();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDiscardAmount() throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            int n = this._impl.getDiscardAmount();
            return n;
        }
    }

    public void dispatch() throws TibrvException, InterruptedException {
        TibrvImplQueue tibrvImplQueue = this._impl;
        this.checkValid();
        if (tibrvImplQueue == null) {
            throw new TibrvException(62);
        }
        tibrvImplQueue.dispatch();
    }

    public boolean timedDispatch(double d) throws TibrvException, InterruptedException {
        if (d != -1.0 && d < 0.0) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        TibrvImplQueue tibrvImplQueue = this._impl;
        this.checkValid();
        if (tibrvImplQueue != null) {
            return tibrvImplQueue.timedDispatch(d);
        }
        throw new TibrvException(62);
    }

    public boolean poll() throws TibrvException, InterruptedException {
        return this.timedDispatch(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(TibrvQueueGroup tibrvQueueGroup) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._valid) {
                return;
            }
            if (this._groups == null) {
                this._groups = new Vector();
            }
            if (!this._groups.contains(tibrvQueueGroup)) {
                this._groups.addElement(tibrvQueueGroup);
                if (this._impl instanceof TibrvImplQueueJ) {
                    TibrvImplQueueJ tibrvImplQueueJ = (TibrvImplQueueJ)this._impl;
                    if (tibrvImplQueueJ._head != null) {
                        tibrvImplQueueJ.notifyGroups();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(TibrvQueueGroup tibrvQueueGroup) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._valid) {
                return;
            }
            if (this._groups != null) {
                this._groups.removeElement(tibrvQueueGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean postEvent(TibrvImplEvtData tibrvImplEvtData, boolean bl) {
        Object object = this._lock;
        synchronized (object) {
            block4: {
                if (!this._valid || this._impl == null) break block4;
                boolean bl2 = this._impl.postEvent(tibrvImplEvtData, bl);
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
    }

    protected final void checkValid() throws TibrvException {
        if (!this._valid || this._impl == null) {
            throw new TibrvException(62);
        }
    }

    public String toString() {
        return "TibrvQueue[name=" + this._name + "]";
    }
}

