/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplTPortC;
import com.tibco.tibrv.TibrvNetTransport;

public class TibrvRvdTransport
extends TibrvNetTransport {
    public static final int DEFAULT_RVD_PORT = 7500;
    private String _service = null;
    private String _network = null;
    private String _daemon = null;
    public static final int DEFAULT_BATCH = 0;
    public static final int TIMER_BATCH = 1;

    public TibrvRvdTransport() throws TibrvException {
        this.init(null, null, null, null);
    }

    public TibrvRvdTransport(String string, String string2, String string3) throws TibrvException {
        this.init(string, string2, string3, null);
    }

    public TibrvRvdTransport(String string, String string2, String string3, String string4) throws TibrvException {
        this.init(string, string2, string3, string4);
    }

    private void init(String string, String string2, String string3, String string4) throws TibrvException {
        this._service = string;
        this._network = string2;
        this._daemon = string3;
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!Tibrv.isNativeImpl()) {
            throw new TibrvException("Native implementation required", 27);
        }
        this._impl = (TibrvImplTPortC)Tibrv.createObjectImpl("TibrvImplTPort");
        Object[] objectArray = new Object[]{string, string2, string3, "rvd", string4};
        this._impl.create(this, objectArray);
        this._valid = true;
        tibrvImpl.register(this);
    }

    public void destroy() {
        this.destroyImpl();
    }

    public String getService() {
        return this._service;
    }

    public String getNetwork() {
        return this._network;
    }

    public String getDaemon() {
        return this._daemon;
    }

    public String toString() {
        return "TibrvRvdTransport[service=" + this._service + ",network=" + this._network + ",daemon=" + this._daemon + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatchMode(int n) throws TibrvException {
        TibrvImplTPortC tibrvImplTPortC;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplTPortC = (TibrvImplTPortC)this._impl;
        }
        tibrvImplTPortC.setBatchMode(n);
    }
}

