/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.api;

import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import net.dv8tion.jda.api.sharding.ShardManager;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import tk.booky.jdahelper.api.exceptions.bot.AlreadyStartedException;
import tk.booky.jdahelper.api.exceptions.bot.NotStartedException;
import tk.booky.jdahelper.api.exceptions.bot.StartException;
import tk.booky.jdahelper.api.utils.JDAHelper;

public abstract class AbstractJDAMain {
    private ShardManager jda;

    public final void startJDA(String token, List<GatewayIntent> gatewayIntents, List<CacheFlag> cacheFlags) {
        if (this.hasStarted()) {
            throw new AlreadyStartedException();
        }
        DefaultShardManagerBuilder builder = DefaultShardManagerBuilder.create((String)token, gatewayIntents);
        builder.disableCache(Arrays.asList(CacheFlag.values()));
        builder.setMemberCachePolicy(MemberCachePolicy.ALL);
        builder.addEventListeners(new Object[]{JDAHelper.getListener()});
        builder.setEnableShutdownHook(false);
        builder.setUseShutdownNow(true);
        builder.enableCache(cacheFlags);
        builder.setAutoReconnect(true);
        try {
            this.jda = builder.build();
        }
        catch (Throwable throwable) {
            throw new StartException(throwable);
        }
    }

    public void shutdown() {
        if (this.jda == null) {
            throw new NotStartedException();
        }
        this.jda.shutdown();
    }

    public ShardManager getJDA() {
        if (!this.hasStarted()) {
            throw new NotStartedException();
        }
        return this.jda;
    }

    public boolean hasStarted() {
        return this.jda != null;
    }
}

