/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.dv8tion.jda.api.entities.Guild;
import tk.booky.jdahelper.api.IConfiguration;
import tk.booky.jdahelper.api.config.JsonConfigurationProvider;
import tk.booky.jdahelper.api.utils.JDAHelper;

public class JsonConfiguration
implements IConfiguration<JsonConfigurationProvider> {
    private final JsonObject json;

    public JsonConfiguration() {
        this(new JsonObject());
    }

    public JsonConfiguration(JsonObject json) {
        this.json = json;
    }

    @Override
    public Object get(String path, Object def) {
        return this.contains(path) ? this.json.get(path) : def;
    }

    @Override
    public String getString(String path, String def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsString() : def;
    }

    @Override
    public int getInt(String path, int def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsInt() : def;
    }

    @Override
    public double getDouble(String path, double def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsDouble() : def;
    }

    @Override
    public float getFloat(String path, float def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsFloat() : def;
    }

    @Override
    public long getLong(String path, long def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsLong() : def;
    }

    @Override
    public short getShort(String path, short def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsShort() : def;
    }

    @Override
    public byte getByte(String path, byte def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsByte() : def;
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsBoolean() : def;
    }

    @Override
    public char getCharacter(String path, char def) {
        return this.contains(path) ? this.json.getAsJsonPrimitive(path).getAsCharacter() : def;
    }

    @Override
    public List<Object> getList(String path, List<Object> def) {
        return this.contains(path) ? StreamSupport.stream(this.json.getAsJsonArray(path).spliterator(), false).collect(Collectors.toList()) : def;
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        return this.contains(path) ? StreamSupport.stream(this.json.getAsJsonArray(path).spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toList()) : def;
    }

    @Override
    public boolean contains(String path) {
        return this.json.has(path);
    }

    @Override
    public void set(String path, Object object) {
        this.remove(path);
        if (object instanceof JsonElement) {
            this.json.add(path, (JsonElement)object);
        } else if (object instanceof Number) {
            this.json.addProperty(path, (Number)object);
        } else if (object instanceof String) {
            this.json.addProperty(path, (String)object);
        } else if (object instanceof Boolean) {
            this.json.addProperty(path, (Boolean)object);
        } else if (object instanceof Character) {
            this.json.addProperty(path, (Character)object);
        } else {
            throw new IllegalArgumentException(object.toString());
        }
    }

    @Override
    public void remove(String path) {
        if (this.contains(path)) {
            this.json.remove(path);
        }
    }

    @Override
    public void save(File file) {
        JDAHelper.getConfigurationManager().getProvider(JsonConfigurationProvider.class).write(file, this);
    }

    @Override
    public void save(Guild guild) {
        this.save(JDAHelper.getConfigurationManager().getConfigurationFile(guild));
    }

    public JsonObject getJson() {
        return this.json;
    }
}

