/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import tk.booky.jdahelper.api.IConfiguration;
import tk.booky.jdahelper.api.config.JsonConfiguration;
import tk.booky.jdahelper.api.exceptions.config.ConfigReadException;
import tk.booky.jdahelper.api.exceptions.config.ConfigWriteException;
import tk.booky.jdahelper.api.exceptions.config.WrongImplementationException;
import tk.booky.jdahelper.api.provider.IConfigurationProvider;
import tk.booky.jdahelper.api.utils.JDAHelper;

public class JsonConfigurationProvider
implements IConfigurationProvider {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public IConfiguration<JsonConfigurationProvider> read(File file) {
        JsonConfiguration jsonConfiguration;
        FileReader reader = new FileReader(file);
        try {
            jsonConfiguration = new JsonConfiguration((JsonObject)gson.fromJson((Reader)reader, JsonObject.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new ConfigReadException(throwable3);
            }
        }
        reader.close();
        return jsonConfiguration;
    }

    @Override
    public <T extends IConfigurationProvider> void write(File file, IConfiguration<T> configuration) {
        block8: {
            if (configuration instanceof JsonConfiguration) {
                try (FileWriter writer = new FileWriter(file);){
                    gson.toJson((JsonElement)((JsonConfiguration)configuration).getJson(), (Appendable)writer);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw new ConfigWriteException(throwable);
                }
            }
            throw new WrongImplementationException();
        }
    }

    @Override
    public void writeDefault(File file) {
        JsonConfiguration configuration = new JsonConfiguration();
        configuration.set("language", JDAHelper.getLanguageManager().getDefaultLanguageProvider().getLanguageID());
        configuration.set("prefix", "!");
        this.write(file, configuration);
    }
}

