/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.api.utils;

import java.awt.Color;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.StoreChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.utils.MiscUtil;
import org.jetbrains.annotations.Nullable;
import tk.booky.jdahelper.api.exceptions.api.ImplementationNotFoundException;
import tk.booky.jdahelper.api.manager.ICommandManager;
import tk.booky.jdahelper.api.manager.IConfigurationManager;
import tk.booky.jdahelper.api.manager.IEventManager;
import tk.booky.jdahelper.api.manager.IImplementationManager;
import tk.booky.jdahelper.api.manager.ILanguageManager;
import tk.booky.jdahelper.api.utils.Pair;

public class JDAHelper {
    private static final IImplementationManager manager;

    public static ListenerAdapter getListener() {
        return manager.getListener();
    }

    public static ICommandManager getCommandManager() {
        return manager.getCommandManager();
    }

    public static ILanguageManager getLanguageManager() {
        return manager.getLanguageManager();
    }

    public static IEventManager getEventManager() {
        return manager.getEventManager();
    }

    public static IConfigurationManager getConfigurationManager() {
        return manager.getConfigurationManager();
    }

    public static IImplementationManager getImplementationManager() {
        return manager;
    }

    @SafeVarargs
    public static Message sendEmbed(MessageChannel channel, String title, String body, Pair<String, String> ... fields) {
        return JDAHelper.sendEmbed(channel, new Color((int)(Math.random() * 1.6777216E7)), title, body, (Boolean)true, fields);
    }

    public static Message sendEmbed(MessageChannel channel, String title, String body, List<Pair<String, String>> fields) {
        return JDAHelper.sendEmbed(channel, new Color((int)(Math.random() * 1.6777216E7)), title, body, (Boolean)true, fields);
    }

    @SafeVarargs
    public static Message sendEmbed(MessageChannel channel, Color color, String title, String body, Pair<String, String> ... fields) {
        return JDAHelper.sendEmbed(channel, color, title, body, (Boolean)true, fields);
    }

    public static Message sendEmbed(MessageChannel channel, Color color, String title, String body, List<Pair<String, String>> fields) {
        return JDAHelper.sendEmbed(channel, color, title, body, (Boolean)true, fields);
    }

    @SafeVarargs
    public static Message sendEmbed(MessageChannel channel, Color color, String title, String body, Boolean inLine, Pair<String, String> ... fields) {
        return JDAHelper.sendEmbed(channel, color, title, body, inLine, Arrays.asList(fields));
    }

    public static Message sendEmbed(MessageChannel channel, Color color, String title, String body, Boolean inLine, List<Pair<String, String>> fields) {
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle(title);
        builder.setDescription((CharSequence)body);
        builder.setColor(color.getRGB());
        builder.setTimestamp((TemporalAccessor)new Date(System.currentTimeMillis()).toInstant());
        fields.forEach(field -> builder.addField((String)field.getKey(), (String)field.getValue(), inLine.booleanValue()));
        if (channel.getType().isGuild()) {
            Guild guild = ((GuildChannel)channel).getGuild();
            builder.setFooter(guild.getName(), guild.getIconUrl());
        } else if (channel.getType().equals((Object)ChannelType.PRIVATE)) {
            User user = ((PrivateChannel)channel).getUser();
            builder.setFooter(user.getAsTag(), user.getEffectiveAvatarUrl());
        } else {
            builder.setFooter(channel.getName());
        }
        return (Message)channel.sendMessage(builder.build()).complete();
    }

    public static boolean isValidSnowflake(String input) {
        try {
            MiscUtil.parseSnowflake((String)input);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    @Nullable
    public static TextChannel getTextChannel(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getTextChannelById(input);
    }

    @Nullable
    public static VoiceChannel getVoiceChannel(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getVoiceChannelById(input);
    }

    @Nullable
    public static Role getRole(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getRoleById(input);
    }

    @Nullable
    public static Emote getEmote(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getEmoteById(input);
    }

    @Nullable
    public static Member getMember(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getMemberById(input);
    }

    @Nullable
    public static Category getCategory(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getCategoryById(input);
    }

    @Nullable
    public static GuildChannel getGuildChannel(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getGuildChannelById(input);
    }

    @Nullable
    public static StoreChannel getBan(Guild guild, String input) {
        if (!JDAHelper.isValidSnowflake(input = JDAHelper.replaceID(input))) {
            return null;
        }
        return guild.getStoreChannelById(input);
    }

    public static String replaceID(String input) {
        return input.replaceAll("\\D+", "");
    }

    public static String escapeMarkdown(String input) {
        return input.replaceAll("([_`~*>])", "\\\\$1");
    }

    static {
        try {
            manager = (IImplementationManager)Class.forName("tk.booky.jdahelper.internal.manager.ImplementationManager").newInstance();
        }
        catch (Throwable throwable) {
            throw new ImplementationNotFoundException(throwable);
        }
    }
}

