/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.internal.manager;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import org.jetbrains.annotations.Nullable;
import tk.booky.jdahelper.api.IConfiguration;
import tk.booky.jdahelper.api.commands.Command;
import tk.booky.jdahelper.api.commands.IHelpTranslation;
import tk.booky.jdahelper.api.exceptions.api.CommandException;
import tk.booky.jdahelper.api.manager.ICommandManager;
import tk.booky.jdahelper.api.utils.JDAHelper;
import tk.booky.jdahelper.api.utils.Pair;
import tk.booky.jdahelper.internal.fallback.FallbackHelpTranslation;

public class CommandManager
implements ICommandManager {
    private static final HashMap<String, Command> commands = new HashMap();
    private static final HashMap<String, String> alias = new HashMap();

    private static String trimCommand(String command) {
        return command.trim().toLowerCase().replace(' ', '_');
    }

    @Override
    public void executeCommand(Message message, String command, String[] args) {
        String trimmedCommand = CommandManager.trimCommand(command);
        new Thread(() -> {
            try {
                if (message.getChannelType().equals((Object)ChannelType.TEXT)) {
                    TextChannel channel = (TextChannel)message.getChannel();
                    if (trimmedCommand.equals(CommandManager.trimCommand(JDAHelper.getLanguageManager().getLanguageProvider(channel.getGuild()).getHelpTranslation().getHelpCommand()))) {
                        this.sendHelpMessage((MessageChannel)channel, null);
                    } else {
                        Command commandObject = this.resolveCommand(trimmedCommand);
                        if (commandObject != null && Objects.requireNonNull(message.getGuild().getMemberById(message.getAuthor().getId())).hasPermission(commandObject.getPermissions())) {
                            commandObject.execute(channel, message, channel.getGuild().getMember(message.getAuthor()), command, args);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                new CommandException(throwable).printStackTrace();
            }
        }, "Command Executor [" + command + "] (" + message.getAuthor().getAsTag() + ")").start();
    }

    @Override
    public void registerCommand(Command command) {
        String trimmedCommand = CommandManager.trimCommand(command.getCommand());
        commands.put(trimmedCommand, command);
        command.getAlias().forEach(alias -> CommandManager.alias.put(CommandManager.trimCommand(alias), trimmedCommand));
    }

    @Override
    public void unregisterCommand(Command command) {
        String trimmedCommand = CommandManager.trimCommand(command.getCommand());
        commands.remove(trimmedCommand);
        CommandManager.alias.forEach((alias, originalCommand) -> {
            if (!originalCommand.equals(trimmedCommand)) {
                return;
            }
            CommandManager.alias.remove(alias);
        });
    }

    @Override
    public Message sendHelpMessage(MessageChannel channel, @Nullable String command) {
        String body;
        FallbackHelpTranslation helpTranslation;
        GuildChannel guildChannel = channel.getType().isGuild() ? (GuildChannel)channel : null;
        IHelpTranslation iHelpTranslation = helpTranslation = channel.getType().isGuild() ? JDAHelper.getLanguageManager().getLanguageProvider(((GuildChannel)channel).getGuild()).getHelpTranslation() : new FallbackHelpTranslation(){};
        if (command == null) {
            body = this.getRegisteredCommands().entrySet().stream().map(entry -> String.format(helpTranslation.getEntryFormat(), this.getPrefix(guildChannel == null ? null : guildChannel.getGuild()), entry.getKey(), ((Command)entry.getValue()).getUsage())).collect(Collectors.joining("\n"));
        } else {
            command = CommandManager.trimCommand(command);
            Command resolved = this.resolveCommand(command);
            body = String.format(helpTranslation.getEntryFormat(), this.getPrefix(guildChannel == null ? null : guildChannel.getGuild()), command, resolved.getUsage());
        }
        return JDAHelper.sendEmbed(channel, Color.YELLOW, helpTranslation.getMessageTitle(), body, new Pair[0]);
    }

    @Override
    public Map<String, Command> getRegisteredCommands() {
        return Collections.unmodifiableMap(commands);
    }

    @Override
    public Map<String, String> getAliases() {
        return Collections.unmodifiableMap(alias);
    }

    @Override
    public Command resolveCommand(String command) {
        String alias = CommandManager.alias.get(command = CommandManager.trimCommand(command));
        return commands.get(alias == null ? command : alias);
    }

    @Override
    public String getPrefix(Guild guild) {
        return guild == null ? "!" : JDAHelper.getConfigurationManager().getConfiguration(guild).getString("prefix", "!");
    }

    @Override
    public void setPrefix(Guild guild, String prefix) {
        IConfiguration<?> configuration = JDAHelper.getConfigurationManager().getConfiguration(guild);
        configuration.set("prefix", prefix.trim());
        configuration.save(guild);
    }

    @Override
    public boolean existsCommand(String command) {
        return commands.containsKey(command = CommandManager.trimCommand(command)) || alias.containsKey(command);
    }
}

