/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.internal.manager;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.events.Event;
import tk.booky.jdahelper.api.event.HandleEvent;
import tk.booky.jdahelper.api.event.IListener;
import tk.booky.jdahelper.api.exceptions.events.EventException;
import tk.booky.jdahelper.api.exceptions.events.ListenerRegisterException;
import tk.booky.jdahelper.api.manager.IEventManager;
import tk.booky.jdahelper.internal.events.PriorityComparator;

public final class EventManager
implements IEventManager {
    private final HashMap<Method, Class<? extends Event>> registeredHandlers = new HashMap();
    private final HashMap<Method, IListener> listenerInstances = new HashMap();

    @Override
    public void callEvent(Event event) {
        new Thread(() -> this.registeredHandlers.entrySet().stream().filter(entry -> ((Class)entry.getValue()).isAssignableFrom(event.getClass())).map(Map.Entry::getKey).sorted(new PriorityComparator()).forEach(method -> this.invokeEventMethod((Method)method, event)), "Event Executor [" + event.getClass().getSimpleName() + "] " + event.hashCode()).start();
    }

    private void invokeEventMethod(Method method, Event event) {
        try {
            method.invoke((Object)this.listenerInstances.get(method), event);
        }
        catch (Throwable throwable) {
            new EventException(throwable).printStackTrace();
        }
    }

    @Override
    public void registerListener(IListener listener) {
        Arrays.stream(listener.getClass().getDeclaredMethods()).forEach(method -> {
            if (Arrays.stream(method.getDeclaredAnnotations()).noneMatch(annotation -> annotation instanceof HandleEvent)) {
                return;
            }
            if (method.getParameterCount() != 1) {
                return;
            }
            try {
                method.setAccessible(true);
                this.registeredHandlers.put((Method)method, (Class<? extends Event>)method.getParameterTypes()[0]);
                this.listenerInstances.put((Method)method, listener);
            }
            catch (Throwable throwable) {
                throw new ListenerRegisterException(throwable);
            }
        });
    }

    public final void unregisterListener(IListener listener) {
        this.unregisterListener(listener.getClass());
    }

    public final void unregisterListener(Class<? extends IListener> clazz) {
        this.registeredHandlers.keySet().stream().filter(method -> method.getDeclaringClass().equals(clazz)).forEach(this.registeredHandlers::remove);
    }
}

