/*
 * Decompiled with CFR 0.152.
 */
package tk.booky.jdahelper.internal.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import tk.booky.jdahelper.api.IConfiguration;
import tk.booky.jdahelper.api.manager.ILanguageManager;
import tk.booky.jdahelper.api.provider.ILanguageProvider;
import tk.booky.jdahelper.api.utils.JDAHelper;
import tk.booky.jdahelper.internal.fallback.FallbackLanguageProvider;

public class LanguageManager
implements ILanguageManager {
    private final HashMap<String, ILanguageProvider> languages = new HashMap();
    private static final FallbackLanguageProvider FALLBACK_LANGUAGE_PROVIDER = new FallbackLanguageProvider();

    public LanguageManager() {
        this.languages.put(FALLBACK_LANGUAGE_PROVIDER.getLanguageID(), FALLBACK_LANGUAGE_PROVIDER);
    }

    @Override
    public ILanguageProvider getLanguageProvider(String language, ILanguageProvider def) {
        return this.languages.getOrDefault(language.toLowerCase(), def);
    }

    @Override
    public ILanguageProvider registerLanguageProvider(ILanguageProvider provider) {
        return this.languages.put(provider.getLanguageID().toLowerCase(), provider);
    }

    @Override
    public ILanguageProvider removeLanguageProvider(String language) {
        return this.languages.remove(language.toLowerCase());
    }

    @Override
    public List<ILanguageProvider> getLanguageProviders() {
        return Collections.unmodifiableList(new ArrayList<ILanguageProvider>(this.languages.values()));
    }

    @Override
    public void clearLanguageProviders() {
        this.languages.clear();
    }

    @Override
    public ILanguageProvider getDefaultLanguageProvider() {
        return this.getLanguageProviders().stream().filter(ILanguageProvider::isDefault).findAny().orElse(FALLBACK_LANGUAGE_PROVIDER);
    }

    @Override
    public boolean existsLanguage(String language) {
        return this.languages.containsKey(language.toLowerCase());
    }

    @Override
    public String getLanguage(Guild guild) {
        IConfiguration<?> configuration = JDAHelper.getConfigurationManager().getConfiguration(guild);
        ILanguageProvider defaultLanguageProvider = this.getDefaultLanguageProvider();
        return configuration.getString("language", defaultLanguageProvider.getLanguageID());
    }

    @Override
    public ILanguageProvider getLanguageProvider(Guild guild) {
        String language = this.getLanguage(guild);
        return language == null || !this.existsLanguage(language) ? null : this.getLanguageProvider(language);
    }
}

