/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.annotation.LogicDelete;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.entity.IDynamicTableName;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;

public abstract class OGNL {
    public static final String SAFE_DELETE_ERROR = "\u901a\u7528 Mapper \u5b89\u5168\u68c0\u67e5: \u5bf9\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u8fdb\u884c\u68c0\u67e5\u65f6\u51fa\u9519!";
    public static final String SAFE_DELETE_EXCEPTION = "\u901a\u7528 Mapper \u5b89\u5168\u68c0\u67e5: \u5f53\u524d\u64cd\u4f5c\u7684\u65b9\u6cd5\u6ca1\u6709\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c!";

    public static boolean checkExampleEntityClass(Object parameter, String entityFullName) {
        Example example;
        Class<?> entityClass;
        if (parameter != null && parameter instanceof Example && StringUtil.isNotEmpty(entityFullName) && !(entityClass = (example = (Example)parameter).getEntityClass()).getCanonicalName().equals(entityFullName)) {
            throw new MapperException("\u5f53\u524d Example \u65b9\u6cd5\u5bf9\u5e94\u5b9e\u4f53\u4e3a:" + entityFullName + ", \u4f46\u662f\u53c2\u6570 Example \u4e2d\u7684 entityClass \u4e3a:" + entityClass.getCanonicalName());
        }
        return true;
    }

    public static boolean notAllNullParameterCheck(Object parameter, String fields) {
        if (parameter != null) {
            try {
                Set<EntityColumn> columns = EntityHelper.getColumns(parameter.getClass());
                HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields.split(",")));
                for (EntityColumn column : columns) {
                    Object value;
                    if (!fieldSet.contains(column.getProperty()) || (value = column.getEntityField().getValue(parameter)) == null) continue;
                    return true;
                }
            }
            catch (Exception e) {
                throw new MapperException(SAFE_DELETE_ERROR, e);
            }
        }
        throw new MapperException(SAFE_DELETE_EXCEPTION);
    }

    public static boolean notEmptyCollectionCheck(Object parameter, String error) {
        if (parameter == null || parameter instanceof Collection && ((Collection)parameter).size() == 0) {
            throw new IllegalArgumentException(error);
        }
        return true;
    }

    public static boolean exampleHasAtLeastOneCriteriaCheck(Object parameter) {
        if (parameter != null) {
            try {
                Method getter;
                Object list;
                List<Example.Criteria> criteriaList;
                if (parameter instanceof Example ? (criteriaList = ((Example)parameter).getOredCriteria()) != null && criteriaList.size() > 0 : (list = (getter = parameter.getClass().getDeclaredMethod("getOredCriteria", new Class[0])).invoke(parameter, new Object[0])) != null && list instanceof List && ((List)list).size() > 0) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new MapperException(SAFE_DELETE_ERROR, e);
            }
        }
        throw new MapperException(SAFE_DELETE_EXCEPTION);
    }

    public static boolean hasSelectColumns(Object parameter) {
        Example example;
        return parameter != null && parameter instanceof Example && (example = (Example)parameter).getSelectColumns() != null && example.getSelectColumns().size() > 0;
    }

    public static boolean hasCountColumn(Object parameter) {
        if (parameter != null && parameter instanceof Example) {
            Example example = (Example)parameter;
            return StringUtil.isNotEmpty(example.getCountColumn());
        }
        return false;
    }

    public static boolean hasForUpdate(Object parameter) {
        if (parameter != null && parameter instanceof Example) {
            Example example = (Example)parameter;
            return example.isForUpdate();
        }
        return false;
    }

    public static boolean hasNoSelectColumns(Object parameter) {
        return !OGNL.hasSelectColumns(parameter);
    }

    public static boolean isDynamicParameter(Object parameter) {
        return parameter != null && parameter instanceof IDynamicTableName;
    }

    public static boolean isNotDynamicParameter(Object parameter) {
        return !OGNL.isDynamicParameter(parameter);
    }

    public static String andOr(Object parameter) {
        if (parameter instanceof Example.Criteria) {
            return ((Example.Criteria)parameter).getAndOr();
        }
        if (parameter instanceof Example.Criterion) {
            return ((Example.Criterion)parameter).getAndOr();
        }
        if (parameter.getClass().getCanonicalName().endsWith("Criteria")) {
            return "or";
        }
        return "and";
    }

    public static String andNotLogicDelete(Object parameter) {
        String result = "";
        if (parameter instanceof Example) {
            Example example = (Example)parameter;
            Map<String, EntityColumn> propertyMap = example.getPropertyMap();
            for (Map.Entry<String, EntityColumn> entry : propertyMap.entrySet()) {
                EntityColumn column = entry.getValue();
                if (!column.getEntityField().isAnnotationPresent(LogicDelete.class)) continue;
                result = "and " + column.getColumn() + " = " + SqlHelper.getLogicDeletedValue(column, false);
            }
        }
        return result;
    }
}

