/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityField;

public class FieldHelper {
    private static final IFieldHelper fieldHelper = new Jdk8FieldHelper();

    public static List<EntityField> getFields(Class<?> entityClass) {
        return fieldHelper.getFields(entityClass);
    }

    public static List<EntityField> getProperties(Class<?> entityClass) {
        return fieldHelper.getProperties(entityClass);
    }

    public static List<EntityField> getAll(Class<?> entityClass) {
        List<EntityField> fields = fieldHelper.getFields(entityClass);
        List<EntityField> properties = fieldHelper.getProperties(entityClass);
        ArrayList<EntityField> all = new ArrayList<EntityField>();
        HashSet<EntityField> usedSet = new HashSet<EntityField>();
        for (EntityField field : fields) {
            for (EntityField property : properties) {
                if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                field.copyFromPropertyDescriptor(property);
                usedSet.add(property);
                break;
            }
            all.add(field);
        }
        for (EntityField property : properties) {
            if (usedSet.contains(property)) continue;
            all.add(property);
        }
        return all;
    }

    private static boolean containFiled(List<EntityField> fieldList, String filedName) {
        for (EntityField field : fieldList) {
            if (!field.getName().equals(filedName)) continue;
            return true;
        }
        return false;
    }

    static class Jdk8FieldHelper
    implements IFieldHelper {
        Jdk8FieldHelper() {
        }

        @Override
        public List<EntityField> getFields(Class<?> entityClass) {
            List<EntityField> fields = this._getFields(entityClass, null, null);
            fields = new ArrayList<EntityField>(new LinkedHashSet<EntityField>(fields));
            List<EntityField> properties = this.getProperties(entityClass);
            HashSet usedSet = new HashSet();
            block0: for (EntityField field : fields) {
                for (EntityField property : properties) {
                    if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                    field.setJavaType(property.getJavaType());
                    continue block0;
                }
            }
            return fields;
        }

        private List<EntityField> _getFields(Class<?> entityClass, List<EntityField> fieldList, Integer level) {
            if (fieldList == null) {
                fieldList = new ArrayList<EntityField>();
            }
            if (level == null) {
                level = 0;
            }
            if (entityClass.equals(Object.class)) {
                return fieldList;
            }
            Field[] fields = entityClass.getDeclaredFields();
            Arrays.sort(fields, Comparator.comparing(Field::getName));
            int index = 0;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || FieldHelper.containFiled(fieldList, field.getName())) continue;
                if (level != 0) {
                    fieldList.add(index, new EntityField(field, null));
                    ++index;
                    continue;
                }
                fieldList.add(new EntityField(field, null));
            }
            Class<?> superClass = entityClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
                level = level + 1;
                return this._getFields(entityClass.getSuperclass(), fieldList, level);
            }
            return fieldList;
        }

        @Override
        public List<EntityField> getProperties(Class<?> entityClass) {
            PropertyDescriptor[] descriptors;
            ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(entityClass);
            }
            catch (IntrospectionException e) {
                throw new MapperException(e);
            }
            for (PropertyDescriptor desc : descriptors = beanInfo.getPropertyDescriptors()) {
                if ("class".equals(desc.getName())) continue;
                entityFields.add(new EntityField(null, desc));
            }
            return entityFields;
        }
    }

    static interface IFieldHelper {
        public List<EntityField> getFields(Class<?> var1);

        public List<EntityField> getProperties(Class<?> var1);
    }
}

