/**
 * Copyright 2019 Pratanu Mandal
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package tk.pratanumandal.expr4j.common;

/**
 * The <code>Expr4jConstants</code> class provides all the application wide constants.
 * 
 * @author Pratanu Mandal
 * @since 0.0.2
 *
 */
public final class Expr4jConstants {
	
	/**
	 * Utility classes should not have public constructors.
	 */
	private Expr4jConstants() {}

	/**
	 * The maximum number of decimal places supported.<br>
	 * Currently this value is set to 10.
	 */
	public static final int PRECISION = 10;
	
	/**
	 * Use variable number of parameters for function.<br>
	 * Constant value of -1.
	 */
	public static final int VARIABLE_PARAMETERS = -1;
	
}
