/*
 * Decompiled with CFR 0.152.
 */
package carbon;

import android.animation.AnimatorInflater;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Menu;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.TintAwareDrawable;
import carbon.R;
import carbon.animation.AnimUtils;
import carbon.animation.AnimatedColorStateList;
import carbon.animation.AnimatedView;
import carbon.drawable.AlphaDrawable;
import carbon.drawable.AlphaWithParentDrawable;
import carbon.drawable.ColorStateListDrawable;
import carbon.drawable.ColorStateListFactory;
import carbon.drawable.VectorDrawable;
import carbon.drawable.ripple.RippleDrawable;
import carbon.drawable.ripple.RippleView;
import carbon.internal.ResourcesCompat;
import carbon.view.AutoSizeTextView;
import carbon.view.InsetView;
import carbon.view.MaxSizeView;
import carbon.view.ShadowView;
import carbon.view.ShapeModelView;
import carbon.view.StateAnimatorView;
import carbon.view.StrokeView;
import carbon.view.TextAppearanceView;
import carbon.view.TintedView;
import carbon.view.TouchMarginView;
import carbon.widget.AutoSizeTextMode;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Carbon {
    private static final long DEFAULT_REVEAL_DURATION = 200L;
    private static long defaultRevealDuration = 200L;
    public static final boolean IS_LOLLIPOP_OR_HIGHER = Build.VERSION.SDK_INT >= 21;
    public static final boolean IS_PIE_OR_HIGHER = Build.VERSION.SDK_INT >= 28;
    public static PorterDuffXfermode CLEAR_MODE = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    public static final int INVALID_INDEX = -1;

    private Carbon() {
    }

    public static float getDip(Context context) {
        return TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float getSp(Context context) {
        return TypedValue.applyDimension((int)2, (float)1.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static ColorStateList getDefaultColorStateList(View view, TypedArray a, int id2) {
        if (!a.hasValue(id2)) {
            return null;
        }
        try {
            if (a.getColor(id2, 0) != view.getResources().getColor(R.color.carbon_defaultColorControl)) {
                return null;
            }
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        Context context = view.getContext();
        int resourceId = a.getResourceId(id2, 0);
        if (resourceId == R.color.carbon_defaultColorPrimary) {
            return ColorStateListFactory.INSTANCE.makePrimary(context);
        }
        if (resourceId == R.color.carbon_defaultColorPrimaryInverse) {
            return ColorStateListFactory.INSTANCE.makePrimaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultColorSecondary) {
            return ColorStateListFactory.INSTANCE.makeSecondary(context);
        }
        if (resourceId == R.color.carbon_defaultColorSecondaryInverse) {
            return ColorStateListFactory.INSTANCE.makeSecondaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultColorControl) {
            return ColorStateListFactory.INSTANCE.makeControl(context);
        }
        if (resourceId == R.color.carbon_defaultColorControlInverse) {
            return ColorStateListFactory.INSTANCE.makeControlInverse(context);
        }
        if (resourceId == R.color.carbon_defaultColorControlPrimary) {
            return ColorStateListFactory.INSTANCE.makeControlPrimary(context);
        }
        if (resourceId == R.color.carbon_defaultColorControlPrimaryInverse) {
            return ColorStateListFactory.INSTANCE.makeControlPrimaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultColorControlSecondary) {
            return ColorStateListFactory.INSTANCE.makeControlSecondary(context);
        }
        if (resourceId == R.color.carbon_defaultColorControlSecondaryInverse) {
            return ColorStateListFactory.INSTANCE.makeControlSecondaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultHighlightColor) {
            return ColorStateListFactory.INSTANCE.makeHighlight(context);
        }
        if (resourceId == R.color.carbon_defaultHighlightColorSecondary) {
            return ColorStateListFactory.INSTANCE.makeHighlightSecondary(context);
        }
        if (resourceId == R.color.carbon_defaultHighlightColorPrimary) {
            return ColorStateListFactory.INSTANCE.makeHighlightPrimary(context);
        }
        if (resourceId == R.color.carbon_defaultIconColor) {
            return ColorStateListFactory.INSTANCE.makeIcon(context);
        }
        if (resourceId == R.color.carbon_defaultIconColorInverse) {
            return ColorStateListFactory.INSTANCE.makeIconInverse(context);
        }
        if (resourceId == R.color.carbon_defaultIconColorSecondary) {
            return ColorStateListFactory.INSTANCE.makeIconSecondary(context);
        }
        if (resourceId == R.color.carbon_defaultIconColorSecondaryInverse) {
            return ColorStateListFactory.INSTANCE.makeIconSecondaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultIconColorPrimary) {
            return ColorStateListFactory.INSTANCE.makeIconPrimary(context);
        }
        if (resourceId == R.color.carbon_defaultIconColorPrimaryInverse) {
            return ColorStateListFactory.INSTANCE.makeIconPrimaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultTextPrimaryColor) {
            return ColorStateListFactory.INSTANCE.makePrimaryText(context);
        }
        if (resourceId == R.color.carbon_defaultTextSecondaryColor) {
            return ColorStateListFactory.INSTANCE.makeSecondaryText(context);
        }
        if (resourceId == R.color.carbon_defaultTextPrimaryColorInverse) {
            return ColorStateListFactory.INSTANCE.makePrimaryTextInverse(context);
        }
        if (resourceId == R.color.carbon_defaultTextSecondaryColorInverse) {
            return ColorStateListFactory.INSTANCE.makeSecondaryTextInverse(context);
        }
        if (resourceId == R.color.carbon_defaultTextColorPrimary) {
            return ColorStateListFactory.INSTANCE.makeTextPrimary(context);
        }
        if (resourceId == R.color.carbon_defaultTextColorPrimaryInverse) {
            return ColorStateListFactory.INSTANCE.makeTextPrimaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultTextColorSecondary) {
            return ColorStateListFactory.INSTANCE.makeTextSecondary(context);
        }
        if (resourceId == R.color.carbon_defaultTextColorSecondaryInverse) {
            return ColorStateListFactory.INSTANCE.makeTextSecondaryInverse(context);
        }
        if (resourceId == R.color.carbon_defaultRippleColorPrimary) {
            int c = Carbon.getThemeColor(context, R.attr.colorPrimary);
            return ColorStateList.valueOf((int)(0x12000000 | c & 0xFFFFFF));
        }
        if (resourceId == R.color.carbon_defaultRippleColorSecondary) {
            int c = Carbon.getThemeColor(context, R.attr.colorSecondary);
            return ColorStateList.valueOf((int)(0x12000000 | c & 0xFFFFFF));
        }
        return null;
    }

    public static ColorStateList getColorStateList(View view, TypedArray a, int id2) {
        ColorStateList color2 = Carbon.getDefaultColorStateList(view, a, id2);
        if (color2 == null) {
            color2 = a.getColorStateList(id2);
        }
        return color2;
    }

    public static Drawable getDefaultColorDrawable(View view, TypedArray a, int id2) {
        ColorStateList color2 = Carbon.getDefaultColorStateList(view, a, id2);
        if (color2 != null) {
            ColorStateListDrawable d = new ColorStateListDrawable(AnimatedColorStateList.fromList(color2, animation -> view.postInvalidate()));
            if (color2 instanceof AlphaWithParentDrawable.AlphaWithParentColorStateList) {
                return new AlphaWithParentDrawable(view, d);
            }
            return d;
        }
        Context context = view.getContext();
        int resourceId = a.getResourceId(id2, 0);
        if (resourceId == R.color.carbon_defaultMenuSelectionDrawable) {
            return ColorStateListFactory.INSTANCE.makeMenuSelection(context);
        }
        if (resourceId == R.color.carbon_defaultMenuSelectionDrawablePrimary) {
            return ColorStateListFactory.INSTANCE.makeMenuSelectionPrimary(context);
        }
        if (resourceId == R.color.carbon_defaultMenuSelectionDrawableSecondary) {
            return ColorStateListFactory.INSTANCE.makeMenuSelectionSecondary(context);
        }
        return null;
    }

    public static void initDefaultBackground(View view, TypedArray a, int id2) {
        Drawable d = Carbon.getDefaultColorDrawable(view, a, id2);
        if (d != null) {
            view.setBackgroundDrawable(d);
        }
    }

    public static void initDefaultTextColor(TextAppearanceView view, TypedArray a, int id2) {
        ColorStateList color2 = Carbon.getDefaultColorStateList((View)view, a, id2);
        if (color2 != null) {
            view.setTextColor(color2);
        }
    }

    public static void initRippleDrawable(RippleView rippleView, TypedArray a, int[] ids) {
        int carbon_rippleColor = ids[0];
        int carbon_rippleStyle = ids[1];
        int carbon_rippleHotspot = ids[2];
        int carbon_rippleRadius = ids[3];
        View view = (View)rippleView;
        if (view.isInEditMode()) {
            return;
        }
        ColorStateList color2 = Carbon.getColorStateList(view, a, carbon_rippleColor);
        if (color2 != null) {
            RippleDrawable.Style style2 = RippleDrawable.Style.values()[a.getInt(carbon_rippleStyle, RippleDrawable.Style.Background.ordinal())];
            boolean useHotspot = a.getBoolean(carbon_rippleHotspot, true);
            int radius = (int)a.getDimension(carbon_rippleRadius, -1.0f);
            rippleView.setRippleDrawable(RippleDrawable.create(color2, style2, view, useHotspot, radius));
        }
    }

    public static void initTouchMargin(TouchMarginView view, TypedArray a, int[] ids) {
        int carbon_touchMargin = ids[0];
        int carbon_touchMarginLeft = ids[1];
        int carbon_touchMarginTop = ids[2];
        int carbon_touchMarginRight = ids[3];
        int carbon_touchMarginBottom = ids[4];
        int touchMarginAll = (int)a.getDimension(carbon_touchMargin, 0.0f);
        int left = (int)a.getDimension(carbon_touchMarginLeft, (float)touchMarginAll);
        int top = (int)a.getDimension(carbon_touchMarginTop, (float)touchMarginAll);
        int right = (int)a.getDimension(carbon_touchMarginRight, (float)touchMarginAll);
        int bottom = (int)a.getDimension(carbon_touchMarginBottom, (float)touchMarginAll);
        view.setTouchMargin(left, top, right, bottom);
    }

    public static void initInset(InsetView view, TypedArray a, int[] ids) {
        int carbon_inset = ids[0];
        int carbon_insetLeft = ids[1];
        int carbon_insetTop = ids[2];
        int carbon_insetRight = ids[3];
        int carbon_insetBottom = ids[4];
        int carbon_insetColor = ids[5];
        int insetAll = (int)a.getDimension(carbon_inset, -1.0f);
        int left = (int)a.getDimension(carbon_insetLeft, (float)insetAll);
        int top = (int)a.getDimension(carbon_insetTop, (float)insetAll);
        int right = (int)a.getDimension(carbon_insetRight, (float)insetAll);
        int bottom = (int)a.getDimension(carbon_insetBottom, (float)insetAll);
        view.setInset(left, top, right, bottom);
        view.setInsetColor(a.getColor(carbon_insetColor, 0));
    }

    public static void initMaxSize(MaxSizeView view, TypedArray a, int[] ids) {
        int carbon_maxWidth = ids[0];
        int carbon_maxHeight = ids[1];
        int width = (int)a.getDimension(carbon_maxWidth, 2.1474836E9f);
        int height = (int)a.getDimension(carbon_maxHeight, 2.1474836E9f);
        view.setMaxWidth(width);
        view.setMaxHeight(height);
    }

    public static void initTint(TintedView view, TypedArray a, int[] ids) {
        ColorStateList color2;
        int carbon_tint = ids[0];
        int carbon_tintMode = ids[1];
        int carbon_backgroundTint = ids[2];
        int carbon_backgroundTintMode = ids[3];
        int carbon_animateColorChanges = ids[4];
        if (a.hasValue(carbon_tint)) {
            color2 = Carbon.getDefaultColorStateList((View)view, a, carbon_tint);
            if (color2 == null) {
                color2 = a.getColorStateList(carbon_tint);
            }
            if (color2 != null) {
                view.setTintList(color2);
            }
        }
        view.setTintMode(TintedView.modes[a.getInt(carbon_tintMode, 1)]);
        if (a.hasValue(carbon_backgroundTint)) {
            color2 = Carbon.getDefaultColorStateList((View)view, a, carbon_backgroundTint);
            if (color2 == null) {
                color2 = a.getColorStateList(carbon_backgroundTint);
            }
            if (color2 != null) {
                view.setBackgroundTintList(color2);
            }
        }
        view.setBackgroundTintMode(TintedView.modes[a.getInt(carbon_backgroundTintMode, 1)]);
        if (a.hasValue(carbon_animateColorChanges)) {
            view.setAnimateColorChangesEnabled(a.getBoolean(carbon_animateColorChanges, false));
        }
    }

    public static void initAnimations(AnimatedView view, TypedArray a, int[] ids) {
        int carbon_outAnimation;
        if (((View)view).isInEditMode()) {
            return;
        }
        int carbon_inAnimation = ids[0];
        if (a.hasValue(carbon_inAnimation)) {
            TypedValue typedValue = new TypedValue();
            a.getValue(carbon_inAnimation, typedValue);
            if (typedValue.resourceId != 0) {
                view.setInAnimator(AnimatorInflater.loadAnimator((Context)((View)view).getContext(), (int)typedValue.resourceId));
            } else {
                view.setInAnimator(AnimUtils.Style.values()[typedValue.data].getInAnimator());
            }
        }
        if (a.hasValue(carbon_outAnimation = ids[1])) {
            TypedValue typedValue = new TypedValue();
            a.getValue(carbon_outAnimation, typedValue);
            if (typedValue.resourceId != 0) {
                view.setOutAnimator(AnimatorInflater.loadAnimator((Context)((View)view).getContext(), (int)typedValue.resourceId));
            } else {
                view.setOutAnimator(AnimUtils.Style.values()[typedValue.data].getOutAnimator());
            }
        }
    }

    public static void initElevation(ShadowView view, TypedArray a, int[] ids) {
        ColorStateList shadowColor;
        int carbon_elevation = ids[0];
        int carbon_shadowColor = ids[1];
        int carbon_ambientShadowColor = ids[2];
        int carbon_spotShadowColor = ids[3];
        float elevation = a.getDimension(carbon_elevation, 0.0f);
        view.setElevation(elevation);
        if (elevation > 0.0f) {
            AnimUtils.setupElevationAnimator(((StateAnimatorView)((Object)view)).getStateAnimator(), view);
        }
        view.setElevationShadowColor((shadowColor = a.getColorStateList(carbon_shadowColor)) != null ? shadowColor.withAlpha(255) : null);
        if (a.hasValue(carbon_ambientShadowColor)) {
            ColorStateList ambientShadowColor = a.getColorStateList(carbon_ambientShadowColor);
            view.setOutlineAmbientShadowColor(ambientShadowColor != null ? ambientShadowColor.withAlpha(255) : null);
        }
        if (a.hasValue(carbon_spotShadowColor)) {
            ColorStateList spotShadowColor = a.getColorStateList(carbon_spotShadowColor);
            view.setOutlineSpotShadowColor(spotShadowColor != null ? spotShadowColor.withAlpha(255) : null);
        }
    }

    public static void initHtmlText(TextAppearanceView textView, TypedArray a, int id2) {
        String string = a.getString(id2);
        if (string != null) {
            textView.setText((CharSequence)Html.fromHtml((String)string));
        }
    }

    public static int getThemeColor(Context context, int attr2) {
        Resources.Theme theme = context.getTheme();
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attr2, typedValue, true);
        return typedValue.resourceId != 0 ? context.getResources().getColor(typedValue.resourceId) : typedValue.data;
    }

    public static Drawable getThemeDrawable(Context context, int attr2) {
        Resources.Theme theme = context.getTheme();
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attr2, typedValue, true);
        return typedValue.resourceId != 0 ? ContextCompat.getDrawable((Context)context, (int)typedValue.resourceId) : null;
    }

    public static Drawable getDrawable(View view, TypedArray a, int attr2, int defaultValue) {
        if (!view.isInEditMode()) {
            int resId = a.getResourceId(attr2, 0);
            if (resId != 0) {
                if (view.getContext().getResources().getResourceTypeName(resId).equals("raw")) {
                    return new VectorDrawable(view.getResources(), resId);
                }
                return ContextCompat.getDrawable((Context)view.getContext(), (int)resId);
            }
        } else {
            try {
                return a.getDrawable(attr2);
            }
            catch (Exception e) {
                return view.getResources().getDrawable(defaultValue);
            }
        }
        return null;
    }

    public static Context getThemedContext(Context context, AttributeSet attributeSet, int[] attrs, @AttrRes int defStyleAttr, int attr2) {
        TypedArray a = context.obtainStyledAttributes(attributeSet, attrs, defStyleAttr, 0);
        if (a.hasValue(attr2)) {
            int themeId = a.getResourceId(attr2, 0);
            a.recycle();
            return new ContextThemeWrapper(context, themeId);
        }
        return context;
    }

    public static int getDrawableAlpha(Drawable background) {
        if (background == null) {
            return 255;
        }
        if ((background = background.getCurrent()) instanceof ColorDrawable) {
            return ((ColorDrawable)background).getAlpha();
        }
        if (background instanceof AlphaDrawable) {
            return ((AlphaDrawable)background).getAlpha();
        }
        return 255;
    }

    public static float getBackgroundTintAlpha(View child) {
        if (!(child instanceof TintedView)) {
            return 255.0f;
        }
        ColorStateList tint = ((TintedView)child).getBackgroundTint();
        if (tint == null) {
            return 255.0f;
        }
        int color2 = tint.getColorForState(child.getDrawableState(), tint.getDefaultColor());
        return color2 >> 24 & 0xFF;
    }

    public static long getDefaultRevealDuration() {
        return defaultRevealDuration;
    }

    public static void setDefaultRevealDuration(long defaultRevealDuration) {
        Carbon.defaultRevealDuration = defaultRevealDuration;
    }

    public static void initStroke(StrokeView strokeView, TypedArray a, int[] ids) {
        int carbon_stroke = ids[0];
        int carbon_strokeWidth = ids[1];
        View view = (View)strokeView;
        ColorStateList color2 = Carbon.getDefaultColorStateList(view, a, carbon_stroke);
        if (color2 == null) {
            color2 = a.getColorStateList(carbon_stroke);
        }
        if (color2 != null) {
            strokeView.setStroke(AnimatedColorStateList.fromList(color2, animation -> view.postInvalidate()));
        }
        strokeView.setStrokeWidth(a.getDimension(carbon_strokeWidth, 0.0f));
    }

    public static void initCornerCutRadius(ShapeModelView shapeModelView, TypedArray a, int[] ids) {
        int carbon_cornerRadiusTopStart = ids[0];
        int carbon_cornerRadiusTopEnd = ids[1];
        int carbon_cornerRadiusBottomStart = ids[2];
        int carbon_cornerRadiusBottomEnd = ids[3];
        int carbon_cornerRadius = ids[4];
        int carbon_cornerCutTopStart = ids[5];
        int carbon_cornerCutTopEnd = ids[6];
        int carbon_cornerCutBottomStart = ids[7];
        int carbon_cornerCutBottomEnd = ids[8];
        int carbon_cornerCut = ids[9];
        float cornerRadius = Math.max(a.getDimension(carbon_cornerRadius, 0.0f), 0.1f);
        float cornerRadiusTopStart = a.getDimension(carbon_cornerRadiusTopStart, cornerRadius);
        float cornerRadiusTopEnd = a.getDimension(carbon_cornerRadiusTopEnd, cornerRadius);
        float cornerRadiusBottomStart = a.getDimension(carbon_cornerRadiusBottomStart, cornerRadius);
        float cornerRadiusBottomEnd = a.getDimension(carbon_cornerRadiusBottomEnd, cornerRadius);
        float cornerCut = a.getDimension(carbon_cornerCut, 0.0f);
        float cornerCutTopStart = a.getDimension(carbon_cornerCutTopStart, cornerCut);
        float cornerCutTopEnd = a.getDimension(carbon_cornerCutTopEnd, cornerCut);
        float cornerCutBottomStart = a.getDimension(carbon_cornerCutBottomStart, cornerCut);
        float cornerCutBottomEnd = a.getDimension(carbon_cornerCutBottomEnd, cornerCut);
        ShapeAppearanceModel model = ShapeAppearanceModel.builder().setTopLeftCorner((CornerTreatment)(cornerCutTopStart >= cornerRadiusTopStart ? new CutCornerTreatment(cornerCutTopStart) : new RoundedCornerTreatment(cornerRadiusTopStart))).setTopRightCorner((CornerTreatment)(cornerCutTopEnd >= cornerRadiusTopEnd ? new CutCornerTreatment(cornerCutTopEnd) : new RoundedCornerTreatment(cornerRadiusTopEnd))).setBottomLeftCorner((CornerTreatment)(cornerCutBottomStart >= cornerRadiusBottomStart ? new CutCornerTreatment(cornerCutBottomStart) : new RoundedCornerTreatment(cornerRadiusBottomStart))).setBottomRightCorner((CornerTreatment)(cornerCutBottomEnd >= cornerRadiusBottomEnd ? new CutCornerTreatment(cornerCutBottomEnd) : new RoundedCornerTreatment(cornerRadiusBottomEnd))).build();
        shapeModelView.setShapeModel(model);
    }

    public static void initAutoSizeText(AutoSizeTextView view, TypedArray a, int[] ids) {
        int carbon_autoSizeText = ids[0];
        int carbon_autoSizeMinTextSize = ids[1];
        int carbon_autoSizeMaxTextSize = ids[2];
        int carbon_autoSizeStepGranularity = ids[3];
        view.setAutoSizeText(AutoSizeTextMode.values()[a.getInt(carbon_autoSizeText, 0)]);
        view.setMinTextSize(a.getDimension(carbon_autoSizeMinTextSize, 0.0f));
        view.setMaxTextSize(a.getDimension(carbon_autoSizeMaxTextSize, 0.0f));
        view.setAutoSizeStepGranularity(a.getDimension(carbon_autoSizeStepGranularity, 1.0f));
    }

    public static float getThemeDimen(Context context, int attr2) {
        Resources.Theme theme = context.getTheme();
        TypedValue typedValueAttr = new TypedValue();
        theme.resolveAttribute(attr2, typedValueAttr, true);
        return typedValueAttr.getDimension(context.getResources().getDisplayMetrics());
    }

    public static int getThemeResId(Context context, int attr2) {
        Resources.Theme theme = context.getTheme();
        TypedValue typedValueAttr = new TypedValue();
        theme.resolveAttribute(attr2, typedValueAttr, true);
        return typedValueAttr.resourceId;
    }

    public static Menu getMenu(Context context, int resId) {
        Context contextWrapper = context;
        MenuBuilder menu = new MenuBuilder(contextWrapper);
        SupportMenuInflater inflater = new SupportMenuInflater(contextWrapper);
        inflater.inflate(resId, (Menu)menu);
        return menu;
    }

    public static float getRevealRadius(View view, int x, int y, float radius) {
        if (radius >= 0.0f) {
            return radius;
        }
        if (radius != -1.0f) {
            throw new InvalidParameterException("radius should be RevealView.MAX_RADIUS, 0.0f or a positive float");
        }
        int w = Math.max(view.getWidth() - x, x);
        int h = Math.max(view.getHeight() - y, y);
        return (float)Math.sqrt(w * w + h * h);
    }

    public static void setTint(Drawable drawable2, int tint) {
        if (IS_LOLLIPOP_OR_HIGHER) {
            drawable2.setTint(tint);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTint(tint);
        } else {
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(tint, PorterDuff.Mode.SRC_IN));
        }
    }

    public static void setTintListMode(Drawable drawable2, ColorStateList tint, PorterDuff.Mode mode) {
        if (IS_LOLLIPOP_OR_HIGHER) {
            drawable2.setTintList(tint);
            drawable2.setTintMode(mode);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTintList(tint);
            ((TintAwareDrawable)drawable2).setTintMode(mode);
        } else {
            drawable2.setColorFilter((ColorFilter)(tint == null ? null : new PorterDuffColorFilter(tint.getColorForState(drawable2.getState(), tint.getDefaultColor()), mode)));
        }
    }

    public static void clearTint(Drawable drawable2) {
        if (IS_LOLLIPOP_OR_HIGHER) {
            drawable2.setTintList(null);
        } else if (drawable2 instanceof TintAwareDrawable) {
            ((TintAwareDrawable)drawable2).setTintList(null);
        } else {
            drawable2.setColorFilter(null);
        }
    }

    public static boolean isShapeRect(ShapeAppearanceModel model, RectF bounds) {
        return model.getTopLeftCornerSize().getCornerSize(bounds) <= 0.2f && model.getTopRightCornerSize().getCornerSize(bounds) <= 0.2f && model.getBottomLeftCornerSize().getCornerSize(bounds) <= 0.2f && model.getBottomRightCornerSize().getCornerSize(bounds) <= 0.2f;
    }

    public static void logReflectionError(Exception e) {
        StackTraceElement cause = e.getStackTrace()[0];
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        Log.e((String)"Carbon", (String)("This feature is implemented using reflection. If you see this exception, something in your setup may be nonstandard. If you believe so, please create an issue on https://github.com/ZieIony/Carbon/issues. Please provide at least the following information: \n - device: " + Build.MANUFACTURER + " " + Build.MODEL + ", API " + Build.VERSION.SDK_INT + "\n - method: " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(...)\n - cause: " + e.getClass().getName() + ": " + e.getMessage() + " at " + cause.getMethodName() + "(" + cause.getFileName() + ":" + cause.getLineNumber() + ")\n"), (Throwable)e);
    }

    public static void handleFontAttribute(TextAppearanceView textView, TypedArray appearance, final int textStyle, int fontWeight, int attributeId) {
        final WeakReference<TextAppearanceView> textViewWeak = new WeakReference<TextAppearanceView>(textView);
        final AtomicBoolean asyncFontPending = new AtomicBoolean();
        ResourcesCompat.FontCallback replyCallback = new ResourcesCompat.FontCallback(){

            public void onFontRetrieved(@NonNull Typeface typeface) {
                TextAppearanceView textView;
                if (asyncFontPending.get() && (textView = (TextAppearanceView)textViewWeak.get()) != null) {
                    textView.setTypeface(typeface, textStyle);
                }
            }

            public void onFontRetrievalFailed(int reason) {
            }
        };
        try {
            int resourceId = appearance.getResourceId(attributeId, 0);
            TypedValue mTypedValue = new TypedValue();
            Typeface typeface = ResourcesCompat.getFont(((View)textView).getContext(), resourceId, mTypedValue, textStyle, fontWeight, replyCallback);
            if (typeface != null) {
                asyncFontPending.set(true);
                textView.setTypeface(typeface, textStyle);
            }
        }
        catch (Resources.NotFoundException | UnsupportedOperationException throwable) {
            // empty catch block
        }
    }

    public static void setTextAppearance(TextAppearanceView tv, int resid, boolean hasTextColor, boolean readAll) {
        int attr2;
        int i;
        TypedArray appearance = ((View)tv).getContext().obtainStyledAttributes(resid, R.styleable.TextAppearance);
        int textStyle = appearance.getInt(R.styleable.TextAppearance_android_textStyle, 0);
        int fontWeight = appearance.getInt(R.styleable.TextAppearance_carbon_fontWeight, 400);
        if (readAll) {
            for (i = 0; i < appearance.getIndexCount(); ++i) {
                attr2 = appearance.getIndex(i);
                if (attr2 == R.styleable.TextAppearance_android_textSize) {
                    tv.setTextSize(appearance.getDimension(attr2, 12.0f));
                    continue;
                }
                if (attr2 != R.styleable.TextAppearance_android_textColor || appearance.getColor(attr2, 0) == ((View)tv).getResources().getColor(R.color.carbon_defaultColorControl)) continue;
                tv.setTextColor(appearance.getColorStateList(attr2));
            }
        }
        for (i = 0; i < appearance.getIndexCount(); ++i) {
            attr2 = appearance.getIndex(i);
            if (attr2 == R.styleable.TextAppearance_carbon_font) {
                Carbon.handleFontAttribute(tv, appearance, textStyle, fontWeight, attr2);
                continue;
            }
            if (attr2 == R.styleable.TextAppearance_android_textAllCaps) {
                tv.setAllCaps(appearance.getBoolean(attr2, true));
                continue;
            }
            if (hasTextColor || attr2 != R.styleable.TextAppearance_android_textColor) continue;
            Carbon.initDefaultTextColor(tv, appearance, attr2);
        }
        appearance.recycle();
    }
}

