/*
 * Decompiled with CFR 0.152.
 */
package carbon.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import carbon.R;
import carbon.animation.StateAnimator;
import carbon.animation.ViewAnimator;
import carbon.internal.MathUtils;
import carbon.view.ShadowView;
import carbon.widget.ProgressView;

public class AnimUtils {
    public static final long TOOLTIP_DURATION = 3000L;
    public static final int SHORT_ANIMATION_DURATION = 150;
    private static final int LONG_ANIMATION_DURATION = 500;

    private AnimUtils() {
    }

    public static ValueAnimator getFadeInAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            if (view.getVisibility() != 0) {
                view.setAlpha(0.0f);
            }
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 1.0f});
            animator.setDuration((long)(150.0f * (1.0f - start)));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static ValueAnimator getFadeOutAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 0.0f});
            animator.setDuration((long)(150.0f * start));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static Animator getPopInAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            if (view.getVisibility() != 0) {
                view.setAlpha(0.0f);
            }
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 1.0f});
            animator.setDuration((long)(150.0f * (1.0f - start)));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setScaleX(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setScaleY(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static Animator getPopOutAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 0.0f});
            animator.setDuration((long)(150.0f * start));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setScaleX(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setScaleY(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static ValueAnimator getFlyInAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            if (view.getVisibility() != 0) {
                view.setAlpha(0.0f);
            }
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 1.0f});
            animator.setDuration((long)(150.0f * (1.0f - start)));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setTranslationY(Math.min((float)(view.getHeight() / 2), view.getResources().getDimension(R.dimen.carbon_1dip) * 50.0f) * (1.0f - ((Float)valueAnimator.getAnimatedValue()).floatValue()));
        });
        return animator;
    }

    public static ValueAnimator getFlyOutAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            float start = view.getAlpha();
            animator.setFloatValues(new float[]{start, 0.0f});
            animator.setDuration((long)(150.0f * start));
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            view.setTranslationY(Math.min((float)(view.getHeight() / 2), view.getResources().getDimension(R.dimen.carbon_1dip) * 50.0f) * (1.0f - ((Float)valueAnimator.getAnimatedValue()).floatValue()));
        });
        return animator;
    }

    public static ValueAnimator getSlideInAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            View view = animator.getTarget();
            animator.setFloatValues(new float[]{view.getTranslationY(), 0.0f});
            int height = view.getMeasuredHeight();
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams != null && layoutParams instanceof ViewGroup.MarginLayoutParams) {
                height += ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
            }
            long duration = (long)(150.0f * Math.abs(view.getTranslationY() / (float)height));
            animator.setDuration(duration);
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setTranslationY(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static ValueAnimator getSlideOutAnimator() {
        return AnimUtils.getSlideOutAnimator(80);
    }

    public static ValueAnimator getSlideOutAnimator(int gravity) {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            boolean top;
            View view = animator.getTarget();
            int height = view.getMeasuredHeight();
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            boolean bl = top = (gravity & 0x50) == 80;
            if (layoutParams != null && layoutParams instanceof ViewGroup.MarginLayoutParams) {
                height += top ? ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin : ((ViewGroup.MarginLayoutParams)layoutParams).topMargin;
            }
            animator.setFloatValues(new float[]{view.getTranslationY(), top ? (float)height : (float)(-height)});
            long duration = (long)(150.0f * (1.0f - Math.abs(view.getTranslationY() / (float)height)));
            animator.setDuration(duration);
        });
        animator.addUpdateListener(valueAnimator -> {
            View view = animator.getTarget();
            view.setTranslationY(((Float)valueAnimator.getAnimatedValue()).floatValue());
        });
        return animator;
    }

    public static ValueAnimator getProgressWidthInAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            ProgressView circularProgress = (ProgressView)animator.getTarget();
            float arcWidth = circularProgress.getBarPadding() + circularProgress.getBarWidth();
            float start = circularProgress.getBarWidth();
            animator.setFloatValues(new float[]{circularProgress.getBarWidth(), arcWidth});
            animator.setDuration((long)(100.0f * (arcWidth - start)));
        });
        animator.addUpdateListener(valueAnimator -> {
            ProgressView circularProgress = (ProgressView)animator.getTarget();
            float arcWidth = circularProgress.getBarPadding() + circularProgress.getBarWidth();
            float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            circularProgress.setBarWidth(value);
            circularProgress.setBarPadding(arcWidth - value);
        });
        return animator;
    }

    public static Animator getProgressWidthOutAnimator() {
        ViewAnimator animator = new ViewAnimator();
        animator.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
        animator.setOnSetupValuesListener(() -> {
            ProgressView circularProgress = (ProgressView)animator.getTarget();
            float start = circularProgress.getBarWidth();
            animator.setFloatValues(new float[]{start, 0.0f});
            animator.setDuration((long)(100.0f * start));
        });
        animator.addUpdateListener(valueAnimator -> {
            ProgressView circularProgress = (ProgressView)animator.getTarget();
            float arcWidth = circularProgress.getBarPadding() + circularProgress.getBarWidth();
            float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            circularProgress.setBarWidth(value);
            circularProgress.setBarPadding(arcWidth - value);
        });
        return animator;
    }

    public static Animator getBrightnessSaturationFadeInAnimator() {
        final ViewAnimator animator = new ViewAnimator();
        final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.setOnSetupValuesListener(() -> {
            animator.setFloatValues(new float[]{0.0f, 1.0f});
            animator.setDuration(500L);
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            ColorMatrix saturationMatrix = new ColorMatrix();
            ColorMatrix brightnessMatrix = new ColorMatrix();

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ImageView imageView = (ImageView)animator.getTarget();
                float fraction = animator.getAnimatedFraction();
                this.saturationMatrix.setSaturation(((Float)animator.getAnimatedValue()).floatValue());
                float scale = 2.0f - interpolator.getInterpolation(Math.min(fraction * 4.0f / 3.0f, 1.0f));
                this.brightnessMatrix.setScale(scale, scale, scale, 1.0f);
                this.saturationMatrix.preConcat(this.brightnessMatrix);
                imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.saturationMatrix));
                imageView.setAlpha(interpolator.getInterpolation(Math.min(fraction * 2.0f, 1.0f)));
            }
        });
        return animator;
    }

    public static Animator getBrightnessSaturationFadeOutAnimator() {
        final ViewAnimator animator = new ViewAnimator();
        final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.setOnSetupValuesListener(() -> {
            animator.setFloatValues(new float[]{1.0f, 0.0f});
            animator.setDuration(500L);
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            ColorMatrix saturationMatrix = new ColorMatrix();
            ColorMatrix brightnessMatrix = new ColorMatrix();

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ImageView imageView = (ImageView)animator.getTarget();
                float fraction = animator.getAnimatedFraction();
                this.saturationMatrix.setSaturation(((Float)animator.getAnimatedValue()).floatValue());
                float scale = 2.0f - interpolator.getInterpolation(Math.min((1.0f - fraction) * 4.0f / 3.0f, 1.0f));
                this.brightnessMatrix.setScale(scale, scale, scale, 1.0f);
                this.saturationMatrix.preConcat(this.brightnessMatrix);
                imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.saturationMatrix));
                imageView.setAlpha(interpolator.getInterpolation(Math.min((1.0f - fraction) * 2.0f, 1.0f)));
            }
        });
        return animator;
    }

    public static int lerpColor(float interpolation, int val1, int val2) {
        int a = (int)MathUtils.lerp(val1 >> 24, val2 >> 24, interpolation);
        int r = (int)MathUtils.lerp(val1 >> 16 & 0xFF, val2 >> 16 & 0xFF, interpolation);
        int g = (int)MathUtils.lerp(val1 >> 8 & 0xFF, val2 >> 8 & 0xFF, interpolation);
        int b = (int)MathUtils.lerp(val1 & 0xFF, val2 & 0xFF, interpolation);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    public static void setupElevationAnimator(StateAnimator stateAnimator, final ShadowView view) {
        final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        AnimatorListenerAdapter animatorListener = new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                animator.setFloatValues(new float[]{view.getTranslationZ(), ((View)view).getResources().getDimension(R.dimen.carbon_translationButton)});
            }
        };
        animator.addUpdateListener(animation -> view.setTranslationZ(((Float)animation.getAnimatedValue()).floatValue()));
        stateAnimator.addState(new int[]{16842919}, (Animator)animator, (Animator.AnimatorListener)animatorListener);
        animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animatorListener = new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                animator.setFloatValues(new float[]{view.getTranslationZ(), 0.0f});
            }
        };
        animator.addUpdateListener(animation -> view.setTranslationZ(((Float)animation.getAnimatedValue()).floatValue()));
        stateAnimator.addState(new int[]{-16842919, 16842910}, (Animator)animator, (Animator.AnimatorListener)animatorListener);
        animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animatorListener = new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                animator.setFloatValues(new float[]{view.getElevation(), 0.0f});
            }
        };
        animator.addUpdateListener(animation -> view.setTranslationZ(((Float)animation.getAnimatedValue()).floatValue()));
        stateAnimator.addState(new int[]{16842910}, (Animator)animator, (Animator.AnimatorListener)animatorListener);
        animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(150L);
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animatorListener = new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                animator.setFloatValues(new float[]{view.getTranslationZ(), -view.getElevation()});
            }
        };
        animator.addUpdateListener(animation -> view.setTranslationZ(((Float)animation.getAnimatedValue()).floatValue()));
        stateAnimator.addState(new int[]{-16842910}, (Animator)animator, (Animator.AnimatorListener)animatorListener);
    }

    public static enum Style {
        None(() -> null, () -> null),
        Fade(AnimUtils::getFadeInAnimator, AnimUtils::getFadeOutAnimator),
        Pop(AnimUtils::getPopInAnimator, AnimUtils::getPopOutAnimator),
        Fly(AnimUtils::getFlyInAnimator, AnimUtils::getFlyOutAnimator),
        Slide(AnimUtils::getSlideInAnimator, AnimUtils::getSlideOutAnimator),
        BrightnessSaturationFade(AnimUtils::getBrightnessSaturationFadeInAnimator, AnimUtils::getBrightnessSaturationFadeOutAnimator),
        ProgressWidth(AnimUtils::getProgressWidthInAnimator, AnimUtils::getProgressWidthOutAnimator);

        private AnimatorFactory inAnimator;
        private AnimatorFactory outAnimator;

        private Style(AnimatorFactory inAnimator, AnimatorFactory outAnimator) {
            this.inAnimator = inAnimator;
            this.outAnimator = outAnimator;
        }

        public Animator getInAnimator() {
            return this.inAnimator.getAnimator();
        }

        public Animator getOutAnimator() {
            return this.outAnimator.getAnimator();
        }
    }

    static interface AnimatorFactory {
        public Animator getAnimator();
    }
}

