/*
 * Decompiled with CFR 0.152.
 */
package carbon.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.StateSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import carbon.internal.ArgbEvaluator;
import java.lang.reflect.Field;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcarbon/animation/AnimatedColorStateList;", "Landroid/content/res/ColorStateList;", "states", "", "", "colors", "listener", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "([[I[ILandroid/animation/ValueAnimator$AnimatorUpdateListener;)V", "animatedColor", "", "colorAnimation", "Landroid/animation/ValueAnimator;", "currentState", "[[I", "getColorForState", "stateSet", "defaultColor", "jumpToCurrentState", "", "setState", "newState", "Companion", "carbon_release"})
public final class AnimatedColorStateList
extends ColorStateList {
    private int[] currentState;
    private final ValueAnimator colorAnimation;
    private int animatedColor;
    private final int[][] states;
    private static Field mStateSpecsField;
    private static Field mColorsField;
    private static Field mDefaultColorField;
    @NotNull
    private static final Parcelable.Creator<AnimatedColorStateList> CREATOR;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColorForState(@Nullable int[] stateSet, int defaultColor) {
        AnimatedColorStateList animatedColorStateList = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (animatedColorStateList) {
            block4: {
                boolean bl3 = false;
                if (!Arrays.equals(stateSet, this.currentState) || !this.colorAnimation.isRunning()) break block4;
                int n = this.animatedColor;
                return n;
            }
            Unit unit = Unit.INSTANCE;
        }
        return super.getColorForState(stateSet, defaultColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setState(@NotNull int[] newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        AnimatedColorStateList animatedColorStateList = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (animatedColorStateList) {
            boolean bl3 = false;
            if (Arrays.equals(newState, this.currentState)) {
                return;
            }
            this.colorAnimation.end();
            if (this.currentState.length != 0) {
                for (int[] state : this.states) {
                    if (!StateSet.stateSetMatches((int[])state, (int[])newState)) continue;
                    int firstColor = this.getColorForState(this.currentState, this.getDefaultColor());
                    int secondColor = super.getColorForState(newState, this.getDefaultColor());
                    this.colorAnimation.setIntValues(new int[]{firstColor, secondColor});
                    this.currentState = newState;
                    this.animatedColor = firstColor;
                    this.colorAnimation.start();
                    return;
                }
            }
            this.currentState = newState;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void jumpToCurrentState() {
        this.colorAnimation.end();
    }

    public AnimatedColorStateList(@NotNull int[][] states, @Nullable int[] colors, final @Nullable ValueAnimator.AnimatorUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        super(states, colors);
        this.states = states;
        this.currentState = new int[0];
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, 0});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"ValueAnimator.ofInt(0, 0)");
        this.colorAnimation = valueAnimator;
        this.colorAnimation.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        this.colorAnimation.setDuration(200L);
        this.colorAnimation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onAnimationUpdate(@NotNull ValueAnimator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                AnimatedColorStateList animatedColorStateList = this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (animatedColorStateList) {
                    boolean bl3 = false;
                    Object object = animation.getAnimatedValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    animatedColor = (Integer)object;
                    ValueAnimator.AnimatorUpdateListener animatorUpdateListener = listener;
                    Intrinsics.checkNotNull((Object)animatorUpdateListener);
                    animatorUpdateListener.onAnimationUpdate(animation);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                Object object = colorAnimation.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                animatedColor = (Integer)object;
                ValueAnimator.AnimatorUpdateListener animatorUpdateListener = listener;
                Intrinsics.checkNotNull((Object)animatorUpdateListener);
                animatorUpdateListener.onAnimationUpdate(colorAnimation);
            }
        });
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<AnimatedColorStateList>(){

            @NotNull
            public AnimatedColorStateList[] newArray(int size) {
                return new AnimatedColorStateList[size];
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public AnimatedColorStateList createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                int N = source.readInt();
                int[][] stateSpecs = new int[N][];
                int n = 0;
                int n2 = N;
                while (n < n2) {
                    void i;
                    stateSpecs[i] = source.createIntArray();
                    ++i;
                }
                int[] colors = source.createIntArray();
                return AnimatedColorStateList.Companion.fromList(new ColorStateList((int[][])stateSpecs, colors), null);
            }
        };
        try {
            Field field = mStateSpecsField = ColorStateList.class.getDeclaredField("mStateSpecs");
            Intrinsics.checkNotNull((Object)field);
            field.setAccessible(true);
            Field field2 = mColorsField = ColorStateList.class.getDeclaredField("mColors");
            Intrinsics.checkNotNull((Object)field2);
            field2.setAccessible(true);
            Field field3 = mDefaultColorField = ColorStateList.class.getDeclaredField("mDefaultColor");
            Intrinsics.checkNotNull((Object)field3);
            field3.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ int access$getAnimatedColor$p(AnimatedColorStateList $this) {
        return $this.animatedColor;
    }

    public static final /* synthetic */ void access$setMStateSpecsField$cp(Field field) {
        mStateSpecsField = field;
    }

    public static final /* synthetic */ void access$setMColorsField$cp(Field field) {
        mColorsField = field;
    }

    public static final /* synthetic */ void access$setMDefaultColorField$cp(Field field) {
        mDefaultColorField = field;
    }

    @JvmStatic
    @Nullable
    public static final AnimatedColorStateList fromList(@Nullable ColorStateList list, @Nullable ValueAnimator.AnimatorUpdateListener listener) {
        return Companion.fromList(list, listener);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcarbon/animation/AnimatedColorStateList$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcarbon/animation/AnimatedColorStateList;", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "mColorsField", "Ljava/lang/reflect/Field;", "mDefaultColorField", "mStateSpecsField", "fromList", "list", "Landroid/content/res/ColorStateList;", "listener", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "carbon_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final AnimatedColorStateList fromList(@Nullable ColorStateList list, @Nullable ValueAnimator.AnimatorUpdateListener listener) {
            int[][] mStateSpecs = null;
            int[] mColors = null;
            int mDefaultColor = 0;
            try {
                Field field = mStateSpecsField;
                Intrinsics.checkNotNull((Object)field);
                Object object = field.get(list);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.IntArray>");
                }
                mStateSpecs = (int[][])object;
                Field field2 = mColorsField;
                Intrinsics.checkNotNull((Object)field2);
                Object object2 = field2.get(list);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                }
                mColors = (int[])object2;
                Field field3 = mDefaultColorField;
                Intrinsics.checkNotNull((Object)field3);
                Object object3 = field3.get(list);
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                mDefaultColor = (Integer)object3;
                AnimatedColorStateList animatedColorStateList = new AnimatedColorStateList(mStateSpecs, mColors, listener);
                Field field4 = mDefaultColorField;
                Intrinsics.checkNotNull((Object)field4);
                field4.set((Object)animatedColorStateList, mDefaultColor);
                return animatedColorStateList;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }

        @NotNull
        public final Parcelable.Creator<AnimatedColorStateList> getCREATOR() {
            return CREATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

