/*
 * Decompiled with CFR 0.152.
 */
package carbon.animation;

import android.animation.Animator;
import android.util.StateSet;
import android.view.View;
import carbon.animation.AnimatedView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class StateAnimator {
    private final ArrayList<Tuple> mTuples = new ArrayList();
    private Tuple lastMatch = null;
    private Animator runningAnimation = null;
    private WeakReference<AnimatedView> viewRef;
    private Animator.AnimatorListener mAnimationListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (StateAnimator.this.runningAnimation == animation) {
                StateAnimator.this.runningAnimation = null;
            }
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public StateAnimator(AnimatedView target) {
        this.setTarget(target);
    }

    public void addState(int[] specs, Animator animation, Animator.AnimatorListener listener) {
        Tuple tuple = new Tuple(specs, animation, listener);
        animation.addListener(this.mAnimationListener);
        this.mTuples.add(tuple);
    }

    Animator getRunningAnimation() {
        return this.runningAnimation;
    }

    AnimatedView getTarget() {
        return this.viewRef == null ? null : (AnimatedView)this.viewRef.get();
    }

    void setTarget(AnimatedView view) {
        AnimatedView current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.viewRef = new WeakReference<AnimatedView>(view);
        }
    }

    private void clearTarget() {
        AnimatedView view = this.getTarget();
        int size = this.mTuples.size();
        for (int i = 0; i < size; ++i) {
            Animator anim = this.mTuples.get((int)i).animation;
            if (view.getAnimator() != anim) continue;
            anim.cancel();
        }
        this.viewRef = null;
        this.lastMatch = null;
        this.runningAnimation = null;
    }

    public void setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches((int[])tuple.mSpecs, (int[])state)) continue;
            match = tuple;
            break;
        }
        if (match == this.lastMatch) {
            return;
        }
        if (this.lastMatch != null) {
            this.cancel();
        }
        this.lastMatch = match;
        View view = (View)this.viewRef.get();
        if (match != null && view != null && view.getVisibility() == 0) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        match.getListener().onAnimationStart(match.animation);
        this.runningAnimation = match.animation;
        this.runningAnimation.start();
    }

    private void cancel() {
        if (this.runningAnimation != null) {
            AnimatedView view = this.getTarget();
            if (view != null && view.getAnimator() == this.runningAnimation) {
                this.runningAnimation.cancel();
            }
            this.runningAnimation = null;
        }
    }

    ArrayList<Tuple> getTuples() {
        return this.mTuples;
    }

    public void jumpToCurrentState() {
        AnimatedView view;
        if (this.runningAnimation != null && (view = this.getTarget()) != null && view.getAnimator() == this.runningAnimation) {
            this.runningAnimation.cancel();
        }
    }

    static class Tuple {
        final int[] mSpecs;
        final Animator animation;
        private Animator.AnimatorListener listener;

        private Tuple(int[] specs, Animator Animation, Animator.AnimatorListener listener) {
            this.mSpecs = specs;
            this.animation = Animation;
            this.listener = listener;
        }

        int[] getSpecs() {
            return this.mSpecs;
        }

        Animator getAnimation() {
            return this.animation;
        }

        public Animator.AnimatorListener getListener() {
            return this.listener;
        }
    }
}

