/*
 * Decompiled with CFR 0.152.
 */
package carbon.behavior;

import android.graphics.PointF;
import android.view.View;
import carbon.view.TransformationView;
import carbon.widget.OnTransformationChangedListener;

public abstract class Behavior<Type extends View> {
    private Type target;
    private View dependency;
    private OnTransformationChangedListener transformationListener = () -> this.onDependencyChanged(this.getDependency());
    private View.OnLayoutChangeListener layoutListener = (view, i, i1, i2, i3, i4, i5, i6, i7) -> this.onDependencyChanged(this.getDependency());

    public Behavior(Type target) {
        this.target = target;
    }

    public Type getTarget() {
        return this.target;
    }

    public View getDependency() {
        return this.dependency;
    }

    public void setDependency(View dependency) {
        this.removeListeners();
        this.dependency = dependency;
        this.addListeners();
    }

    public PointF onScroll(float scrollX, float scrollY) {
        return new PointF(scrollX, scrollY);
    }

    public void onDependencyChanged(View view) {
    }

    public void onAttachedToWindow() {
        this.addListeners();
    }

    private void addListeners() {
        if (this.dependency == null) {
            return;
        }
        if (this.dependency instanceof TransformationView) {
            ((TransformationView)this.dependency).addOnTransformationChangedListener(this.transformationListener);
        }
        this.dependency.addOnLayoutChangeListener(this.layoutListener);
    }

    public void onDetachedFromWindow() {
        this.removeListeners();
    }

    private void removeListeners() {
        if (this.dependency == null) {
            return;
        }
        if (this.dependency instanceof TransformationView) {
            ((TransformationView)this.dependency).removeOnTransformationChangedListener(this.transformationListener);
        }
        this.dependency.removeOnLayoutChangeListener(this.layoutListener);
    }
}

