/*
 * Decompiled with CFR 0.152.
 */
package carbon.behavior;

import android.graphics.PointF;
import android.view.View;
import android.view.ViewGroup;
import carbon.behavior.Behavior;
import carbon.internal.MathUtils;

public class HeightBehavior<Type extends View>
extends Behavior<Type> {
    private final float minHeight;
    private final float maxHeight;
    private final Direction direction;

    public HeightBehavior(Type target, float minHeight, float maxHeight, Direction direction) {
        super(target);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.direction = direction;
    }

    @Override
    public PointF onScroll(float scrollX, float scrollY) {
        if (this.direction == Direction.Down && scrollY > 0.0f || this.direction == Direction.Up && scrollY < 0.0f) {
            return new PointF(scrollX, scrollY);
        }
        int height = this.getTarget().getHeight();
        int newHeight = (int)MathUtils.constrain((float)height - scrollY, this.minHeight, this.maxHeight);
        this.setHeight(newHeight);
        float scrollLeft = 0.0f;
        scrollLeft = scrollY > 0.0f ? Math.max(0.0f, scrollY - (float)(height - newHeight)) : Math.max(0.0f, -scrollY - (float)(newHeight - height));
        return new PointF(scrollX, scrollLeft);
    }

    private void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.getTarget().getLayoutParams();
        if (layoutParams == null) {
            this.getTarget().setLayoutParams(new ViewGroup.LayoutParams(-2, height));
        } else {
            layoutParams.height = height;
            this.getTarget().setLayoutParams(layoutParams);
        }
    }

    public static enum Direction {
        Up,
        Down,
        Both;

    }
}

