/*
 * Decompiled with CFR 0.152.
 */
package carbon.beta;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import androidx.core.view.MenuItemCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.component.BottomSheetCell;
import carbon.component.BottomSheetRow;
import carbon.recycler.RowListAdapter;
import carbon.recycler.ViewItemDecoration;
import carbon.widget.LinearLayout;
import carbon.widget.NavigationView;
import carbon.widget.RecyclerView;
import carbon.widget.TextView;
import java.io.Serializable;
import java.util.ArrayList;

public class BottomSheetLayout
extends LinearLayout {
    private Menu menu;
    private MenuItem.OnMenuItemClickListener listener;
    private TextView titleTv;
    private RecyclerView recycler;
    private Style style = Style.List;

    public BottomSheetLayout(Context context) {
        super(context);
        this.initBottomSheet();
    }

    public BottomSheetLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initBottomSheet();
    }

    public BottomSheetLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initBottomSheet();
    }

    public BottomSheetLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initBottomSheet();
    }

    private void initBottomSheet() {
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_bottomsheet, (ViewGroup)this);
        this.setOrientation(1);
        this.titleTv = (TextView)this.findViewById(R.id.carbon_bottomSheetTitle);
        this.recycler = (RecyclerView)this.findViewById(R.id.carbon_bottomSheetRecycler);
    }

    public void setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener listener) {
        this.listener = listener;
    }

    public void setMenu(int resId) {
        this.menu = Carbon.getMenu(this.getContext(), resId);
        this.updateRecycler();
    }

    public void setMenu(Menu baseMenu) {
        this.menu = baseMenu;
        this.updateRecycler();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style2) {
        this.style = style2;
        this.updateRecycler();
    }

    public void setTitle(String title) {
        this.titleTv.setText(title);
        this.titleTv.setVisibility(TextUtils.isEmpty((CharSequence)title) ? 8 : 0);
        this.updateRecycler();
    }

    private void updateRecycler() {
        int i;
        if (this.menu == null) {
            return;
        }
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)(this.style == Style.List ? new LinearLayoutManager(this.getContext()) : new GridLayoutManager(this.getContext(), 3)));
        ArrayList<Item> items = new ArrayList<Item>();
        for (i = 0; i < this.menu.size(); ++i) {
            if (!this.menu.getItem(i).isVisible()) continue;
            items.add(new Item(this.menu.getItem(i)));
        }
        if (this.style == Style.List) {
            for (i = 0; i < this.recycler.getItemDecorationCount(); ++i) {
                this.recycler.removeItemDecorationAt(0);
            }
            ViewItemDecoration dividerItemDecoration = new ViewItemDecoration(this.getContext(), R.layout.carbon_menustrip_hseparator_item);
            dividerItemDecoration.setDrawAfter(position -> position < items.size() - 1 && items.get(position) instanceof NavigationView.Item && items.get(position + 1) instanceof NavigationView.Item && ((NavigationView.Item)items.get(position)).getGroupId() != ((NavigationView.Item)items.get(position + 1)).getGroupId());
            this.recycler.addItemDecoration(dividerItemDecoration);
            ViewItemDecoration paddingItemDecoration = new ViewItemDecoration(this.getContext(), R.layout.carbon_row_padding);
            paddingItemDecoration.setDrawAfter(position -> position == items.size() - 1);
            this.recycler.addItemDecoration(paddingItemDecoration);
        }
        RowListAdapter adapter = new RowListAdapter();
        adapter.putFactory(Item.class, this.style == Style.List ? BottomSheetRow::new : BottomSheetCell::new);
        adapter.setItems(items);
        this.recycler.setAdapter(adapter);
    }

    public static enum Style {
        List,
        Grid;

    }

    public static class Item
    implements Serializable {
        private ColorStateList iconTint;
        private int groupId;
        private Drawable icon;
        private CharSequence title;

        public Item() {
        }

        public Item(MenuItem menuItem) {
            this.groupId = menuItem.getGroupId();
            this.icon = menuItem.getIcon();
            this.iconTint = MenuItemCompat.getIconTintList((MenuItem)menuItem);
            this.title = menuItem.getTitle();
        }

        public int getGroupId() {
            return this.groupId;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public ColorStateList getIconTintList() {
            return this.iconTint;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }
}

