/*
 * Decompiled with CFR 0.152.
 */
package carbon.beta;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.view.View;
import java.util.Arrays;

public class ChartView
extends View {
    private Item[] items;
    private Paint paint = new Paint(1);
    private float spacing = 0.0f;
    private float barCornerRadius = 0.0f;
    private float linesThickness;
    private float chartPadding = 0.0f;
    private float axesThickness;
    private float gridDensity;
    private float gridThickness;
    private ColorStateList itemColor;
    private ColorStateList axesColor;
    private ColorStateList gridColor;
    private Item selectedItem;
    private RectF rect = new RectF();
    private float maxItemHeight = 0.0f;
    private ChartType chartType;
    private ValueAnimator.AnimatorUpdateListener colorAnimatorListener = animator -> this.postInvalidate();

    public ChartView(Context context) {
        super(context, null, R.attr.carbon_chartViewStyle);
        this.initChartView(null, R.attr.carbon_chartViewStyle, R.style.carbon_ChartView);
    }

    public ChartView(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_chartViewStyle);
        this.initChartView(attrs, R.attr.carbon_chartViewStyle, R.style.carbon_ChartView);
    }

    public ChartView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initChartView(attrs, defStyleAttr, R.style.carbon_ChartView);
    }

    @TargetApi(value=21)
    public ChartView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initChartView(attrs, defStyleAttr, defStyleRes);
    }

    public void initChartView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChartView, defStyleAttr, defStyleRes);
        this.setItemSpacing(a.getDimension(R.styleable.ChartView_carbon_itemSpacing, 0.0f));
        this.setItemColor(Carbon.getColorStateList(this, a, R.styleable.ChartView_carbon_itemColor));
        this.setBarCornerRadius(a.getDimension(R.styleable.ChartView_carbon_barCornerRadius, 0.0f));
        this.setLinesThickness(a.getDimension(R.styleable.ChartView_carbon_linesThickness, 1.0f));
        this.setChartPadding(a.getDimension(R.styleable.ChartView_carbon_chartPadding, 0.0f));
        this.setAxesColor(a.getColorStateList(R.styleable.ChartView_carbon_axesColor));
        this.setAxesThickness(a.getDimensionPixelSize(R.styleable.ChartView_carbon_axesThickness, 1));
        this.setChartType(ChartType.values()[a.getInt(R.styleable.ChartView_carbon_chartType, 0)]);
        this.setGridDensity(a.getDimension(R.styleable.ChartView_carbon_gridDensity, 0.0f));
        this.setGridColor(a.getColorStateList(R.styleable.ChartView_carbon_gridColor));
        this.setGridThickness(a.getDimensionPixelSize(R.styleable.ChartView_carbon_gridThickness, 1));
        a.recycle();
    }

    public void setItems(Item[] items) {
        this.items = Arrays.copyOf(items, items.length);
        this.maxItemHeight = 0.0f;
        for (Item item : items) {
            this.maxItemHeight = Math.max(this.maxItemHeight, item.value);
        }
    }

    public void setItemSpacing(float spacing) {
        this.spacing = spacing;
    }

    public void setItemColor(ColorStateList itemColor) {
        this.itemColor = this.isAnimateColorChangesEnabled() && !(itemColor instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(itemColor, this.colorAnimatorListener) : itemColor;
    }

    public void setItemColor(int itemColor) {
        this.setItemColor(ColorStateList.valueOf((int)itemColor));
    }

    public void setBarCornerRadius(float barCornerRadius) {
        this.barCornerRadius = barCornerRadius;
    }

    public float getBarCornerRadius() {
        return this.barCornerRadius;
    }

    public float getLinesThickness() {
        return this.linesThickness;
    }

    public void setLinesThickness(float linesThickness) {
        this.linesThickness = linesThickness;
    }

    public void setAxesColor(ColorStateList axesColor) {
        this.axesColor = this.isAnimateColorChangesEnabled() && !(axesColor instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(axesColor, this.colorAnimatorListener) : axesColor;
    }

    public ColorStateList getAxesColor() {
        return this.axesColor;
    }

    public void setChartPadding(float graphPadding) {
        this.chartPadding = graphPadding;
    }

    public float getChartPadding() {
        return this.chartPadding;
    }

    public void setAxesThickness(float axesThickness) {
        this.axesThickness = axesThickness;
    }

    public float getAxesThickness() {
        return this.axesThickness;
    }

    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public float getGridDensity() {
        return this.gridDensity;
    }

    public void setGridDensity(float gridDensity) {
        this.gridDensity = gridDensity;
    }

    public ColorStateList getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(ColorStateList gridColor) {
        this.gridColor = this.isAnimateColorChangesEnabled() && !(gridColor instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(gridColor, this.colorAnimatorListener) : gridColor;
    }

    public float getGridThickness() {
        return this.gridThickness;
    }

    public void setGridThickness(float gridThickness) {
        this.gridThickness = gridThickness;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.items == null) {
            this.selectedItem = null;
            return false;
        }
        float viewportWidth = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) - this.chartPadding * 2.0f;
        float itemWidth = (viewportWidth - (float)(this.items.length - 1) * this.spacing) / (float)this.items.length;
        for (int i = 0; i < this.items.length; ++i) {
            if (!(event.getX() >= this.chartPadding + (float)this.getPaddingLeft() + (float)i * (itemWidth + this.spacing)) || !(event.getX() <= this.chartPadding + (float)this.getPaddingLeft() + (float)i * (itemWidth + this.spacing) + itemWidth)) continue;
            this.selectedItem = this.items[i];
            this.postInvalidate();
            break;
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.items == null || this.maxItemHeight == 0.0f) {
            return;
        }
        float viewportWidth = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) - this.chartPadding * 2.0f;
        float viewportHeight = (float)(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) - this.chartPadding;
        this.paint.setStrokeWidth(this.gridThickness);
        this.paint.setColor(this.gridColor.getColorForState(this.getDrawableState(), this.gridColor.getDefaultColor()));
        for (float y = viewportHeight + this.chartPadding - this.gridDensity; y >= this.chartPadding; y -= this.gridDensity) {
            canvas.drawLine((float)this.getPaddingLeft(), y + (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), y + (float)this.getPaddingTop(), this.paint);
        }
        this.paint.setStrokeWidth(this.axesThickness);
        this.paint.setColor(this.axesColor.getColorForState(this.getDrawableState(), this.axesColor.getDefaultColor()));
        canvas.drawLine((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft(), (float)(this.getHeight() - this.getPaddingBottom()), this.paint);
        canvas.drawLine((float)this.getPaddingLeft(), (float)(this.getHeight() - this.getPaddingBottom()), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()), this.paint);
        this.paint.setStrokeWidth(this.linesThickness);
        int saveCount = canvas.save();
        canvas.clipRect((float)this.getPaddingLeft() + this.chartPadding, (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()) - this.chartPadding, (float)(this.getHeight() - this.getPaddingBottom()));
        canvas.translate((float)this.getPaddingLeft() + this.chartPadding, (float)this.getPaddingTop() + this.chartPadding);
        switch (this.chartType) {
            case Bar: {
                this.drawBarChart(canvas, viewportWidth, viewportHeight);
                break;
            }
            case Line: {
                this.drawLineChart(canvas, viewportWidth, viewportHeight);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private void drawBarChart(Canvas canvas, float width, float height) {
        float itemWidth = (width - (float)(this.items.length - 1) * this.spacing) / (float)this.items.length;
        for (int i = 0; i < this.items.length; ++i) {
            ColorStateList color2;
            Item item = this.items[i];
            ColorStateList colorStateList = color2 = item.color != null ? item.color : this.itemColor;
            if (this.itemColor == null) continue;
            this.paint.setColor(color2.getColorForState(this.getDrawableStateSelected(this.selectedItem == item), color2.getDefaultColor()));
            this.rect.set((float)i * (itemWidth + this.spacing), height - height / this.maxItemHeight * item.value, (float)i * (itemWidth + this.spacing) + itemWidth, height + this.barCornerRadius);
            canvas.drawRoundRect(this.rect, this.barCornerRadius, this.barCornerRadius, this.paint);
        }
    }

    private void drawLineChart(Canvas canvas, float width, float height) {
        float itemWidth = (width - (float)(this.items.length - 1) * this.spacing) / (float)this.items.length;
        for (int i = 0; i < this.items.length - 1; ++i) {
            ColorStateList color2;
            Item item = this.items[i];
            Item item2 = this.items[i + 1];
            ColorStateList colorStateList = color2 = item.color != null ? item.color : this.itemColor;
            if (this.itemColor == null) continue;
            this.paint.setColor(color2.getColorForState(this.getDrawableStateSelected(this.selectedItem == item), color2.getDefaultColor()));
            canvas.drawLine((float)i * (itemWidth + this.spacing) + itemWidth / 2.0f, height - height / this.maxItemHeight * item.value, (float)(i + 1) * (itemWidth + this.spacing) + itemWidth / 2.0f, height - height / this.maxItemHeight * item2.value, this.paint);
        }
    }

    private int[] getDrawableStateSelected(boolean selected) {
        if (!selected) {
            return this.getDrawableState();
        }
        int[] newState = Arrays.copyOf(this.getDrawableState(), this.getDrawableState().length + 1);
        newState[newState.length - 1] = 0x10100A1;
        return newState;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.axesColor instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.axesColor).setState(this.getDrawableState());
        }
        if (this.itemColor instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.itemColor).setState(this.getDrawableState());
        }
        if (this.gridColor instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.gridColor).setState(this.getDrawableState());
        }
    }

    public static class Item {
        String name;
        float value;
        ColorStateList color;

        public Item() {
        }

        public Item(String name, float value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public void setColor(ColorStateList color2) {
            this.color = color2;
        }

        public ColorStateList getColor() {
            return this.color;
        }
    }

    public static enum ChartType {
        Bar,
        Line;

    }
}

