/*
 * Decompiled with CFR 0.152.
 */
package carbon.beta;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.appcompat.view.ContextThemeWrapper;
import carbon.R;
import carbon.internal.EditTextMenu;
import carbon.widget.EditText;
import java.lang.reflect.Field;

public class MarshmallowEditText
extends EditText {
    private static final int ID_CUT = 0x1020020;
    private static final int ID_COPY = 0x1020021;
    private static final int ID_PASTE = 0x1020022;
    private static final int ID_COPY_URL = 16908323;
    private static final int ID_SELECT_ALL = 16908319;
    EditTextMenu popupMenu;
    private boolean isShowingPopup = false;
    WindowManager brokenWindowManager = new WindowManager(){

        public Display getDefaultDisplay() {
            return null;
        }

        public void removeViewImmediate(View view) {
        }

        public void addView(View view, ViewGroup.LayoutParams params) {
            WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
            view.setLayoutParams((ViewGroup.LayoutParams)wparams);
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
            WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
            view.setLayoutParams((ViewGroup.LayoutParams)wparams);
        }

        public void removeView(View view) {
        }
    };

    public MarshmallowEditText(Context context) {
        super(context);
        this.initActionModeCallback();
    }

    public MarshmallowEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initActionModeCallback();
    }

    public MarshmallowEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initActionModeCallback();
    }

    public MarshmallowEditText(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initActionModeCallback();
    }

    public boolean onTextContextMenuItem(int id2) {
        boolean result = super.onTextContextMenuItem(id2);
        if (id2 == 16908319) {
            this.showContextMenu();
        }
        return result;
    }

    public int getSelectionStart() {
        try {
            if (this.brokenWindowManager != null) {
                Field ccmf = TextView.class.getDeclaredField("mCursorControllerMenu");
                ccmf.setAccessible(true);
                Object ccm = ccmf.get(this);
                Field pwf = ccm.getClass().getDeclaredField("mPopupWindow");
                pwf.setAccessible(true);
                PopupWindow pw = (PopupWindow)pwf.get(ccm);
                Field wmf = pw.getClass().getDeclaredField("mWindowManager");
                wmf.setAccessible(true);
                wmf.set(pw, this.brokenWindowManager);
                pwf = ccm.getClass().getDeclaredField("mPopupWindowArrowDown");
                pwf.setAccessible(true);
                pw = (PopupWindow)pwf.get(ccm);
                wmf = pw.getClass().getDeclaredField("mWindowManager");
                wmf.setAccessible(true);
                wmf.set(pw, this.brokenWindowManager);
                pwf = ccm.getClass().getDeclaredField("mPopupWindowArrowUp");
                pwf.setAccessible(true);
                pw = (PopupWindow)pwf.get(ccm);
                wmf = pw.getClass().getDeclaredField("mWindowManager");
                wmf.setAccessible(true);
                wmf.set(pw, this.brokenWindowManager);
                this.brokenWindowManager = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getSelectionStart();
    }

    public ActionMode startActionMode(final ActionMode.Callback callback) {
        ActionMode.Callback c = new ActionMode.Callback(){

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return callback.onPrepareActionMode(mode, menu);
            }

            public void onDestroyActionMode(ActionMode mode) {
                MarshmallowEditText.this.popupMenu.dismiss();
                callback.onDestroyActionMode(mode);
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                return callback.onCreateActionMode(mode, menu);
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return callback.onActionItemClicked(mode, item);
            }
        };
        return super.startActionMode(c);
    }

    public ActionMode startActionMode(final ActionMode.Callback callback, int type) {
        ActionMode.Callback c = new ActionMode.Callback(){

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                MarshmallowEditText.this.prepareMenu();
                return true;
            }

            public void onDestroyActionMode(ActionMode mode) {
                callback.onDestroyActionMode(mode);
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                callback.onCreateActionMode(mode, menu);
                MarshmallowEditText.this.createMenu(menu);
                menu.clear();
                return true;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return callback.onActionItemClicked(mode, item);
            }
        };
        return super.startActionMode(c, type);
    }

    private void initActionModeCallback() {
        this.setCustomSelectionActionModeCallback(new ActionMode.Callback(){

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                MarshmallowEditText.this.createMenu(menu);
                return true;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return false;
            }
        });
        if (Build.VERSION.SDK_INT >= 23) {
            this.setCustomInsertionActionModeCallback(new ActionMode.Callback(){

                public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                    MarshmallowEditText.this.createMenu(menu);
                    return true;
                }

                public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                    return false;
                }

                public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                    return false;
                }

                public void onDestroyActionMode(ActionMode mode) {
                }
            });
        }
    }

    protected void onCreateContextMenu(ContextMenu menu) {
        super.onCreateContextMenu(menu);
    }

    private void prepareMenu() {
        if (this.popupMenu.hasVisibleItems()) {
            this.popupMenu.show(this);
            this.isShowingPopup = true;
        }
    }

    private void createMenu(Menu menu) {
        TypedValue outValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.carbon_editMenuTheme, outValue, true);
        int theme = outValue.resourceId;
        ContextThemeWrapper themedContext = new ContextThemeWrapper(this.getContext(), theme);
        this.popupMenu = new EditTextMenu((Context)themedContext);
        this.popupMenu.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                MarshmallowEditText.this.isShowingPopup = false;
            }
        });
        this.popupMenu.initCopy(menu.findItem(0x1020021));
        this.popupMenu.initCut(menu.findItem(0x1020020));
        this.popupMenu.initPaste(menu.findItem(0x1020022));
        this.popupMenu.initSelectAll(menu.findItem(16908319));
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.popupMenu != null) {
            this.popupMenu.update();
        }
        return result;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isShowingPopup) {
            this.popupMenu.showImmediate(this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isShowingPopup) {
            this.popupMenu.dismissImmediate();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isShowingPopup = this.isShowingPopup ? 1 : 0;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.isShowingPopup = ss.isShowingPopup > 0;
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        int isShowingPopup;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(EditText.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.isShowingPopup = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeInt(this.isShowingPopup);
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }
}

