/*
 * Decompiled with CFR 0.152.
 */
package carbon.beta;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.widget.DropDown;
import carbon.widget.LinearLayout;
import carbon.widget.TableView;
import carbon.widget.TextView;
import java.io.Serializable;

public class TableLayout
extends LinearLayout {
    private TableView table;
    LinearLayout header;
    View footer;
    DropDown rowNumber;
    private TextView pageNumbers;

    public TableLayout(Context context) {
        super(context);
        this.initTableLayout();
    }

    public TableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTableLayout();
    }

    public TableLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTableLayout();
    }

    @TargetApi(value=21)
    public TableLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initTableLayout();
    }

    private void initTableLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_tablelayout, (ViewGroup)this);
        this.setOrientation(1);
        this.header = (LinearLayout)this.findViewById(R.id.carbon_tableHeader);
        this.table = (TableView)this.findViewById(R.id.carbon_table);
        this.footer = this.findViewById(R.id.carbon_tableFooter);
        this.rowNumber = (DropDown)this.findViewById(R.id.carbon_tableRowNumber);
        this.rowNumber.setItems((Serializable[])new String[]{"10", "20", "50"});
        this.pageNumbers = (TextView)this.findViewById(R.id.carbon_tablePageNumbers);
    }

    public TableView getTableView() {
        return this.table;
    }

    public View getHeader() {
        return this.header;
    }

    public View getFooter() {
        return this.footer;
    }

    public void setAdapter(TableView.Adapter adapter) {
        this.table.setAdapter(adapter);
        this.header.removeAllViews();
        for (int i = 0; i < adapter.getColumnCount(); ++i) {
            View headerCell = View.inflate((Context)this.getContext(), (int)R.layout.carbon_tablelayout_header, null);
            TextView tv = (TextView)headerCell.findViewById(R.id.carbon_tableHeaderText);
            tv.setText(adapter.getColumnName(i));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1, adapter.getColumnWeight(i));
            this.header.addView(headerCell, (ViewGroup.LayoutParams)params);
        }
        this.rowNumber.setText("10");
        this.pageNumbers.setText("1-" + adapter.getItemCount() + " of " + adapter.getItemCount());
    }
}

