/*
 * Decompiled with CFR 0.152.
 */
package carbon.beta;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.beta.TransformedLayout;
import carbon.gesture.GestureDetector;
import carbon.gesture.OnGestureListener;
import carbon.widget.FrameLayout;

public class TransformationLayout
extends FrameLayout
implements OnGestureListener {
    GestureDetector detector;
    Matrix matrix = new Matrix();
    Matrix dm = new Matrix();
    float minX = 0.0f;
    float maxX = 0.0f;
    float minY = 0.0f;
    float maxY = 0.0f;
    float minScale = 1.0f;
    float maxScale = 2.0f;
    float minRotation = -100.0f;
    float maxRotation = 100.0f;
    float ax = 0.0f;
    float ay = 0.0f;
    float as = 1.0f;
    float ar = 0.0f;
    boolean tx = true;
    boolean ty = true;
    boolean sx = true;
    boolean sy = true;
    boolean r = true;

    public TransformationLayout(Context context) {
        super(context);
        this.initTransformationLayout();
    }

    public TransformationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTransformationLayout();
    }

    public TransformationLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTransformationLayout();
    }

    public TransformationLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initTransformationLayout();
    }

    private void initTransformationLayout() {
        this.detector = new GestureDetector(this.getContext());
        this.detector.addOnGestureListener(this);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.detector.shouldInterceptEvents(event)) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.detector.onTouchEvent(event);
        return true;
    }

    @Override
    public void onPress(MotionEvent motionEvent) {
    }

    @Override
    public void onTap(MotionEvent motionEvent, int clicks) {
    }

    @Override
    public void onDrag(MotionEvent motionEvent, float translationX, float translationY) {
    }

    @Override
    public void onLongPress(MotionEvent motionEvent) {
    }

    @Override
    public void onTransform(MotionEvent motionEvent, float cx, float cy, float dx, float dy, float dr, float scale) {
        this.dm.reset();
        this.dm.postTranslate(-cx, -cy);
        float s2 = Math.max(this.minScale, Math.min(this.as * scale, this.maxScale));
        this.dm.postScale(this.sx ? s2 / this.as : 0.0f, this.sy ? s2 / this.as : 0.0f);
        this.as = s2;
        if (this.r) {
            this.dm.postRotate((float)((double)(dr * 180.0f) / Math.PI));
        }
        this.dm.postTranslate(cx, cy);
        this.dm.postTranslate(this.tx ? dx : 0.0f, this.ty ? dy : 0.0f);
        TransformedLayout child = (TransformedLayout)this.getChildAt(0);
        this.matrix.postConcat(this.dm);
        child.setMatrix(this.matrix);
        child.postInvalidate();
    }
}

