/*
 * Decompiled with CFR 0.152.
 */
package carbon.component;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.component.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ComponentView
extends FrameLayout {
    Component component;

    public ComponentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ComponentView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public ComponentView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ComponentView, 0, 0);
        int id2 = a.getResourceId(R.styleable.ComponentView_carbon_id, 0);
        String type = a.getString(R.styleable.ComponentView_carbon_type);
        try {
            if (type == null) {
                throw new IllegalStateException("ComponentView needs a component type");
            }
            Constructor<?> constructor = Class.forName(type).getConstructor(ViewGroup.class);
            this.component = (Component)constructor.newInstance(new Object[]{this});
            View view = this.component.getView();
            view.setTag((Object)this.component);
            view.setId(id2);
            this.addView(view);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        a.recycle();
    }

    public <Type extends Component> Type getComponent() {
        return (Type)this.component;
    }
}

