/*
 * Decompiled with CFR 0.152.
 */
package carbon.component;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.databinding.CarbonNavigationHeaderBinding;
import carbon.widget.FrameLayout;

public class NavigationHeader
extends FrameLayout {
    private CarbonNavigationHeaderBinding binding;

    public NavigationHeader(Context context) {
        super(context);
        this.initNavigationHeader();
    }

    public NavigationHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initNavigationHeader();
    }

    public NavigationHeader(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initNavigationHeader();
    }

    public NavigationHeader(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initNavigationHeader();
    }

    private void initNavigationHeader() {
        this.binding = CarbonNavigationHeaderBinding.inflate(LayoutInflater.from((Context)this.getContext()));
    }

    public void setItem(Item item) {
        this.binding.carbonAvatar.setImageDrawable(item.icon);
        this.binding.carbonText.setText(item.text);
        this.binding.carbonSubtext.setText(item.subtext);
    }

    public static class Item {
        private final Drawable icon;
        private final String text;
        private final String subtext;

        public Item(Drawable icon, String text, String subtext) {
            this.icon = icon;
            this.text = text;
            this.subtext = subtext;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }

        public String getSubtext() {
            return this.subtext;
        }
    }
}

