/*
 * Decompiled with CFR 0.152.
 */
package carbon.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import carbon.Carbon;
import carbon.R;
import carbon.widget.Button;
import carbon.widget.Divider;
import carbon.widget.LinearLayout;
import carbon.widget.TextView;

public abstract class DialogBase
extends Dialog {
    private LinearLayout container;
    private TextView titleTextView;
    private ViewGroup buttonContainer;
    private View dialogLayout;
    protected Divider topDivider;
    protected Divider bottomDivider;
    private View contentView;

    public DialogBase(@NonNull Context context) {
        super(context, Carbon.getThemeResId(context, 16843528));
        this.initLayout();
    }

    public DialogBase(@NonNull Context context, @StyleRes int themeResId) {
        super(context, themeResId);
        this.initLayout();
    }

    public void setContentView(@LayoutRes int layoutResID) {
        this.setContentView(this.getLayoutInflater().inflate(layoutResID, null), null);
    }

    public void setContentView(@NonNull View view) {
        this.setContentView(view, null);
    }

    public void setContentView(@NonNull View view, ViewGroup.LayoutParams params) {
        this.contentView = view;
        this.contentView.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.onContentHeightChanged(this.contentView.getHeight()));
        this.container.addView(view);
    }

    public View getContentView() {
        return this.contentView;
    }

    private void initLayout() {
        this.requestWindowFeature(1);
        this.dialogLayout = this.getLayoutInflater().inflate(R.layout.carbon_dialog, null);
        this.container = (LinearLayout)this.dialogLayout.findViewById(R.id.carbon_windowContent);
        super.setContentView(this.dialogLayout);
    }

    protected void onContentHeightChanged(int contentHeight) {
        if (this.topDivider != null) {
            this.topDivider.setVisibility(8);
        }
        if (this.bottomDivider != null) {
            this.bottomDivider.setVisibility(8);
        }
    }

    public void setTitle(@Nullable CharSequence title) {
        if (this.titleTextView == null && title != null) {
            this.container.addView(this.getLayoutInflater().inflate(R.layout.carbon_dialog_header, null), 0);
            this.titleTextView = (TextView)this.dialogLayout.findViewById(R.id.carbon_windowTitle);
            this.titleTextView.setText(title);
            this.topDivider = (Divider)this.dialogLayout.findViewById(R.id.carbon_topDivider);
        } else if (this.titleTextView != null && title == null) {
            this.container.removeViewAt(0);
            this.titleTextView = null;
            this.topDivider = null;
        }
    }

    public void setTitle(@StringRes int titleId) {
        this.setTitle(this.getContext().getResources().getString(titleId));
    }

    @Deprecated
    public void setNegativeButton(String text, View.OnClickListener listener) {
        this.addButton(text, listener);
    }

    @Deprecated
    public void setPositiveButton(String text, View.OnClickListener listener) {
        this.addButton(text, listener);
    }

    public void addButton(String text, View.OnClickListener listener) {
        if (this.buttonContainer == null) {
            this.container.addView(this.getLayoutInflater().inflate(R.layout.carbon_dialog_footer, null));
            this.buttonContainer = (ViewGroup)this.dialogLayout.findViewById(R.id.carbon_buttonContainer);
            this.bottomDivider = (Divider)this.dialogLayout.findViewById(R.id.carbon_bottomDivider);
        }
        Button button = (Button)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.carbon_dialog_button, this.buttonContainer, false);
        button.setText(text);
        button.setOnClickListener(v -> {
            if (listener != null) {
                listener.onClick(v);
            }
            this.dismiss();
        });
        this.buttonContainer.addView((View)button);
        this.buttonContainer.setVisibility(0);
    }

    public boolean hasButtons() {
        return this.buttonContainer != null;
    }

    public boolean hasTitle() {
        return this.titleTextView != null;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.container.setMinimumWidth(minimumWidth);
    }

    public void setMinimumHeight(int minimumHeight) {
        this.container.setMinimumHeight(minimumHeight);
    }
}

