/*
 * Decompiled with CFR 0.152.
 */
package carbon.dialog;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import carbon.R;
import carbon.dialog.DialogBase;
import carbon.recycler.RowFactory;
import carbon.recycler.RowListAdapter;
import carbon.widget.LinearLayout;
import carbon.widget.RecyclerView;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ListDialog<Type extends Serializable>
extends DialogBase {
    protected RecyclerView recyclerView;
    protected RowListAdapter<Type> adapter;
    protected List<Type> items;
    protected RecyclerView.OnItemClickedListener<Type> listener;
    private RecyclerView.OnItemClickedListener<Type> internalListener = this.getInternalListener();

    public ListDialog(@NonNull Context context) {
        super(context);
        this.init();
    }

    public ListDialog(@NonNull Context context, @StyleRes int themeResId) {
        super(context, themeResId);
        this.init();
    }

    private void init() {
        this.recyclerView = new RecyclerView(this.getContext());
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        int padding = this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf);
        this.recyclerView.setPadding(0, padding, 0, padding);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        super.setContentView((View)this.recyclerView, null);
    }

    protected RecyclerView.OnItemClickedListener<Type> getInternalListener() {
        return (view, item, position) -> {
            if (this.listener != null) {
                this.listener.onItemClicked(view, (Serializable)item, position);
            }
            this.dismiss();
        };
    }

    @Override
    protected void onContentHeightChanged(int contentHeight) {
        int padding = this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf);
        int height = padding * 2;
        for (int i = 0; i < this.recyclerView.getChildCount(); ++i) {
            height += this.recyclerView.getChildAt(i).getHeight();
        }
        if ((height += this.recyclerView.getAdapter().getItemCount() - this.recyclerView.getChildCount()) > contentHeight) {
            if (this.topDivider != null) {
                this.topDivider.setVisibility(0);
            }
            if (this.bottomDivider != null) {
                this.bottomDivider.setVisibility(0);
            }
        } else {
            if (this.topDivider != null) {
                this.topDivider.setVisibility(8);
            }
            if (this.bottomDivider != null) {
                this.bottomDivider.setVisibility(8);
            }
        }
    }

    @Override
    public void setContentView(@LayoutRes int layoutResID) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setContentView(@NonNull View view) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setContentView(@NonNull View view, ViewGroup.LayoutParams params) {
        throw new RuntimeException("not supported");
    }

    public void setItems(Type[] items, RowFactory<Type> factory) {
        this.items = Arrays.asList(items);
        this.adapter = new RowListAdapter(this.items, factory);
        this.adapter.setOnItemClickedListener(this.internalListener);
        this.recyclerView.setAdapter(this.adapter);
    }

    public void setItems(List<Type> items, RowFactory<Type> factory) {
        this.items = items;
        this.adapter = new RowListAdapter(items, factory);
        this.adapter.setOnItemClickedListener(this.internalListener);
        this.recyclerView.setAdapter(this.adapter);
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<Type> listener) {
        this.listener = listener;
    }
}

