/*
 * Decompiled with CFR 0.152.
 */
package carbon.dialog;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import carbon.R;
import carbon.dialog.DialogBase;
import carbon.widget.TextView;

public class TextDialog
extends DialogBase {
    private TextView textView;

    public TextDialog(@NonNull Context context) {
        super(context);
        this.initProgressDialog();
    }

    public TextDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        this.initProgressDialog();
    }

    private void initProgressDialog() {
        this.setContentView(R.layout.carbon_textdialog);
        this.textView = (TextView)this.findViewById(R.id.carbon_dialogText);
        this.setMinimumWidth(0);
    }

    public void setText(int resId) {
        this.setText(this.getContext().getResources().getString(resId));
    }

    public void setText(CharSequence text) {
        this.textView.setText(text);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.textView.setVisibility(8);
            this.setMinimumWidth(0);
        } else {
            this.textView.setVisibility(0);
            this.setMinimumWidth(this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_dialogMinimumWidth));
        }
    }

    @Override
    public void setTitle(@Nullable CharSequence title) {
        super.setTitle(title);
        int padding = this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_dialogPadding);
        this.getContentView().setPadding(padding, 0, padding, this.hasButtons() ? 0 : padding);
    }

    @Override
    public void addButton(String text, View.OnClickListener listener) {
        super.addButton(text, listener);
        int padding = this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_dialogPadding);
        this.getContentView().setPadding(padding, this.hasTitle() ? 0 : padding, padding, 0);
    }
}

