/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AlphaWithParentDrawable
extends Drawable {
    private View owner;
    private Drawable alphaDrawable;

    public AlphaWithParentDrawable(View owner, Drawable alphaDrawable) {
        this.owner = owner;
        this.alphaDrawable = alphaDrawable;
    }

    public void draw(@NonNull Canvas canvas) {
        try {
            Drawable bg = null;
            View p = this.owner;
            while ((p = (View)p.getParent()) != null && (bg = p.getBackground()) == null) {
            }
            if (bg == null) {
                bg = ((Activity)this.owner.getContext()).getWindow().getDecorView().getBackground();
            }
            bg.draw(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alphaDrawable.draw(canvas);
    }

    public void setAlpha(int i) {
        this.alphaDrawable.setAlpha(i);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.alphaDrawable.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.alphaDrawable.getOpacity();
    }

    public void setBounds(@NonNull Rect bounds) {
        this.alphaDrawable.setBounds(bounds);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        this.alphaDrawable.setBounds(left, top, right, bottom);
    }

    public boolean isStateful() {
        return this.alphaDrawable.isStateful();
    }

    public boolean setState(@NonNull int[] stateSet) {
        return this.alphaDrawable.setState(stateSet);
    }

    public void jumpToCurrentState() {
        this.alphaDrawable.jumpToCurrentState();
    }

    public static class AlphaWithParentColorStateList
    extends ColorStateList {
        public AlphaWithParentColorStateList(int[][] states, int[] colors) {
            super(states, colors);
        }
    }
}

