/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.core.graphics.drawable.TintAwareDrawable;
import carbon.drawable.ProgressDrawable;
import carbon.widget.ProgressView;

public class CircularProgressDrawable
extends ProgressDrawable
implements TintAwareDrawable {
    private static final long DEFAULT_SWEEP_DURATION = 3000L;
    private static final long DEFAULT_ANGLE_DURATION = 1000L;
    private long sweepDuration = 3000L;
    private long angleDuration = 1000L;
    Interpolator interpolator2 = new DecelerateInterpolator();
    Interpolator interpolator = new AccelerateDecelerateInterpolator();

    public CircularProgressDrawable() {
        this.forePaint.setStyle(Paint.Style.STROKE);
        this.forePaint.setColor(-1);
    }

    public int getMinimumWidth() {
        return (int)this.getBarWidth() * 2;
    }

    public int getMinimumHeight() {
        return (int)this.getBarWidth() * 2;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        this.forePaint.setStrokeWidth(this.width);
        RectF boundsF = new RectF(bounds);
        boundsF.inset(this.width / 2.0f + this.barPadding + 0.1f, this.width / 2.0f + this.barPadding + 0.1f);
        if (this.style != ProgressView.Style.CircularDeterminate) {
            long time = System.currentTimeMillis() - this.startTime;
            float t = (float)(time % this.angleDuration) / (float)this.angleDuration;
            float t2 = (float)(time % this.sweepDuration) / (float)this.sweepDuration;
            float bar = Math.min((t - t2 + 1.0f) % 1.0f, (t2 - t + 1.0f) % 1.0f);
            bar = this.interpolator.getInterpolation(bar) * 2.0f * 300.0f + 30.0f;
            canvas.drawArc(boundsF, (t * 360.0f - bar / 2.0f + 360.0f) % 360.0f, bar, false, this.forePaint);
        } else {
            long time = System.currentTimeMillis() - this.startTime;
            float t = Math.min((float)time / (float)this.angleDuration, 1.0f);
            canvas.drawArc(boundsF, this.interpolator2.getInterpolation(t) * 360.0f - 90.0f, this.progress * 360.0f, false, this.forePaint);
        }
        this.invalidateSelf();
    }
}

