/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import carbon.animation.AnimatedColorStateList;
import carbon.drawable.AlphaDrawable;

public class ColorStateListDrawable
extends Drawable
implements AlphaDrawable {
    private ColorStateList list;

    public ColorStateListDrawable(ColorStateList list) {
        this.list = list;
    }

    public void draw(@NonNull Canvas canvas) {
        canvas.drawColor(this.list.getColorForState(this.getState(), this.list.getDefaultColor()));
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(@NonNull int[] stateSet) {
        if (this.list instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.list).setState(stateSet);
        }
        return super.setState(stateSet);
    }

    @Override
    public int getAlpha() {
        return this.list.getColorForState(this.getState(), this.list.getDefaultColor()) >> 24 & 0xFF;
    }
}

