/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import carbon.drawable.ProgressDrawable;
import carbon.widget.ProgressView;

public class ProgressBarDrawable
extends ProgressDrawable {
    private static final long DEFAULT_SWEEP_DURATION = 800L;
    private static final long DEFAULT_SWEEP_OFFSET = 500L;
    private long sweepDuration = 800L;
    private long sweepDelay = 500L;
    private Interpolator interpolator = new AccelerateDecelerateInterpolator();

    public ProgressBarDrawable() {
        this.forePaint.setStyle(Paint.Style.FILL);
        this.forePaint.setColor(-1);
    }

    public int getMinimumHeight() {
        return (int)this.getBarWidth();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.style == ProgressView.Style.BarIndeterminate) {
            long time = (System.currentTimeMillis() - this.startTime) % (this.sweepDuration + this.sweepDelay);
            float t = (float)time / (float)this.sweepDuration;
            float t2 = Math.max(0.0f, (float)(time - this.sweepDelay) / (float)this.sweepDuration);
            float end = this.interpolator.getInterpolation(t2);
            canvas.drawRect(end * (float)bounds.width(), this.getBarPadding(), t * (float)bounds.width(), (float)bounds.height(), this.forePaint);
        } else if (this.style == ProgressView.Style.BarQuery) {
            long time = (System.currentTimeMillis() - this.startTime) % (this.sweepDuration + this.sweepDelay);
            float t = 1.0f - (float)time / (float)this.sweepDuration;
            float t2 = Math.max(0.0f, (float)(time - this.sweepDelay) / (float)this.sweepDuration);
            float end = 1.0f - this.interpolator.getInterpolation(t2);
            canvas.drawRect(t * (float)bounds.width(), this.getBarPadding(), end * (float)bounds.width(), (float)bounds.height(), this.forePaint);
        } else {
            canvas.drawRect(0.0f, this.getBarPadding(), this.progress * (float)bounds.width(), (float)bounds.height(), this.forePaint);
        }
        this.invalidateSelf();
    }
}

