/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import carbon.widget.ProgressView;

public abstract class ProgressDrawable
extends Drawable {
    private static final long DEFAULT_SWEEP_DURATION = 800L;
    private static final long DEFAULT_SWEEP_OFFSET = 500L;
    private long sweepDuration = 800L;
    private long sweepDelay = 500L;
    final long startTime = System.currentTimeMillis();
    Paint forePaint = new Paint(1);
    private ColorStateList tint = ColorStateList.valueOf((int)-65536);
    private PorterDuff.Mode tintMode;
    float width = 5.0f;
    float progress;
    float barPadding;
    ProgressView.Style style;

    public void setAlpha(int alpha) {
        this.forePaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.forePaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public boolean setState(@NonNull int[] stateSet) {
        return super.setState(stateSet);
    }

    public void setProgress(float progress) {
        this.progress = Math.max(0.0f, Math.min(progress, 1.0f));
    }

    public float getProgress() {
        return this.progress;
    }

    public long getSweepDuration() {
        return this.sweepDuration;
    }

    public void setSweepDuration(long sweepDuration) {
        this.sweepDuration = sweepDuration;
    }

    public long getSweepDelay() {
        return this.sweepDelay;
    }

    public void setSweepDelay(long sweepDelay) {
        this.sweepDelay = sweepDelay;
    }

    public float getBarWidth() {
        return this.width;
    }

    public void setBarWidth(float width) {
        this.width = width;
    }

    public ProgressView.Style getStyle() {
        return this.style;
    }

    public void setStyle(ProgressView.Style style2) {
        this.style = style2;
    }

    public float getBarPadding() {
        return this.barPadding;
    }

    public void setBarPadding(float barPadding) {
        this.barPadding = barPadding;
    }

    public void setTintList(ColorStateList list) {
        this.tint = list;
        this.updateTint();
    }

    public void setTint(int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.tintMode = tintMode;
        this.updateTint();
    }

    private void updateTint() {
        if (this.tint != null && this.tintMode != null) {
            int color2 = this.tint.getColorForState(this.getState(), this.tint.getDefaultColor());
            this.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, this.tintMode));
            this.setAlpha(Color.alpha((int)color2));
        } else {
            this.setColorFilter(null);
            this.setAlpha(255);
        }
    }
}

