/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.TintAwareDrawable;

public class UnderlineDrawable
extends Drawable
implements TintAwareDrawable {
    private Paint paint = new Paint(1);
    private float thickness = 1.0f;
    private float padding = 0.0f;
    @Nullable
    private ColorFilter colorFilter;
    @Nullable
    private ColorStateList tint;
    private PorterDuff.Mode tintMode;

    public UnderlineDrawable() {
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        int[] states = this.getState();
        boolean focused = false;
        boolean enabled = false;
        for (int state : states) {
            if (state == 16842908) {
                focused = true;
                continue;
            }
            if (state != 16842910) continue;
            enabled = true;
        }
        this.updateTint();
        if (!enabled) {
            int i = 0;
            while (i < bounds.width()) {
                canvas.drawCircle((float)i + this.thickness / 2.0f, (float)bounds.height() - this.thickness / 2.0f - this.padding / 2.0f, this.thickness / 2.0f, this.paint);
                i = (int)((float)i + this.thickness * 3.0f);
            }
        } else if (focused) {
            canvas.drawRect(0.0f, (float)bounds.height() - this.thickness * 2.0f - this.padding / 2.0f, (float)bounds.width(), (float)bounds.height() - this.padding / 2.0f, this.paint);
        } else {
            canvas.drawRect(0.0f, (float)bounds.height() - this.thickness - this.padding / 2.0f, (float)bounds.width(), (float)bounds.height() - this.padding / 2.0f, this.paint);
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(@NonNull int[] stateSet) {
        return super.setState(stateSet);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
        this.tint = null;
        this.tintMode = null;
    }

    public void setTint(int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setTintList(@Nullable ColorStateList tint) {
        this.colorFilter = null;
        this.tint = tint;
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.colorFilter = null;
        this.tintMode = tintMode;
    }

    public void updateTint() {
        if (this.colorFilter != null) {
            this.paint.setColor(-1);
            this.paint.setColorFilter(this.colorFilter);
        } else if (this.tint != null && this.tintMode != null) {
            this.paint.setColor(this.tint.getColorForState(this.getState(), this.tint.getDefaultColor()));
            this.paint.setColorFilter(null);
        } else {
            this.paint.setColor(-1);
            this.paint.setColorFilter(null);
        }
    }

    public int getOpacity() {
        return -3;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public void setPaddingBottom(float padding) {
        this.padding = padding;
    }
}

